/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tx;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.tx.TransactionDescriptor;
import org.apache.cayenne.tx.TransactionManager;
import org.apache.cayenne.tx.TransactionPropagation;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UseServerRuntime(value="cayenne-testmap.xml")
public class TransactionIsolationIT
extends ServerCase {
    private final Logger logger = LoggerFactory.getLogger(TransactionIsolationIT.class);
    @Inject
    DataContext context;
    @Inject
    ServerRuntime runtime;
    @Inject
    UnitDbAdapter unitDbAdapter;
    TransactionManager manager;

    @Before
    public void initTransactionManager() {
        this.manager = (TransactionManager)this.runtime.getInjector().getInstance(TransactionManager.class);
    }

    @Test
    public void testIsolationLevel() throws Exception {
        if (!this.unitDbAdapter.supportsSerializableTransactionIsolation()) {
            return;
        }
        TransactionDescriptor descriptor = new TransactionDescriptor(8, TransactionPropagation.REQUIRES_NEW);
        CountDownLatch startSignal = new CountDownLatch(1);
        CountDownLatch resumeSerializableTransaction = new CountDownLatch(1);
        ExecutorService service = Executors.newFixedThreadPool(2);
        Future<Boolean> thread1Result = service.submit(() -> {
            try {
                return this.manager.performInTransaction(() -> {
                    long result;
                    try {
                        result = ObjectSelect.query(Artist.class).selectCount(this.context);
                    }
                    finally {
                        startSignal.countDown();
                    }
                    if (result != 0L) {
                        this.logger.error("First fetch returned " + result);
                        return false;
                    }
                    try {
                        resumeSerializableTransaction.await();
                    }
                    catch (InterruptedException e) {
                        this.logger.error("Resume signal await failed", (Throwable)e);
                        return false;
                    }
                    result = ObjectSelect.query(Artist.class).selectCount(this.context);
                    this.logger.info("Second fetch returned " + result);
                    return result == 0L;
                }, descriptor);
            }
            catch (Exception ex) {
                this.logger.error("Perform in transaction failed", (Throwable)ex);
                return false;
            }
        });
        Future<Boolean> thread2Result = service.submit(() -> {
            try {
                startSignal.await();
                try {
                    Artist artist = this.context.newObject(Artist.class);
                    artist.setArtistName("artist");
                    this.context.commitChanges();
                }
                finally {
                    resumeSerializableTransaction.countDown();
                }
            }
            catch (Exception ex) {
                this.logger.error("Unable to create Artist", (Throwable)ex);
                return false;
            }
            return true;
        });
        Assert.assertTrue((boolean)thread1Result.get(30L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)thread2Result.get(30L, TimeUnit.SECONDS));
    }
}

