/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tx;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.tx.BaseTransaction;
import org.apache.cayenne.tx.DefaultTransactionManager;
import org.apache.cayenne.tx.Transaction;
import org.apache.cayenne.tx.TransactionDescriptor;
import org.apache.cayenne.tx.TransactionFactory;
import org.apache.cayenne.tx.TransactionPropagation;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class DefaultTransactionManagerIT {
    @Test
    public void testPerformInTransaction_Local() {
        BaseTransaction tx = (BaseTransaction)Mockito.mock(BaseTransaction.class);
        DefaultTransactionManager txManager = this.createDefaultTxManager(() -> tx);
        Object expectedResult = new Object();
        Object result = txManager.performInTransaction(() -> {
            Assert.assertSame((Object)tx, (Object)BaseTransaction.getThreadTransaction());
            return expectedResult;
        });
        Assert.assertSame((Object)expectedResult, (Object)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPerformInTransaction_ExistingTx() {
        BaseTransaction tx1 = (BaseTransaction)Mockito.mock(BaseTransaction.class);
        DefaultTransactionManager txManager = this.createDefaultTxManager(() -> tx1);
        BaseTransaction tx2 = (BaseTransaction)Mockito.mock(BaseTransaction.class);
        BaseTransaction.bindThreadTransaction(tx2);
        try {
            Object expectedResult = new Object();
            Object result = txManager.performInTransaction(() -> {
                Assert.assertSame((Object)tx2, (Object)BaseTransaction.getThreadTransaction());
                return expectedResult;
            });
            Assert.assertSame((Object)expectedResult, (Object)result);
        }
        finally {
            BaseTransaction.bindThreadTransaction(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNestedPropagation() {
        BaseTransaction tx = (BaseTransaction)Mockito.mock(BaseTransaction.class);
        Assert.assertNull((Object)BaseTransaction.getThreadTransaction());
        DefaultTransactionManager txManager = this.createDefaultTxManager(() -> tx);
        try {
            Object expectedResult = new Object();
            Object result = txManager.performInTransaction(() -> {
                Assert.assertSame((Object)tx, (Object)BaseTransaction.getThreadTransaction());
                return expectedResult;
            }, new TransactionDescriptor(TransactionPropagation.NESTED));
            Assert.assertSame((Object)expectedResult, (Object)result);
        }
        finally {
            BaseTransaction.bindThreadTransaction(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=CayenneRuntimeException.class)
    public void testMandatoryPropagationNotStarted() {
        BaseTransaction tx = (BaseTransaction)Mockito.mock(BaseTransaction.class);
        Assert.assertNull((Object)BaseTransaction.getThreadTransaction());
        DefaultTransactionManager txManager = this.createDefaultTxManager(() -> tx);
        try {
            Object expectedResult = new Object();
            Object result = txManager.performInTransaction(() -> {
                Assert.assertSame((Object)tx, (Object)BaseTransaction.getThreadTransaction());
                return expectedResult;
            }, new TransactionDescriptor(TransactionPropagation.MANDATORY));
            Assert.assertSame((Object)expectedResult, (Object)result);
        }
        finally {
            BaseTransaction.bindThreadTransaction(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMandatoryPropagation() {
        BaseTransaction tx = (BaseTransaction)Mockito.mock(BaseTransaction.class);
        Assert.assertNull((Object)BaseTransaction.getThreadTransaction());
        DefaultTransactionManager txManager = this.createDefaultTxManager(() -> tx);
        BaseTransaction.bindThreadTransaction(tx);
        try {
            Object expectedResult = new Object();
            Object result = txManager.performInTransaction(() -> {
                Assert.assertSame((Object)tx, (Object)BaseTransaction.getThreadTransaction());
                return expectedResult;
            }, new TransactionDescriptor(TransactionPropagation.MANDATORY));
            Assert.assertSame((Object)expectedResult, (Object)result);
        }
        finally {
            BaseTransaction.bindThreadTransaction(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRequiresNewPropagation() {
        BaseTransaction tx1 = (BaseTransaction)Mockito.mock(BaseTransaction.class);
        BaseTransaction tx2 = (BaseTransaction)Mockito.mock(BaseTransaction.class);
        AtomicInteger counter = new AtomicInteger(0);
        Assert.assertNull((Object)BaseTransaction.getThreadTransaction());
        DefaultTransactionManager txManager = this.createDefaultTxManager(() -> {
            counter.incrementAndGet();
            return tx2;
        });
        BaseTransaction.bindThreadTransaction(tx1);
        try {
            Object expectedResult = new Object();
            Object result = txManager.performInTransaction(() -> {
                Assert.assertSame((Object)tx2, (Object)BaseTransaction.getThreadTransaction());
                return expectedResult;
            }, new TransactionDescriptor(TransactionPropagation.REQUIRES_NEW));
            Assert.assertSame((Object)expectedResult, (Object)result);
            Assert.assertSame((Object)tx1, (Object)BaseTransaction.getThreadTransaction());
        }
        finally {
            BaseTransaction.bindThreadTransaction(null);
        }
    }

    private DefaultTransactionManager createDefaultTxManager(Supplier<Transaction> txSupplier) {
        return new DefaultTransactionManager(this.createMockFactory(txSupplier), (JdbcEventLogger)Mockito.mock(JdbcEventLogger.class));
    }

    private TransactionFactory createMockFactory(Supplier<Transaction> supplier) {
        TransactionFactory txFactory = (TransactionFactory)Mockito.mock(TransactionFactory.class);
        Mockito.when((Object)txFactory.createTransaction()).thenReturn((Object)supplier.get());
        Mockito.when((Object)txFactory.createTransaction((TransactionDescriptor)ArgumentMatchers.any(TransactionDescriptor.class))).thenReturn((Object)supplier.get());
        return txFactory;
    }
}

