/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.List;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.Property;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.primitive.PrimitivesTestEntity;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-primitive.xml")
public class ObjectSelect_PrimitiveColumnsIT
extends ServerCase {
    @Inject
    private DataContext context;
    @Inject
    private DBHelper dbHelper;
    @Inject
    private UnitDbAdapter unitDbAdapter;
    private TableHelper tPrimitives;

    @Before
    public void createTestRecords() throws Exception {
        this.tPrimitives = new TableHelper(this.dbHelper, "PRIMITIVES_TEST");
        this.tPrimitives.setColumns(new String[]{"ID", "BOOLEAN_COLUMN", "INT_COLUMN"});
        for (int i = 1; i <= 20; ++i) {
            this.tPrimitives.insert(new Object[]{i, i % 2 == 0, i * 10});
        }
    }

    @Test
    public void test_SelectIntegerColumn() throws Exception {
        int intColumn2 = (Integer)ObjectSelect.query(PrimitivesTestEntity.class).column(PrimitivesTestEntity.INT_COLUMN).orderBy(PrimitivesTestEntity.INT_COLUMN.asc()).selectFirst(this.context);
        Assert.assertEquals((long)10L, (long)intColumn2);
    }

    @Test
    public void test_SelectIntegerList() throws Exception {
        List intColumns = ObjectSelect.query(PrimitivesTestEntity.class).column(PrimitivesTestEntity.INT_COLUMN).orderBy(PrimitivesTestEntity.INT_COLUMN.asc()).select(this.context);
        Assert.assertEquals((long)20L, (long)intColumns.size());
        Assert.assertEquals((long)10L, (long)((Integer)intColumns.get(0)).intValue());
    }

    @Test
    public void test_SelectIntegerExpColumn() throws Exception {
        Property<Integer> property = Property.create("intColumn", ExpressionFactory.exp("(obj:intColumn + obj:intColumn)", new Object[0]), Integer.class);
        int intColumn2 = ObjectSelect.query(PrimitivesTestEntity.class).column(property).orderBy(PrimitivesTestEntity.INT_COLUMN.asc()).selectFirst(this.context);
        Assert.assertEquals((long)20L, (long)intColumn2);
    }

    @Test
    public void test_SelectBooleanColumn() throws Exception {
        boolean boolColumn = (Boolean)ObjectSelect.query(PrimitivesTestEntity.class).column(PrimitivesTestEntity.BOOLEAN_COLUMN).orderBy(PrimitivesTestEntity.INT_COLUMN.asc()).selectFirst(this.context);
        Assert.assertEquals((Object)false, (Object)boolColumn);
    }

    @Test
    public void test_SelectBooleanList() throws Exception {
        List intColumns = ObjectSelect.query(PrimitivesTestEntity.class).column(PrimitivesTestEntity.BOOLEAN_COLUMN).orderBy(PrimitivesTestEntity.INT_COLUMN.asc()).select(this.context);
        Assert.assertEquals((long)20L, (long)intColumns.size());
        Assert.assertEquals((Object)false, intColumns.get(0));
    }

    @Test
    public void test_SelectBooleanExpColumn() throws Exception {
        if (!this.unitDbAdapter.supportsSelectBooleanExpression()) {
            return;
        }
        Property<Boolean> property = Property.create("boolColumn", ExpressionFactory.exp("(obj:intColumn < 10)", new Object[0]), Boolean.class);
        boolean boolColumn = ObjectSelect.query(PrimitivesTestEntity.class).column(property).orderBy(PrimitivesTestEntity.INT_COLUMN.asc()).selectFirst(this.context);
        Assert.assertEquals((Object)false, (Object)boolColumn);
    }

    @Test
    public void test_SelectColumnsList() throws Exception {
        List columns = ObjectSelect.query(PrimitivesTestEntity.class).columns(PrimitivesTestEntity.INT_COLUMN, PrimitivesTestEntity.BOOLEAN_COLUMN).orderBy(PrimitivesTestEntity.INT_COLUMN.asc()).select(this.context);
        Assert.assertEquals((long)20L, (long)columns.size());
        Object[] result = new Object[]{10, false};
        Assert.assertArrayEquals((Object[])result, (Object[])((Object[])columns.get(0)));
    }

    @Test
    public void test_SelectColumnsExpList() throws Exception {
        if (!this.unitDbAdapter.supportsSelectBooleanExpression()) {
            return;
        }
        Property<Integer> intProperty = Property.create("intColumn", ExpressionFactory.exp("(obj:intColumn + 1)", new Object[0]), Integer.class);
        Property<Boolean> boolProperty = Property.create("boolColumn", ExpressionFactory.exp("(obj:intColumn = 10)", new Object[0]), Boolean.class);
        List columns = ObjectSelect.query(PrimitivesTestEntity.class).columns(intProperty, boolProperty).orderBy(PrimitivesTestEntity.INT_COLUMN.asc()).select(this.context);
        Assert.assertEquals((long)20L, (long)columns.size());
        Object[] result = new Object[]{11, true};
        Assert.assertArrayEquals((Object[])result, (Object[])((Object[])columns.get(0)));
    }

    @Test
    public void testSum() throws Exception {
        int sum = (Integer)ObjectSelect.query(PrimitivesTestEntity.class).sum(PrimitivesTestEntity.INT_COLUMN).selectOne(this.context);
        Assert.assertEquals((long)2100L, (long)sum);
    }

    @Test
    public void testAvg() throws Exception {
        int avg = (Integer)ObjectSelect.query(PrimitivesTestEntity.class).avg(PrimitivesTestEntity.INT_COLUMN).selectOne(this.context);
        Assert.assertEquals((double)105.0, (double)avg, (double)1.0E-5);
    }

    @Test
    public void testOrderByCount() throws Exception {
        this.tPrimitives.insert(new Object[]{21, true, 210});
        List res = ObjectSelect.columnQuery(PrimitivesTestEntity.class, PrimitivesTestEntity.BOOLEAN_COLUMN, PrimitivesTestEntity.INT_COLUMN.count()).orderBy(PrimitivesTestEntity.INT_COLUMN.count().asc()).select(this.context);
        Assert.assertEquals((long)2L, (long)res.size());
        Assert.assertEquals((Object)false, (Object)((Object[])res.get(0))[0]);
        Assert.assertEquals((Object)true, (Object)((Object[])res.get(1))[0]);
        Assert.assertEquals((Object)10L, (Object)((Object[])res.get(0))[1]);
        Assert.assertEquals((Object)11L, (Object)((Object[])res.get(1))[1]);
    }
}

