/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.query.BatchQuery;
import org.apache.cayenne.query.BatchQueryRow;

public class DeleteBatchQuery
extends BatchQuery {
    protected boolean usingOptimisticLocking;
    private Collection<String> nullQualifierNames;

    public DeleteBatchQuery(DbEntity dbEntity, List<DbAttribute> qualifierAttributes, Collection<String> nullQualifierNames, int batchCapacity) {
        super(dbEntity, qualifierAttributes, batchCapacity);
        if (nullQualifierNames == null) {
            throw new NullPointerException("Null 'nullQualifierNames'");
        }
        this.nullQualifierNames = nullQualifierNames;
    }

    public boolean isNull(DbAttribute attribute) {
        return this.nullQualifierNames.contains(attribute.getName());
    }

    @Override
    public boolean isUsingOptimisticLocking() {
        return this.usingOptimisticLocking;
    }

    public void setUsingOptimisticLocking(boolean usingOptimisticLocking) {
        this.usingOptimisticLocking = usingOptimisticLocking;
    }

    public void add(Map<String, Object> dataObjectId) {
        this.rows.add(new BatchQueryRow(null, dataObjectId){

            @Override
            public Object getValue(int i) {
                return this.qualifier.get(((DbAttribute)DeleteBatchQuery.this.dbAttributes.get(i)).getName());
            }
        });
    }
}

