/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.HashMap;
import java.util.List;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.compound.CompoundFkTestEntity;
import org.apache.cayenne.testdo.compound.CompoundPkTestEntity;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-compound.xml")
public class DataContextEJBQLQueryCompoundIT
extends ServerCase {
    @Inject
    private ObjectContext context;
    @Inject
    private DBHelper dbHelper;
    @Inject
    private UnitDbAdapter accessStackAdapter;
    private TableHelper tCompoundPk;
    private TableHelper tCompoundFk;

    @Before
    public void setUp() throws Exception {
        this.tCompoundPk = new TableHelper(this.dbHelper, "COMPOUND_PK_TEST");
        this.tCompoundPk.setColumns(new String[]{"KEY1", "KEY2"});
        this.tCompoundFk = new TableHelper(this.dbHelper, "COMPOUND_FK_TEST");
        this.tCompoundFk.setColumns(new String[]{"PKEY", "F_KEY1", "F_KEY2"});
    }

    private void createTwoCompoundPKTwoFK() throws Exception {
        this.tCompoundPk.insert(new Object[]{"a1", "a2"});
        this.tCompoundPk.insert(new Object[]{"b1", "b2"});
        this.tCompoundFk.insert(new Object[]{33001, "a1", "a2"});
        this.tCompoundFk.insert(new Object[]{33002, "b1", "b2"});
    }

    @Test
    public void testSelectFromWhereMatchOnMultiColumnObject() throws Exception {
        this.createTwoCompoundPKTwoFK();
        HashMap<String, String> key1 = new HashMap<String, String>();
        key1.put("KEY1", "b1");
        key1.put("KEY2", "b2");
        CompoundPkTestEntity a = Cayenne.objectForPK(this.context, CompoundPkTestEntity.class, key1);
        String ejbql = "select e from CompoundFkTestEntity e WHERE e.toCompoundPk = :param";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        query.setParameter("param", (Object)a);
        List ps = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)ps.size());
        CompoundFkTestEntity o1 = (CompoundFkTestEntity)ps.get(0);
        Assert.assertEquals((long)33002L, (long)Cayenne.intPKForObject(o1));
    }

    @Test
    public void testSelectFromWhereMatchOnMultiColumnObjectReverse() throws Exception {
        if (!this.accessStackAdapter.supportsReverseComparison()) {
            return;
        }
        this.createTwoCompoundPKTwoFK();
        HashMap<String, String> key1 = new HashMap<String, String>();
        key1.put("KEY1", "b1");
        key1.put("KEY2", "b2");
        CompoundPkTestEntity a = Cayenne.objectForPK(this.context, CompoundPkTestEntity.class, key1);
        String ejbql = "select e from CompoundFkTestEntity e WHERE :param = e.toCompoundPk";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        query.setParameter("param", (Object)a);
        List ps = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)ps.size());
        CompoundFkTestEntity o1 = (CompoundFkTestEntity)ps.get(0);
        Assert.assertEquals((long)33002L, (long)Cayenne.intPKForObject(o1));
    }

    @Test
    public void testSelectFromWhereNoMatchOnMultiColumnObject() throws Exception {
        this.createTwoCompoundPKTwoFK();
        HashMap<String, String> key1 = new HashMap<String, String>();
        key1.put("KEY1", "b1");
        key1.put("KEY2", "b2");
        CompoundPkTestEntity a = Cayenne.objectForPK(this.context, CompoundPkTestEntity.class, key1);
        String ejbql = "select e from CompoundFkTestEntity e WHERE e.toCompoundPk <> :param";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        query.setParameter("param", (Object)a);
        List ps = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)ps.size());
        CompoundFkTestEntity o1 = (CompoundFkTestEntity)ps.get(0);
        Assert.assertEquals((long)33001L, (long)Cayenne.intPKForObject(o1));
    }
}

