/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Gallery;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextEJBQLGroupByHavingIT
extends ServerCase {
    @Inject
    protected ObjectContext context;
    @Inject
    protected DBHelper dbHelper;
    protected TableHelper tArtist;
    protected TableHelper tPainting;
    protected TableHelper tGallery;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
        this.tPainting = new TableHelper(this.dbHelper, "PAINTING");
        this.tPainting.setColumns(new String[]{"PAINTING_ID", "ARTIST_ID", "GALLERY_ID", "PAINTING_TITLE", "ESTIMATED_PRICE"}).setColumnTypes(new int[]{4, -5, 4, 12, 3});
        this.tGallery = new TableHelper(this.dbHelper, "GALLERY");
        this.tGallery.setColumns(new String[]{"GALLERY_ID", "GALLERY_NAME"});
    }

    private void createFivePaintings() throws Exception {
        this.tPainting.insert(new Object[]{33001, null, null, "PX", 1});
        this.tPainting.insert(new Object[]{33002, null, null, "PY", 2});
        this.tPainting.insert(new Object[]{33003, null, null, "PY", 2});
        this.tPainting.insert(new Object[]{33004, null, null, "PZ", 1});
        this.tPainting.insert(new Object[]{33005, null, null, "PZ", 1});
    }

    private void createFourArtistsAndTwoPaintings() throws Exception {
        this.tArtist.insert(new Object[]{33001, "AA1"});
        this.tArtist.insert(new Object[]{33002, "AA2"});
        this.tArtist.insert(new Object[]{33003, "BB1"});
        this.tArtist.insert(new Object[]{33004, "BB2"});
        this.tPainting.insert(new Object[]{33007, 33001, null, "P1", 3000});
        this.tPainting.insert(new Object[]{33008, 33002, null, "P2", 5000});
    }

    private void createArtistsPaintingGalleries() throws Exception {
        this.tArtist.insert(new Object[]{33001, "AA1"});
        this.tArtist.insert(new Object[]{33002, "AA2"});
        this.tArtist.insert(new Object[]{33003, "BB1"});
        this.tArtist.insert(new Object[]{33004, "BB2"});
        this.tGallery.insert(new Object[]{33001, "gallery1"});
        this.tGallery.insert(new Object[]{33002, "gallery2"});
        this.tPainting.insert(new Object[]{33001, null, null, "PX", 1});
        this.tPainting.insert(new Object[]{33002, null, null, "PY", 2});
        this.tPainting.insert(new Object[]{33003, null, null, "PY", 2});
        this.tPainting.insert(new Object[]{33007, 33001, null, "P1", 3000});
        this.tPainting.insert(new Object[]{33008, 33002, null, "P2", 5000});
        this.tPainting.insert(new Object[]{33009, 33002, 33001, "P111", 5000});
        this.tPainting.insert(new Object[]{33010, 33001, 33002, "P112", 5000});
    }

    @Test
    public void testGroupBy() throws Exception {
        this.createFivePaintings();
        String ejbql = "SELECT p.estimatedPrice, count(p) FROM Painting p GROUP BY p.estimatedPrice ORDER BY p.estimatedPrice";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List data = this.context.performQuery(query);
        Assert.assertEquals((long)2L, (long)data.size());
        Assert.assertTrue((boolean)(data.get(0) instanceof Object[]));
        Object[] row0 = (Object[])data.get(0);
        Assert.assertEquals((double)1.0, (double)((BigDecimal)row0[0]).doubleValue(), (double)1.0E-5);
        Assert.assertEquals((Object)new Long(3L), (Object)row0[1]);
        Object[] row1 = (Object[])data.get(1);
        Assert.assertEquals((double)2.0, (double)((BigDecimal)row1[0]).doubleValue(), (double)1.0E-5);
        Assert.assertEquals((Object)new Long(2L), (Object)row1[1]);
    }

    @Test
    public void testGroupByMultipleItems() throws Exception {
        this.createFivePaintings();
        String ejbql = "SELECT p.estimatedPrice, p.paintingTitle, count(p) FROM Painting p GROUP BY p.estimatedPrice, p.paintingTitle ORDER BY p.estimatedPrice, p.paintingTitle";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List data = this.context.performQuery(query);
        Assert.assertEquals((long)3L, (long)data.size());
        Assert.assertTrue((boolean)(data.get(0) instanceof Object[]));
        Object[] row0 = (Object[])data.get(0);
        Assert.assertEquals((double)1.0, (double)((BigDecimal)row0[0]).doubleValue(), (double)1.0E-5);
        Assert.assertEquals((Object)"PX", (Object)row0[1]);
        Assert.assertEquals((Object)new Long(1L), (Object)row0[2]);
        Object[] row1 = (Object[])data.get(1);
        Assert.assertEquals((double)1.0, (double)((BigDecimal)row1[0]).doubleValue(), (double)1.0E-5);
        Assert.assertEquals((Object)"PZ", (Object)row1[1]);
        Assert.assertEquals((Object)new Long(2L), (Object)row1[2]);
        Object[] row2 = (Object[])data.get(2);
        Assert.assertEquals((double)2.0, (double)((BigDecimal)row2[0]).doubleValue(), (double)1.0E-5);
        Assert.assertEquals((Object)"PY", (Object)row2[1]);
        Assert.assertEquals((Object)new Long(2L), (Object)row2[2]);
    }

    @Test
    public void testGroupByRelatedEntity() throws Exception {
        this.createFourArtistsAndTwoPaintings();
        String ejbql = "SELECT COUNT(p), a, a.artistName FROM Painting p INNER JOIN p.toArtist a GROUP BY a, a.artistName ORDER BY a.artistName";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List data = this.context.performQuery(query);
        Assert.assertEquals((long)2L, (long)data.size());
        Assert.assertTrue((boolean)(data.get(0) instanceof Object[]));
        Object[] row0 = (Object[])data.get(0);
        Assert.assertEquals((long)3L, (long)row0.length);
        Assert.assertEquals((Object)new Long(1L), (Object)row0[0]);
        Assert.assertEquals((Object)"AA1", (Object)row0[2]);
        Assert.assertTrue((boolean)(row0[1] instanceof Artist));
    }

    @Test
    public void testGroupByIdVariable() throws Exception {
        this.createFivePaintings();
        String ejbql = "SELECT count(p), p FROM Painting p GROUP BY p";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List data = this.context.performQuery(query);
        Assert.assertEquals((long)5L, (long)data.size());
    }

    @Test
    public void testGroupByHavingOnColumn() throws Exception {
        this.createFivePaintings();
        String ejbql = "SELECT p.estimatedPrice, count(p) FROM Painting p GROUP BY p.estimatedPrice HAVING p.estimatedPrice > 1";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List data = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)data.size());
        Assert.assertTrue((boolean)(data.get(0) instanceof Object[]));
        Object[] row0 = (Object[])data.get(0);
        Assert.assertEquals((double)2.0, (double)((BigDecimal)row0[0]).doubleValue(), (double)1.0E-5);
        Assert.assertEquals((Object)new Long(2L), (Object)row0[1]);
    }

    @Test
    public void testGroupByHavingOnAggregate() throws Exception {
        this.createFivePaintings();
        String ejbql = "SELECT p.estimatedPrice, count(p) FROM Painting p GROUP BY p.estimatedPrice HAVING count(p) > 2";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List data = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)data.size());
        Assert.assertTrue((boolean)(data.get(0) instanceof Object[]));
        Object[] row0 = (Object[])data.get(0);
        Assert.assertEquals((double)1.0, (double)((BigDecimal)row0[0]).doubleValue(), (double)1.0E-5);
        Assert.assertEquals((Object)new Long(3L), (Object)row0[1]);
    }

    @Test
    public void testGroupByHavingOnAggregateMultipleConditions() throws Exception {
        this.createFivePaintings();
        String ejbql = "SELECT p.estimatedPrice, count(p) FROM Painting p GROUP BY p.estimatedPrice HAVING count(p) > 2 AND p.estimatedPrice < 10";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List data = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)data.size());
        Assert.assertTrue((boolean)(data.get(0) instanceof Object[]));
        Object[] row0 = (Object[])data.get(0);
        Assert.assertEquals((double)1.0, (double)((BigDecimal)row0[0]).doubleValue(), (double)1.0E-5);
        Assert.assertEquals((Object)new Long(3L), (Object)row0[1]);
    }

    @Test
    public void testGroupByJoinedRelatedEntities() throws Exception {
        this.createFourArtistsAndTwoPaintings();
        EJBQLQuery query = new EJBQLQuery("SELECT COUNT(p), p.toArtist FROM Painting p GROUP BY p.toArtist ");
        List data = this.context.performQuery(query);
        Assert.assertNotNull((Object)data);
        Assert.assertEquals((long)2L, (long)data.size());
        ArrayList<String> expectedArtists = new ArrayList<String>();
        expectedArtists.add("AA1");
        expectedArtists.add("AA2");
        Object[] row = (Object[])data.get(0);
        String artistName = ((Artist)row[1]).getArtistName();
        Assert.assertEquals((Object)1L, (Object)row[0]);
        Assert.assertTrue((String)("error artistName:" + artistName), (boolean)expectedArtists.contains(artistName));
        row = (Object[])data.get(1);
        artistName = ((Artist)row[1]).getArtistName();
        Assert.assertEquals((Object)1L, (Object)row[0]);
        Assert.assertTrue((String)("error artistName:" + artistName), (boolean)expectedArtists.contains(artistName));
    }

    @Test
    public void testGroupByJoinedEntities() throws Exception {
        this.createArtistsPaintingGalleries();
        EJBQLQuery query = new EJBQLQuery("SELECT COUNT(p), p.toArtist, p.toGallery FROM Painting p GROUP BY p.toGallery, p.toArtist ");
        List data = this.context.performQuery(query);
        Assert.assertNotNull((Object)data);
        Assert.assertEquals((long)2L, (long)data.size());
        HashSet<List<Object>> expectedResults = new HashSet<List<Object>>();
        expectedResults.add(Arrays.asList(1L, "AA2", "gallery1"));
        expectedResults.add(Arrays.asList(1L, "AA1", "gallery2"));
        for (Object[] row : data) {
            Assert.assertFalse((boolean)expectedResults.add(Arrays.asList(row[0], row[1] == null ? null : ((Artist)row[1]).getArtistName(), row[2] == null ? null : ((Gallery)row[2]).getGalleryName())));
        }
    }

    @Test
    public void testGroupByJoinedEntityInCount() throws Exception {
        this.createArtistsPaintingGalleries();
        EJBQLQuery query = new EJBQLQuery("SELECT COUNT(p.toArtist), p.paintingTitle FROM Painting p GROUP BY p.paintingTitle HAVING p.paintingTitle LIKE 'P1%'");
        List data = this.context.performQuery(query);
        Assert.assertNotNull((Object)data);
        Assert.assertEquals((long)3L, (long)data.size());
        HashSet<List<Object>> expectedResults = new HashSet<List<Object>>();
        expectedResults.add(Arrays.asList(1L, "P1"));
        expectedResults.add(Arrays.asList(1L, "P111"));
        expectedResults.add(Arrays.asList(1L, "P112"));
        for (Object[] row : data) {
            Assert.assertFalse((boolean)expectedResults.add(Arrays.asList(row[0], row[1])));
        }
    }

    @Test
    public void testGroupByChainedJoins() throws Exception {
        this.createFivePaintings();
        String ejbql = "SELECT p.painting.toArtist.paintingArray FROM PaintingInfo p GROUP BY p.painting.toArtist.paintingArray";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        this.context.performQuery(query);
        ejbql = "SELECT p.painting.toArtist FROM PaintingInfo p GROUP BY p.painting.toArtist";
        query = new EJBQLQuery(ejbql);
        this.context.performQuery(query);
    }
}

