/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.ashwood.graph;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.cayenne.ashwood.graph.ArcIterator;
import org.apache.cayenne.ashwood.graph.DepthFirstSearch;
import org.apache.cayenne.ashwood.graph.DepthFirstStampSearch;
import org.apache.cayenne.ashwood.graph.Digraph;
import org.apache.cayenne.ashwood.graph.DigraphIteration;
import org.apache.cayenne.ashwood.graph.FilterIteration;
import org.apache.cayenne.ashwood.graph.ReversedIteration;

public class StrongConnection<E, V>
implements Iterator<Collection<E>> {
    private DigraphIteration<E, V> digraph;
    private DigraphIteration<E, V> reverseDigraph;
    private DigraphIteration<E, V> filteredDigraph;
    private DepthFirstStampSearch<E> directDfs;
    private DepthFirstSearch<E> reverseDfs;
    private Set<E> seen = new HashSet();
    private Iterator<E> vertexIterator;
    private ArrayDeque<E> dfsStack = new ArrayDeque();
    private DFSSeenVerticesPredicate reverseDFSFilter = new DFSSeenVerticesPredicate();

    public StrongConnection(DigraphIteration<E, V> digraph) {
        this.digraph = digraph;
        this.filteredDigraph = new FilterIteration<E, Object>(digraph, new NotSeenPredicate(), arc -> true);
        this.reverseDigraph = new FilterIteration<E, Object>(new ReversedIteration<E, V>(digraph), this.reverseDFSFilter, arc -> true);
        this.vertexIterator = this.filteredDigraph.vertexIterator();
        this.runDirectDFS();
    }

    @Override
    public boolean hasNext() {
        return !this.dfsStack.isEmpty();
    }

    @Override
    public Collection<E> next() {
        Collection<E> component = this.buildStronglyConnectedComponent();
        if (this.dfsStack.isEmpty()) {
            this.runDirectDFS();
        }
        return component;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Method remove() not supported.");
    }

    public Digraph<Collection<E>, Collection<V>> contract(Digraph<Collection<E>, Collection<V>> contractedDigraph) {
        ArrayList<Object> components = new ArrayList<Object>();
        while (this.hasNext()) {
            components.add(this.next());
        }
        HashMap memberToComponent = new HashMap();
        for (Collection collection : components) {
            for (Object e : collection) {
                memberToComponent.put(e, collection);
            }
        }
        for (Collection collection : components) {
            contractedDigraph.addVertex(collection);
            for (Object member : collection) {
                ArcIterator<E, V> k = this.digraph.outgoingIterator(member);
                while (k.hasNext()) {
                    Object arc = k.next();
                    E dst = k.getDestination();
                    if (collection.contains(dst)) continue;
                    Collection destination = (Collection)memberToComponent.get(dst);
                    Collection<V> contractedArc = contractedDigraph.getArc(collection, destination);
                    if (contractedArc == null) {
                        contractedArc = Collections.singletonList(arc);
                        contractedDigraph.putArc(collection, destination, contractedArc);
                        continue;
                    }
                    if (contractedArc.size() == 1) {
                        Collection<V> tmp = contractedArc;
                        contractedArc = new ArrayList<V>();
                        contractedArc.addAll(tmp);
                        contractedDigraph.putArc(collection, destination, contractedArc);
                    }
                    contractedArc.add(arc);
                }
            }
        }
        return contractedDigraph;
    }

    private E nextDFSRoot() {
        return this.vertexIterator.hasNext() ? (E)this.vertexIterator.next() : null;
    }

    private boolean runDirectDFS() {
        this.dfsStack.clear();
        this.reverseDFSFilter.seenVertices.clear();
        E root = this.nextDFSRoot();
        if (root == null) {
            return false;
        }
        if (this.directDfs == null) {
            this.directDfs = new DepthFirstStampSearch<E>(this.filteredDigraph, root);
        } else {
            this.directDfs.reset(root);
        }
        while (this.directDfs.hasNext()) {
            E vertex = this.directDfs.next();
            int stamp = this.directDfs.getStamp();
            if (stamp != 2 && stamp != 3) continue;
            this.dfsStack.push(vertex);
            this.reverseDFSFilter.seenVertices.add(vertex);
        }
        this.seen.addAll(this.dfsStack);
        return true;
    }

    private Collection<E> buildStronglyConnectedComponent() {
        E root = this.dfsStack.pop();
        List<E> component = Collections.singletonList(root);
        boolean singleton = true;
        if (this.reverseDfs == null) {
            this.reverseDfs = new DepthFirstSearch<E>(this.reverseDigraph, root);
        } else {
            this.reverseDfs.reset(root);
        }
        while (this.reverseDfs.hasNext()) {
            E vertex = this.reverseDfs.next();
            if (vertex == root) continue;
            if (singleton) {
                List<E> tmp = component;
                component = new ArrayList();
                component.addAll(tmp);
                singleton = false;
            }
            component.add(vertex);
            this.dfsStack.remove(vertex);
        }
        this.reverseDFSFilter.seenVertices.removeAll(component);
        return component;
    }

    private class NotSeenPredicate
    implements Predicate<E> {
        private NotSeenPredicate() {
        }

        @Override
        public boolean test(E vertex) {
            return !StrongConnection.this.seen.contains(vertex);
        }
    }

    private class DFSSeenVerticesPredicate
    implements Predicate<E> {
        private Set<E> seenVertices = new HashSet();

        private DFSSeenVerticesPredicate() {
        }

        @Override
        public boolean test(E vertex) {
            return this.seenVertices.contains(vertex);
        }
    }
}

