/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc.reader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.access.jdbc.RowDescriptor;
import org.apache.cayenne.access.jdbc.reader.CompoundRowReader;
import org.apache.cayenne.access.jdbc.reader.DataRowPostProcessor;
import org.apache.cayenne.access.jdbc.reader.EntityRowReader;
import org.apache.cayenne.access.jdbc.reader.FullRowReader;
import org.apache.cayenne.access.jdbc.reader.IdRowReader;
import org.apache.cayenne.access.jdbc.reader.InheritanceAwareEntityRowReader;
import org.apache.cayenne.access.jdbc.reader.InheritanceAwareRowReader;
import org.apache.cayenne.access.jdbc.reader.RowReader;
import org.apache.cayenne.access.jdbc.reader.RowReaderFactory;
import org.apache.cayenne.access.jdbc.reader.ScalarRowReader;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.EntityResultSegment;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.ScalarResultSegment;
import org.apache.cayenne.reflect.ClassDescriptor;

public class DefaultRowReaderFactory
implements RowReaderFactory {
    @Override
    public RowReader<?> rowReader(RowDescriptor descriptor, QueryMetadata queryMetadata, DbAdapter adapter, Map<ObjAttribute, ColumnDescriptor> attributeOverrides) {
        PostprocessorFactory postProcessorFactory = new PostprocessorFactory(descriptor, queryMetadata, adapter.getExtendedTypes(), attributeOverrides);
        List<Object> rsMapping = queryMetadata.getResultSetMapping();
        if (rsMapping == null) {
            return this.createFullRowReader(descriptor, queryMetadata, postProcessorFactory);
        }
        int resultWidth = rsMapping.size();
        if (resultWidth == 0) {
            throw new CayenneRuntimeException("Empty result descriptor", new Object[0]);
        }
        if (queryMetadata.isSingleResultSetMapping()) {
            Object segment = rsMapping.get(0);
            if (segment instanceof EntityResultSegment) {
                return this.createEntityRowReader(descriptor, queryMetadata, (EntityResultSegment)segment, postProcessorFactory);
            }
            return new ScalarRowReader(descriptor, (ScalarResultSegment)segment);
        }
        CompoundRowReader reader = new CompoundRowReader(resultWidth);
        for (int i = 0; i < resultWidth; ++i) {
            Object segment = rsMapping.get(i);
            if (segment instanceof EntityResultSegment) {
                reader.addRowReader(i, this.createEntityRowReader(descriptor, queryMetadata, (EntityResultSegment)segment, postProcessorFactory));
                continue;
            }
            reader.addRowReader(i, new ScalarRowReader(descriptor, (ScalarResultSegment)segment));
        }
        return reader;
    }

    private RowReader<?> createEntityRowReader(RowDescriptor descriptor, QueryMetadata queryMetadata, EntityResultSegment resultMetadata, PostprocessorFactory postProcessorFactory) {
        if (queryMetadata.getPageSize() > 0) {
            return new IdRowReader(descriptor, queryMetadata, resultMetadata, postProcessorFactory.get());
        }
        if (resultMetadata.getClassDescriptor() != null && resultMetadata.getClassDescriptor().hasSubclasses()) {
            return new InheritanceAwareEntityRowReader(descriptor, resultMetadata, postProcessorFactory.get());
        }
        return new EntityRowReader(descriptor, resultMetadata, postProcessorFactory.get());
    }

    private RowReader<?> createFullRowReader(RowDescriptor descriptor, QueryMetadata queryMetadata, PostprocessorFactory postProcessorFactory) {
        if (queryMetadata.getPageSize() > 0) {
            return new IdRowReader(descriptor, queryMetadata, null, postProcessorFactory.get());
        }
        if (queryMetadata.getClassDescriptor() != null && queryMetadata.getClassDescriptor().hasSubclasses()) {
            return new InheritanceAwareRowReader(descriptor, queryMetadata, postProcessorFactory.get());
        }
        return new FullRowReader(descriptor, queryMetadata, postProcessorFactory.get());
    }

    private class PostprocessorFactory {
        private QueryMetadata queryMetadata;
        private ExtendedTypeMap extendedTypes;
        private Map<ObjAttribute, ColumnDescriptor> attributeOverrides;
        private RowDescriptor rowDescriptor;
        private boolean created;
        private DataRowPostProcessor postProcessor;

        PostprocessorFactory(RowDescriptor rowDescriptor, QueryMetadata queryMetadata, ExtendedTypeMap extendedTypes, Map<ObjAttribute, ColumnDescriptor> attributeOverrides) {
            this.rowDescriptor = rowDescriptor;
            this.extendedTypes = extendedTypes;
            this.attributeOverrides = attributeOverrides;
            this.queryMetadata = queryMetadata;
        }

        DataRowPostProcessor get() {
            if (!this.created) {
                this.postProcessor = this.create();
                this.created = true;
            }
            return this.postProcessor;
        }

        private DataRowPostProcessor create() {
            if (this.attributeOverrides.isEmpty()) {
                return null;
            }
            ColumnDescriptor[] columns = this.rowDescriptor.getColumns();
            HashMap<String, Collection<DataRowPostProcessor.ColumnOverride>> columnOverrides = new HashMap<String, Collection<DataRowPostProcessor.ColumnOverride>>(2);
            for (Map.Entry<ObjAttribute, ColumnDescriptor> entry : this.attributeOverrides.entrySet()) {
                ObjAttribute attribute = entry.getKey();
                ObjEntity entity = attribute.getEntity();
                String key = null;
                int jdbcType = Integer.MAX_VALUE;
                int index = -1;
                for (int i = 0; i < columns.length; ++i) {
                    if (columns[i] != entry.getValue()) continue;
                    if (attribute.getType().equals(columns[i].getJavaClass())) break;
                    index = i + 1;
                    jdbcType = columns[i].getJdbcType();
                    key = columns[i].getDataRowKey();
                    break;
                }
                if (index < 1) continue;
                ExtendedType converter = this.extendedTypes.getRegisteredType(attribute.getType());
                Collection overrides = columnOverrides.computeIfAbsent(entity.getName(), k -> new ArrayList(3));
                overrides.add(new DataRowPostProcessor.ColumnOverride(index, key, converter, jdbcType));
            }
            if (columnOverrides.isEmpty()) {
                return null;
            }
            ClassDescriptor rootDescriptor = this.queryMetadata.getClassDescriptor();
            return new DataRowPostProcessor(rootDescriptor, columnOverrides);
        }
    }
}

