/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.ConfigurationNodeVisitor;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionException;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbKeyGenerator;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.JoinType;
import org.apache.cayenne.map.MappingNamespace;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.PathComponent;
import org.apache.cayenne.map.PathComponentIterator;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.map.event.AttributeEvent;
import org.apache.cayenne.map.event.DbAttributeListener;
import org.apache.cayenne.map.event.DbEntityListener;
import org.apache.cayenne.map.event.DbRelationshipListener;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.map.event.RelationshipEvent;
import org.apache.cayenne.util.CayenneMapEntry;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.util.XMLEncoder;
import org.apache.cayenne.util.XMLSerializable;

public class DbEntity
extends Entity
implements ConfigurationNode,
DbEntityListener,
DbAttributeListener,
DbRelationshipListener {
    protected String catalog;
    protected String schema;
    protected Collection<DbAttribute> primaryKey = new ArrayList<DbAttribute>(2);
    protected Collection<DbAttribute> generatedAttributes = new ArrayList<DbAttribute>(2);
    protected DbKeyGenerator primaryKeyGenerator;
    protected Expression qualifier;

    public DbEntity() {
    }

    public DbEntity(String name) {
        this();
        this.setName(name);
    }

    @Override
    public DbRelationship getRelationship(String relName) {
        return (DbRelationship)super.getRelationship(relName);
    }

    @Override
    public DbAttribute getAttribute(String attributeName) {
        return (DbAttribute)super.getAttribute(attributeName);
    }

    @Override
    public <T> T acceptVisitor(ConfigurationNodeVisitor<T> visitor) {
        return visitor.visitDbEntity(this);
    }

    @Override
    public void encodeAsXML(XMLEncoder encoder, ConfigurationNodeVisitor delegate) {
        encoder.start("db-entity").attribute("name", this.getName());
        if (this.getSchema() != null && this.getSchema().trim().length() > 0) {
            encoder.attribute("schema", this.getSchema().trim());
        }
        if (this.getCatalog() != null && this.getCatalog().trim().length() > 0) {
            encoder.attribute("catalog", this.getCatalog().trim());
        }
        encoder.nested(new TreeMap<String, Attribute>(this.getAttributeMap()), delegate);
        if (this.getPrimaryKeyGenerator() != null) {
            this.getPrimaryKeyGenerator().encodeAsXML(encoder, delegate);
        }
        if (this.getQualifier() != null) {
            encoder.start("qualifier");
            this.getQualifier().encodeAsXML(encoder, delegate);
            encoder.end();
        }
        delegate.visitDbEntity(this);
        encoder.end();
    }

    public String getFullyQualifiedName() {
        return (this.catalog != null && !this.catalog.isEmpty() ? this.catalog + '.' : "") + (this.schema != null && !this.schema.isEmpty() ? this.schema + '.' : "") + this.name;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public Collection<DbAttribute> getPrimaryKeys() {
        return Collections.unmodifiableCollection(this.primaryKey);
    }

    public Collection<DbAttribute> getAttributes() {
        return super.getAttributes();
    }

    public Collection<DbAttribute> getGeneratedAttributes() {
        return Collections.unmodifiableCollection(this.generatedAttributes);
    }

    public void addAttribute(DbAttribute attr) {
        super.addAttribute(attr);
        this.dbAttributeAdded(new AttributeEvent((Object)this, (Attribute)attr, (Entity)this, 2));
    }

    @Override
    public void removeAttribute(String attrName) {
        DbAttribute attr = this.getAttribute(attrName);
        if (attr == null) {
            return;
        }
        DataMap map = this.getDataMap();
        if (map != null) {
            for (DbEntity ent : map.getDbEntities()) {
                for (DbRelationship relationship : ent.getRelationships()) {
                    relationship.getJoins().removeIf(join -> join.getSource() == attr || join.getTarget() == attr);
                }
            }
        }
        super.removeAttribute(attrName);
        this.dbAttributeRemoved(new AttributeEvent((Object)this, (Attribute)attr, (Entity)this, 3));
    }

    @Override
    public void clearAttributes() {
        super.clearAttributes();
        this.dbAttributeRemoved(new AttributeEvent((Object)this, null, (Entity)this, 3));
    }

    public Collection<DbRelationship> getRelationships() {
        return super.getRelationships();
    }

    public Map<String, DbRelationship> getRelationshipMap() {
        return super.getRelationshipMap();
    }

    public PathComponent<DbAttribute, DbRelationship> lastPathComponent(Expression path, Map aliasMap) {
        return super.lastPathComponent(path, aliasMap);
    }

    public Iterable<PathComponent<DbAttribute, DbRelationship>> resolvePath(final Expression pathExp, final Map aliasMap) {
        if (pathExp.getType() == 27) {
            return new Iterable<PathComponent<DbAttribute, DbRelationship>>(){

                @Override
                public Iterator iterator() {
                    return new PathComponentIterator(DbEntity.this, (String)pathExp.getOperand(0), aliasMap);
                }
            };
        }
        throw new ExpressionException("Invalid expression type: '" + pathExp.expName() + "',  DB_PATH is expected.", new Object[0]);
    }

    @Override
    public Iterator<CayenneMapEntry> resolvePathComponents(Expression pathExp) throws ExpressionException {
        if (pathExp.getType() != 27) {
            throw new ExpressionException("Invalid expression type: '" + pathExp.expName() + "',  DB_PATH is expected.", new Object[0]);
        }
        return new Entity.PathIterator((String)pathExp.getOperand(0));
    }

    public void setPrimaryKeyGenerator(DbKeyGenerator primaryKeyGenerator) {
        this.primaryKeyGenerator = primaryKeyGenerator;
        if (primaryKeyGenerator != null) {
            primaryKeyGenerator.setDbEntity(this);
        }
    }

    public DbKeyGenerator getPrimaryKeyGenerator() {
        return this.primaryKeyGenerator;
    }

    @Override
    public void dbEntityChanged(EntityEvent e) {
        if (e == null || e.getEntity() != this) {
            return;
        }
        if (e.getId() == 1 && e.isNameChange()) {
            String newName = e.getNewName();
            DataMap map = this.getDataMap();
            if (map != null) {
                for (DbEntity dbe : map.getDbEntities()) {
                    for (DbRelationship relationship : dbe.getRelationships()) {
                        if (relationship.getTargetEntity() != this) continue;
                        relationship.setTargetEntityName(newName);
                    }
                }
                for (ObjEntity oe : map.getMappedEntities(this)) {
                    if (oe.getDbEntity() != this) continue;
                    oe.setDbEntityName(newName);
                }
            }
        }
    }

    @Override
    public void dbEntityAdded(EntityEvent e) {
    }

    @Override
    public void dbEntityRemoved(EntityEvent e) {
    }

    @Override
    public void dbAttributeAdded(AttributeEvent e) {
        this.handleAttributeUpdate(e);
    }

    @Override
    public void dbAttributeChanged(AttributeEvent e) {
        this.handleAttributeUpdate(e);
    }

    @Override
    public void dbAttributeRemoved(AttributeEvent e) {
        this.handleAttributeUpdate(e);
    }

    private void handleAttributeUpdate(AttributeEvent e) {
        if (e == null || e.getEntity() != this) {
            return;
        }
        Attribute attribute = e.getAttribute();
        if (attribute == null && this.attributes.isEmpty()) {
            this.primaryKey.clear();
            this.generatedAttributes.clear();
            return;
        }
        if (!(attribute instanceof DbAttribute)) {
            return;
        }
        DbAttribute dbAttribute = (DbAttribute)attribute;
        if (e.getId() == 1 && e.isNameChange()) {
            String oldName = e.getOldName();
            String newName = e.getNewName();
            DataMap map = this.getDataMap();
            if (map != null) {
                for (DbEntity ent : map.getDbEntities()) {
                    for (ObjEntity oe : map.getMappedEntities(ent)) {
                        for (ObjAttribute attr : oe.getAttributes()) {
                            if (attr.getDbAttribute() != dbAttribute) continue;
                            attr.setDbAttributePath(newName);
                        }
                    }
                    for (DbRelationship rel : ent.getRelationships()) {
                        for (DbJoin join : rel.getJoins()) {
                            if (join.getSource() == dbAttribute) {
                                join.setSourceName(newName);
                            }
                            if (join.getTarget() != dbAttribute) continue;
                            join.setTargetName(newName);
                        }
                    }
                }
            }
            this.attributes.remove(oldName);
            super.addAttribute(dbAttribute);
        }
        if (this.primaryKey.contains(dbAttribute) || dbAttribute.isPrimaryKey()) {
            switch (e.getId()) {
                case 2: {
                    this.primaryKey.add(dbAttribute);
                    break;
                }
                case 3: {
                    this.primaryKey.remove(dbAttribute);
                    break;
                }
                default: {
                    this.primaryKey.clear();
                    for (DbAttribute next : this.getAttributes()) {
                        if (!next.isPrimaryKey()) continue;
                        this.primaryKey.add(next);
                    }
                }
            }
        }
        if (this.generatedAttributes.contains(dbAttribute) || dbAttribute.isGenerated()) {
            switch (e.getId()) {
                case 2: {
                    this.generatedAttributes.add(dbAttribute);
                    break;
                }
                case 3: {
                    this.generatedAttributes.remove(dbAttribute);
                    break;
                }
                default: {
                    this.generatedAttributes.clear();
                    for (DbAttribute next : this.getAttributes()) {
                        if (!next.isGenerated()) continue;
                        this.generatedAttributes.add(next);
                    }
                }
            }
        }
    }

    @Override
    public void dbRelationshipChanged(RelationshipEvent e) {
        if (e == null || e.getEntity() != this) {
            return;
        }
        Relationship rel = e.getRelationship();
        if (!(rel instanceof DbRelationship)) {
            return;
        }
        DbRelationship dbRel = (DbRelationship)rel;
        if (e.getId() == 1 && e.isNameChange()) {
            String oldName = e.getOldName();
            DataMap map = this.getDataMap();
            if (map != null) {
                for (ObjEntity objEntity : map.getObjEntities()) {
                    for (ObjAttribute attribute : objEntity.getAttributes()) {
                        attribute.updateDbAttributePath();
                    }
                }
            }
            this.relationships.remove(oldName);
            super.addRelationship(dbRel);
        }
    }

    @Override
    public void dbRelationshipAdded(RelationshipEvent e) {
    }

    @Override
    public void dbRelationshipRemoved(RelationshipEvent e) {
    }

    public Expression getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(Expression qualifier) {
        this.qualifier = qualifier;
    }

    public boolean isFullReplacementIdAttached(ObjectId id) {
        if (!id.isReplacementIdAttached()) {
            return false;
        }
        Map<String, Object> replacement = id.getReplacementIdMap();
        Collection<DbAttribute> pk = this.getPrimaryKeys();
        if (pk.size() != replacement.size()) {
            return false;
        }
        for (DbAttribute attribute : pk) {
            if (replacement.containsKey(attribute.getName())) continue;
            return false;
        }
        return true;
    }

    public Collection<ObjEntity> mappedObjEntities() {
        HashSet<ObjEntity> objEntities = new HashSet<ObjEntity>();
        MappingNamespace mns = this.getDataMap().getNamespace();
        if (mns != null) {
            for (ObjEntity objEntity : mns.getObjEntities()) {
                if (!this.equals(objEntity.getDbEntity())) continue;
                objEntities.add(objEntity);
            }
        }
        return objEntities;
    }

    @Override
    public Expression translateToRelatedEntity(Expression expression, String relationshipPath) {
        if (expression == null) {
            return null;
        }
        if (relationshipPath == null) {
            return expression;
        }
        return expression.transform(new RelationshipPathConverter(relationshipPath));
    }

    final class RelationshipPathConverter
    implements Function<Object, Object> {
        String relationshipPath;
        boolean toMany;

        RelationshipPathConverter(String relationshipPath) {
            this.relationshipPath = relationshipPath;
            Iterator<CayenneMapEntry> relationshipIt = DbEntity.this.resolvePathComponents(relationshipPath);
            while (relationshipIt.hasNext()) {
                DbRelationship nextDBR = (DbRelationship)relationshipIt.next();
                if (!nextDBR.isToMany()) continue;
                this.toMany = true;
                break;
            }
        }

        @Override
        public Object apply(Object input) {
            if (!(input instanceof Expression)) {
                return input;
            }
            Expression expression = (Expression)input;
            if (expression.getType() != 27) {
                return input;
            }
            String path = (String)expression.getOperand(0);
            String converted = this.translatePath(path);
            Expression transformed = ExpressionFactory.expressionOfType(27);
            transformed.setOperand(0, converted);
            return transformed;
        }

        private PathComponentIterator createPathIterator(String path) {
            return new PathComponentIterator(DbEntity.this, path, Collections.emptyMap());
        }

        String translatePath(String path) {
            Object component;
            DbRelationship nextDBR;
            if (this.toMany) {
                PathComponentIterator pathIt = this.createPathIterator(path);
                Iterator<CayenneMapEntry> relationshipIt = DbEntity.this.resolvePathComponents(this.relationshipPath);
                LinkedList<String> finalPath = new LinkedList<String>();
                while (relationshipIt.hasNext()) {
                    DbRelationship nextDBR2 = (DbRelationship)relationshipIt.next();
                    this.prependReversedPath(finalPath, nextDBR2);
                }
                while (pathIt.hasNext()) {
                    Object component2 = pathIt.next();
                    this.appendPath(finalPath, (PathComponent<Attribute, Relationship>)component2);
                }
                return Util.join(finalPath, ".");
            }
            if (path.equals(this.relationshipPath)) {
                LinkedList<String> finalPath = new LinkedList<String>();
                PathComponentIterator pathIt = this.createPathIterator(path);
                DbRelationship lastDBR = null;
                while (pathIt.hasNext()) {
                    lastDBR = (DbRelationship)pathIt.next().getRelationship();
                }
                if (lastDBR != null) {
                    this.prependReversedPath(finalPath, lastDBR);
                    this.appendPath(finalPath, lastDBR);
                }
                return Util.join(finalPath, ".");
            }
            String relationshipPathWithDot = this.relationshipPath + ".";
            if (path.startsWith(relationshipPathWithDot)) {
                return path.substring(relationshipPathWithDot.length());
            }
            PathComponentIterator pathIt = this.createPathIterator(path);
            Iterator<CayenneMapEntry> relationshipIt = DbEntity.this.resolvePathComponents(this.relationshipPath);
            LinkedList<String> finalPath = new LinkedList<String>();
            if (relationshipIt.hasNext() && pathIt.hasNext() && (nextDBR = (DbRelationship)relationshipIt.next()) != (component = pathIt.next()).getRelationship()) {
                this.prependReversedPath(finalPath, nextDBR);
                this.appendPath(finalPath, (PathComponent<Attribute, Relationship>)component);
            }
            while (relationshipIt.hasNext()) {
                nextDBR = (DbRelationship)relationshipIt.next();
                this.prependReversedPath(finalPath, nextDBR);
            }
            while (pathIt.hasNext()) {
                Object component3 = pathIt.next();
                this.appendPath(finalPath, (PathComponent<Attribute, Relationship>)component3);
            }
            return Util.join(finalPath, ".");
        }

        private void prependReversedPath(LinkedList<String> finalPath, DbRelationship relationship) {
            DbRelationship revNextDBR = relationship.getReverseRelationship();
            if (revNextDBR == null) {
                throw new CayenneRuntimeException("Unable to find reverse DbRelationship for %s.%s.", relationship.getSourceEntity().getName(), relationship.getName());
            }
            finalPath.addFirst(revNextDBR.getName());
        }

        private void appendPath(LinkedList<String> finalPath, CayenneMapEntry pathComponent) {
            finalPath.addLast(pathComponent.getName());
        }

        private void appendPath(LinkedList<String> finalPath, PathComponent<Attribute, Relationship> pathComponent) {
            XMLSerializable mapEntry = pathComponent.getAttribute() != null ? pathComponent.getAttribute() : pathComponent.getRelationship();
            String name = mapEntry.getName();
            if (pathComponent.getJoinType() == JoinType.LEFT_OUTER) {
                name = name + "+";
            }
            finalPath.addLast(name);
        }
    }
}

