/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.datasource;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.apache.cayenne.datasource.ManagedPoolingDataSource;
import org.apache.cayenne.datasource.PoolingDataSourceParameters;
import org.apache.cayenne.datasource.UnmanagedPoolingDataSource;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.OngoingStubbing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UseServerRuntime(value="cayenne-testmap.xml")
public class ManagedPoolingDataSourceIT {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagedPoolingDataSourceIT.class);
    private int poolSize;
    private OnOffDataSourceManager dataSourceManager;
    private UnmanagedPoolingDataSource unmanagedPool;
    private ManagedPoolingDataSource managedPool;

    @Before
    public void before() throws SQLException {
        this.poolSize = 4;
        this.dataSourceManager = new OnOffDataSourceManager();
        PoolingDataSourceParameters parameters = new PoolingDataSourceParameters();
        parameters.setMaxConnections(this.poolSize);
        parameters.setMinConnections(this.poolSize / 2);
        parameters.setMaxQueueWaitTime(1000L);
        parameters.setValidationQuery("SELECT 1");
        this.unmanagedPool = new UnmanagedPoolingDataSource(this.dataSourceManager.mockDataSource, parameters);
        this.managedPool = new ManagedPoolingDataSource(this.unmanagedPool, 10000L);
    }

    @After
    public void after() {
        if (this.managedPool != null) {
            this.managedPool.close();
        }
    }

    private Collection<PoolTask> createTasks(int size) {
        ArrayList<PoolTask> tasks = new ArrayList<PoolTask>();
        for (int i = 0; i < size; ++i) {
            tasks.add(new PoolTask());
        }
        return tasks;
    }

    @Test
    public void testGetConnection_OnBackendShutdown() throws SQLException, InterruptedException {
        int j;
        Assert.assertEquals((long)this.poolSize, (long)(this.managedPool.poolSize() + this.managedPool.canExpandSize()));
        Collection<PoolTask> tasks = this.createTasks(4);
        ExecutorService executor = Executors.newFixedThreadPool(4);
        for (j = 0; j < 10; ++j) {
            for (PoolTask task : tasks) {
                executor.submit(task);
            }
        }
        this.dataSourceManager.off();
        Thread.sleep(500L);
        for (j = 0; j < 10; ++j) {
            for (PoolTask task : tasks) {
                executor.submit(task);
            }
        }
        Thread.sleep(100L);
        this.dataSourceManager.on();
        for (j = 0; j < 10; ++j) {
            for (PoolTask task : tasks) {
                executor.submit(task);
            }
        }
        executor.shutdown();
        executor.awaitTermination(2L, TimeUnit.SECONDS);
        Assert.assertEquals((long)this.poolSize, (long)(this.managedPool.poolSize() + this.managedPool.canExpandSize()));
    }

    static class OnOffDataSourceManager {
        static final String NO_CONNECTIONS_MESSAGE = "no connections at the moment";
        private DataSource mockDataSource = (DataSource)Mockito.mock(DataSource.class);
        private OngoingStubbing<Connection> createConnectionMock = Mockito.when((Object)this.mockDataSource.getConnection());

        OnOffDataSourceManager() throws SQLException {
            this.on();
        }

        void off() throws SQLException {
            this.createConnectionMock.thenAnswer((Answer)new Answer<Connection>(){

                public Connection answer(InvocationOnMock invocation) throws Throwable {
                    throw new SQLException(OnOffDataSourceManager.NO_CONNECTIONS_MESSAGE);
                }
            });
        }

        void on() throws SQLException {
            this.createConnectionMock.thenAnswer((Answer)new Answer<Connection>(){

                public Connection answer(InvocationOnMock invocation) throws Throwable {
                    Connection c = (Connection)Mockito.mock(Connection.class);
                    Mockito.when((Object)c.createStatement()).thenAnswer((Answer)new Answer<Statement>(){

                        public Statement answer(InvocationOnMock invocation) throws Throwable {
                            ResultSet mockRs = (ResultSet)Mockito.mock(ResultSet.class);
                            Mockito.when((Object)mockRs.next()).thenReturn((Object)true, (Object[])new Boolean[]{false, false, false});
                            Statement mockStatement = (Statement)Mockito.mock(Statement.class);
                            Mockito.when((Object)mockStatement.executeQuery(ArgumentMatchers.anyString())).thenReturn((Object)mockRs);
                            return mockStatement;
                        }
                    });
                    return c;
                }
            });
        }
    }

    class PoolTask
    implements Runnable {
        PoolTask() {
        }

        @Override
        public void run() {
            try (Connection c = ManagedPoolingDataSourceIT.this.managedPool.getConnection();
                 Statement s = c.createStatement();){
                try {
                    Thread.sleep(40L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            catch (SQLException e) {
                if ("no connections at the moment".equals(e.getMessage())) {
                    LOGGER.info("db down...");
                }
                LOGGER.warn("error getting connection", (Throwable)e);
            }
        }
    }
}

