/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.datafactory;

import java.util.Random;
import org.apache.cayenne.datafactory.ValueProvider;

public abstract class DictionaryValueProvider<T>
implements ValueProvider<T> {
    private Random random = ValueProvider.RANDOM;

    public DictionaryValueProvider(Random random) {
        this.random = random;
    }

    @Override
    public T randomValue() {
        return this.randomValue(100, null);
    }

    @Override
    public T randomValue(int probability) {
        return this.randomValue(probability, null);
    }

    @Override
    public T randomValue(int probability, T defaultItem) {
        if (this.values() == null) {
            throw new IllegalArgumentException("Item array cannot be null");
        }
        if (this.values().length == 0) {
            throw new IllegalArgumentException("Item array cannot be empty");
        }
        return this.chance(probability) ? this.values()[this.random.nextInt(this.values().length)] : defaultItem;
    }

    public boolean chance(int chance) {
        return this.random.nextInt(100) < chance;
    }

    @Override
    public void setRandom(Random random) {
        this.random = random;
    }

    protected abstract T[] values();
}

