/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import java.util.Arrays;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.translator.select.OrderingTranslator;
import org.apache.cayenne.access.translator.select.TstQueryAssembler;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.FunctionExpressionFactory;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.query.SortOrder;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.ServerCaseDataSourceFactory;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class OrderingTranslatorIT
extends ServerCase {
    @Inject
    private DataNode node;
    @Inject
    private ServerCaseDataSourceFactory dataSourceFactory;

    @Test
    public void testAppendPart1() throws Exception {
        Ordering o1 = new Ordering("artistName", SortOrder.ASCENDING);
        this.doTestAppendPart("ta.ARTIST_NAME", o1);
    }

    @Test
    public void testAppendPart2() throws Exception {
        Ordering o1 = new Ordering("artistName", SortOrder.DESCENDING);
        this.doTestAppendPart("ta.ARTIST_NAME DESC", o1);
    }

    @Test
    public void testAppendPart3() throws Exception {
        Ordering o1 = new Ordering("artistName", SortOrder.DESCENDING);
        Ordering o2 = new Ordering("paintingArray.estimatedPrice", SortOrder.ASCENDING);
        this.doTestAppendPart("ta.ARTIST_NAME DESC, ta.ESTIMATED_PRICE", o1, o2);
    }

    @Test
    public void testAppendPart4() throws Exception {
        Ordering o1 = new Ordering("artistName", SortOrder.ASCENDING_INSENSITIVE);
        this.doTestAppendPart("UPPER(ta.ARTIST_NAME)", o1);
    }

    @Test
    public void testAppendPart5() throws Exception {
        Ordering o1 = new Ordering("artistName", SortOrder.DESCENDING_INSENSITIVE);
        Ordering o2 = new Ordering("paintingArray.estimatedPrice", SortOrder.ASCENDING);
        this.doTestAppendPart("UPPER(ta.ARTIST_NAME) DESC, ta.ESTIMATED_PRICE", o1, o2);
    }

    @Test
    public void testAppendPart6() throws Exception {
        Ordering o1 = new Ordering("artistName", SortOrder.ASCENDING_INSENSITIVE);
        Ordering o2 = new Ordering("paintingArray.estimatedPrice", SortOrder.ASCENDING_INSENSITIVE);
        this.doTestAppendPart("UPPER(ta.ARTIST_NAME), UPPER(ta.ESTIMATED_PRICE)", o1, o2);
    }

    @Test
    public void testAppendFunctionExpression1() throws Exception {
        Ordering o1 = new Ordering(FunctionExpressionFactory.absExp("paintingArray.estimatedPrice"));
        this.doTestAppendPart("ABS(ta.ESTIMATED_PRICE)", o1);
    }

    @Test
    public void testAppendFunctionExpression2() throws Exception {
        Ordering o1 = new Ordering(FunctionExpressionFactory.countExp(ExpressionFactory.pathExp("dateOfBirth")), SortOrder.ASCENDING_INSENSITIVE);
        Ordering o2 = new Ordering(FunctionExpressionFactory.sqrtExp("paintingArray.estimatedPrice"), SortOrder.DESCENDING);
        this.doTestAppendPart("UPPER(COUNT(ta.DATE_OF_BIRTH)), SQRT(ta.ESTIMATED_PRICE) DESC", o1, o2);
    }

    @Test(expected=CayenneRuntimeException.class)
    public void testAppendIllegalExpression() throws Exception {
        Ordering o1 = new Ordering(ExpressionFactory.and(ExpressionFactory.expTrue(), ExpressionFactory.expFalse()));
        this.doTestAppendPart("TRUE AND FALSE", o1);
    }

    private void doTestAppendPart(String expectedSQL, Ordering ... orderings) {
        SelectQuery<Artist> q = SelectQuery.query(Artist.class);
        q.addOrderings(Arrays.asList(orderings));
        TstQueryAssembler assembler = new TstQueryAssembler(q, this.node.getAdapter(), this.node.getEntityResolver());
        StringBuilder out = new StringBuilder();
        String translated = new OrderingTranslator(assembler).appendPart(out).toString();
        Assert.assertEquals((Object)expectedSQL, (Object)translated);
    }
}

