/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.SimpleIdIncrementalFaultList;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.query.SortOrder;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class SimpleIdIncrementalFaultListDataRowsIT
extends ServerCase {
    @Inject
    private DataContext context;
    @Inject
    private DataContext context1;
    @Inject
    private DBHelper dbHelper;
    private TableHelper tArtist;
    private SimpleIdIncrementalFaultList<?> list;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
        this.createArtistsDataSet();
        SelectQuery<DataRow> q = SelectQuery.dataRowQuery(Artist.class);
        q.setPageSize(6);
        q.addOrdering("db:ARTIST_ID", SortOrder.ASCENDING);
        this.list = new SimpleIdIncrementalFaultList(this.context, q, 10000);
    }

    protected void createArtistsDataSet() throws Exception {
        this.tArtist.insert(new Object[]{33001, "artist1"});
        this.tArtist.insert(new Object[]{33002, "artist2"});
        this.tArtist.insert(new Object[]{33003, "artist3"});
        this.tArtist.insert(new Object[]{33004, "artist4"});
        this.tArtist.insert(new Object[]{33005, "artist5"});
        this.tArtist.insert(new Object[]{33006, "artist6"});
        this.tArtist.insert(new Object[]{33007, "artist7"});
        this.tArtist.insert(new Object[]{33008, "artist8"});
        this.tArtist.insert(new Object[]{33009, "artist9"});
        this.tArtist.insert(new Object[]{33010, "artist10"});
        this.tArtist.insert(new Object[]{33011, "artist11"});
        this.tArtist.insert(new Object[]{33012, "artist12"});
        this.tArtist.insert(new Object[]{33013, "artist13"});
        this.tArtist.insert(new Object[]{33014, "artist14"});
        this.tArtist.insert(new Object[]{33015, "artist15"});
        this.tArtist.insert(new Object[]{33016, "artist16"});
        this.tArtist.insert(new Object[]{33017, "artist17"});
        this.tArtist.insert(new Object[]{33018, "artist18"});
        this.tArtist.insert(new Object[]{33019, "artist19"});
        this.tArtist.insert(new Object[]{33020, "artist20"});
        this.tArtist.insert(new Object[]{33021, "artist21"});
        this.tArtist.insert(new Object[]{33022, "artist22"});
        this.tArtist.insert(new Object[]{33023, "artist23"});
        this.tArtist.insert(new Object[]{33024, "artist24"});
        this.tArtist.insert(new Object[]{33025, "artist25"});
    }

    @Test
    public void testGet1() throws Exception {
        Assert.assertEquals((long)1L, (long)this.list.idWidth);
        Assert.assertTrue((boolean)(this.list.elements.get(0) instanceof Long));
        Assert.assertTrue((boolean)(this.list.elements.get(19) instanceof Long));
        Object a = this.list.get(19);
        Assert.assertNotNull(a);
        Assert.assertTrue((boolean)(a instanceof DataRow));
        Assert.assertEquals((long)3L, (long)((DataRow)a).size());
        Assert.assertEquals((Object)"artist20", ((DataRow)a).get("ARTIST_NAME"));
    }

    @Test
    public void testIndexOf1() throws Exception {
        Expression qual = ExpressionFactory.matchExp("artistName", (Object)"artist20");
        SelectQuery<DataRow> query = SelectQuery.dataRowQuery(Artist.class, qual);
        List artists = this.context1.performQuery(query);
        Assert.assertEquals((long)1L, (long)artists.size());
        DataRow row = (DataRow)artists.get(0);
        Assert.assertEquals((long)19L, (long)this.list.indexOf(row));
        DataRow clone = new DataRow(row);
        Assert.assertEquals((long)19L, (long)this.list.indexOf(clone));
        row.remove("ARTIST_ID");
        Assert.assertEquals((long)-1L, (long)this.list.indexOf(row));
    }

    @Test
    public void testIndexOf2() throws Exception {
        this.list.get(0);
        Expression qual = ExpressionFactory.matchExp("artistName", (Object)"artist2");
        SelectQuery<DataRow> query = SelectQuery.dataRowQuery(Artist.class, qual);
        List artists = this.context1.performQuery(query);
        Assert.assertEquals((long)1L, (long)artists.size());
        DataRow row = (DataRow)artists.get(0);
        Assert.assertEquals((long)1L, (long)this.list.indexOf(row));
        row.remove("ARTIST_NAME");
        Assert.assertEquals((long)-1L, (long)this.list.indexOf(row));
    }

    @Test
    public void testLastIndexOf1() throws Exception {
        this.list.get(0);
        Expression qual = ExpressionFactory.matchExp("artistName", (Object)"artist3");
        SelectQuery<DataRow> query = SelectQuery.dataRowQuery(Artist.class, qual);
        List artists = this.context1.performQuery(query);
        Assert.assertEquals((long)1L, (long)artists.size());
        DataRow row = (DataRow)artists.get(0);
        Assert.assertEquals((long)2L, (long)this.list.lastIndexOf(row));
        row.remove("ARTIST_NAME");
        Assert.assertEquals((long)-1L, (long)this.list.lastIndexOf(row));
    }

    @Test
    public void testLastIndexOf2() throws Exception {
        Expression qual = ExpressionFactory.matchExp("artistName", (Object)"artist20");
        SelectQuery<DataRow> query = SelectQuery.dataRowQuery(Artist.class, qual);
        List artists = this.context1.performQuery(query);
        Assert.assertEquals((long)1L, (long)artists.size());
        DataRow row = (DataRow)artists.get(0);
        Assert.assertEquals((long)19L, (long)this.list.lastIndexOf(row));
        row.remove("ARTIST_ID");
        Assert.assertEquals((long)-1L, (long)this.list.lastIndexOf(row));
    }

    @Test
    public void testIterator() throws Exception {
        Assert.assertEquals((long)1L, (long)this.list.idWidth);
        Iterator it = this.list.iterator();
        int counter = 0;
        while (it.hasNext()) {
            Object obj = it.next();
            Assert.assertNotNull(obj);
            Assert.assertTrue((String)("Unexpected object class: " + obj.getClass().getName()), (boolean)(obj instanceof DataRow));
            Assert.assertEquals((long)3L, (long)((DataRow)obj).size());
            int expectedResolved = this.list.pageIndex(counter) * this.list.getPageSize() + this.list.getPageSize();
            if (expectedResolved > this.list.size()) {
                expectedResolved = this.list.size();
            }
            Assert.assertEquals((long)(this.list.size() - expectedResolved), (long)this.list.getUnfetchedObjects());
            if (this.list.getUnfetchedObjects() >= this.list.getPageSize()) {
                Assert.assertTrue((boolean)(this.list.elements.get(this.list.size() - 1) instanceof Long));
            }
            ++counter;
        }
    }
}

