/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.DataRowStore;
import org.apache.cayenne.access.DataRowUtils;
import org.apache.cayenne.access.ObjectStore;
import org.apache.cayenne.access.PrefetchProcessorNode;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ObjectResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObjectResolver.class);
    DataContext context;
    ClassDescriptor descriptor;
    Collection<DbAttribute> primaryKey;
    boolean refreshObjects;
    DataRowStore cache;
    DescriptorResolutionStrategy descriptorResolutionStrategy;

    ObjectResolver(DataContext context, ClassDescriptor descriptor, boolean refresh) {
        if (descriptor == null || descriptor.getEntity() == null) {
            throw new CayenneRuntimeException("No ClassDescriptor. Maybe DataRows should be fetched instead of objects.", new Object[0]);
        }
        DbEntity dbEntity = descriptor.getEntity().getDbEntity();
        if (dbEntity == null) {
            throw new CayenneRuntimeException("ObjEntity '%s' has no DbEntity.", descriptor.getEntity().getName());
        }
        this.primaryKey = dbEntity.getPrimaryKeys();
        if (this.primaryKey.size() == 0) {
            throw new CayenneRuntimeException("Won't be able to create ObjectId for '%s'. Reason: DbEntity '%s' has no Primary Key defined.", descriptor.getEntity().getName(), dbEntity.getName());
        }
        this.context = context;
        this.cache = context.getObjectStore().getDataRowCache();
        this.refreshObjects = refresh;
        this.descriptor = descriptor;
        this.descriptorResolutionStrategy = descriptor.hasSubclasses() ? new InheritanceStrategy() : new NoInheritanceStrategy();
    }

    PrefetchProcessorNode synchronizedRootResultNodeFromDataRows(List<? extends DataRow> rows) {
        PrefetchProcessorNode rootNode = new PrefetchProcessorNode(null, null);
        rootNode.setObjects(this.synchronizedObjectsFromDataRows(rows));
        return rootNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Persistent> synchronizedObjectsFromDataRows(List<? extends DataRow> rows) {
        ObjectStore objectStore = this.context.getObjectStore();
        synchronized (objectStore) {
            return this.objectsFromDataRows(rows);
        }
    }

    List<Persistent> objectsFromDataRows(List<? extends DataRow> rows) {
        if (rows == null || rows.size() == 0) {
            return new ArrayList<Persistent>(1);
        }
        ArrayList<Persistent> results = new ArrayList<Persistent>(rows.size());
        for (DataRow dataRow : rows) {
            results.add(this.objectFromDataRow(dataRow));
        }
        this.cache.snapshotsUpdatedForObjects(results, rows, this.refreshObjects);
        return results;
    }

    Persistent objectFromDataRow(DataRow row) {
        ClassDescriptor classDescriptor = this.descriptorResolutionStrategy.descriptorForRow(row);
        ObjectId anId = this.createObjectId(row, classDescriptor.getEntity(), null);
        return this.objectFromDataRow(row, anId, classDescriptor);
    }

    Persistent objectFromDataRow(DataRow row, ObjectId anId, ClassDescriptor classDescriptor) {
        if (anId == null) {
            return null;
        }
        Persistent object = this.context.findOrCreateObject(anId);
        this.resolveAdditionalIds(row, object, classDescriptor);
        int state = object.getPersistenceState();
        switch (state) {
            case 3: 
            case 4: 
            case 6: {
                if (!this.refreshObjects) break;
                DataRowUtils.mergeObjectWithSnapshot(this.context, classDescriptor, object, row);
                if (!(object instanceof DataObject)) break;
                ((DataObject)object).setSnapshotVersion(row.getVersion());
                break;
            }
            case 5: {
                DataRow cachedRow;
                if (!this.refreshObjects && (cachedRow = this.cache.getCachedSnapshot(anId)) != null) {
                    row = cachedRow;
                }
                DataRowUtils.mergeObjectWithSnapshot(this.context, classDescriptor, object, row);
                if (!(object instanceof DataObject)) break;
                ((DataObject)object).setSnapshotVersion(row.getVersion());
                break;
            }
        }
        return object;
    }

    private void resolveAdditionalIds(DataRow row, Persistent object, ClassDescriptor classDescriptor) {
        if (classDescriptor.getAdditionalDbEntities().isEmpty()) {
            return;
        }
        for (Map.Entry<String, DbEntity> entry : classDescriptor.getAdditionalDbEntities().entrySet()) {
            String prefix;
            DbEntity dbEntity = entry.getValue();
            String path = entry.getKey();
            int lastDot = path.lastIndexOf(46);
            String string = prefix = lastDot == -1 ? path : path.substring(lastDot + 1);
            ObjectId objectId = this.createObjectId(row, dbEntity.getName(), dbEntity.getPrimaryKeys(), prefix + '.', false);
            if (objectId == null) continue;
            this.context.getObjectStore().markFlattenedPath(object.getObjectId(), path);
        }
    }

    ObjEntity getEntity() {
        return this.descriptor.getEntity();
    }

    ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    EntityResolver getEntityResolver() {
        return this.context.getEntityResolver();
    }

    ObjectContext getContext() {
        return this.context;
    }

    ObjectId createObjectId(DataRow dataRow, ObjEntity objEntity, String namePrefix) {
        Collection<DbAttribute> pk = objEntity == this.descriptor.getEntity() ? this.primaryKey : objEntity.getDbEntity().getPrimaryKeys();
        return this.createObjectId(dataRow, objEntity.getName(), pk, namePrefix, true);
    }

    ObjectId createObjectId(DataRow dataRow, String name, Collection<DbAttribute> pk, String namePrefix, boolean strict) {
        boolean prefix;
        boolean bl = prefix = namePrefix != null && namePrefix.length() > 0;
        if (pk.size() == 1) {
            DbAttribute attribute = pk.iterator().next();
            String key = prefix ? namePrefix + attribute.getName() : attribute.getName();
            Object val = dataRow.get(key);
            if (val == null) {
                if (strict && !dataRow.containsKey(key)) {
                    throw new CayenneRuntimeException("No PK column '%s' found in data row.", key);
                }
                return null;
            }
            return new ObjectId(name, attribute.getName(), val);
        }
        HashMap idMap = new HashMap(pk.size() * 2);
        for (DbAttribute attribute : pk) {
            String key = prefix ? namePrefix + attribute.getName() : attribute.getName();
            Object val = dataRow.get(key);
            if (val == null) {
                if (strict && !dataRow.containsKey(key)) {
                    throw new CayenneRuntimeException("No PK column '%s' found in data row.", key);
                }
                return null;
            }
            idMap.put(attribute.getName(), val);
        }
        return new ObjectId(name, idMap);
    }

    class InheritanceStrategy
    implements DescriptorResolutionStrategy {
        InheritanceStrategy() {
        }

        @Override
        public final ClassDescriptor descriptorForRow(DataRow row) {
            String entityName = row.getEntityName();
            if (entityName == null && LOGGER.isWarnEnabled()) {
                LOGGER.warn("** Null entity name for DataRow, can't resolve sub descriptor for " + ObjectResolver.this.descriptor.getEntity().getName());
                return ObjectResolver.this.descriptor;
            }
            return ObjectResolver.this.context.getEntityResolver().getClassDescriptor(entityName);
        }
    }

    class NoInheritanceStrategy
    implements DescriptorResolutionStrategy {
        NoInheritanceStrategy() {
        }

        @Override
        public final ClassDescriptor descriptorForRow(DataRow row) {
            return ObjectResolver.this.descriptor;
        }
    }

    static interface DescriptorResolutionStrategy {
        public ClassDescriptor descriptorForRow(DataRow var1);
    }
}

