/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect;

import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.LifecycleEvent;
import org.apache.cayenne.reflect.LifecycleCallbackRegistry;
import org.apache.cayenne.reflect.PostAddListener;
import org.apache.cayenne.reflect.PostAddListenerSubclass;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Exhibit;
import org.apache.cayenne.testdo.testmap.Gallery;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class LifecycleCallbackRegistryIT
extends ServerCase {
    @Inject
    private ObjectContext context;

    @Test
    public void testAddListener_PostAdd() {
        LifecycleCallbackRegistry registry = new LifecycleCallbackRegistry(this.context.getEntityResolver());
        this.context.getEntityResolver().setCallbackRegistry(registry);
        PostAddListener listener = new PostAddListener();
        registry.addListener(listener);
        Assert.assertEquals((long)3L, (long)registry.getHandler(LifecycleEvent.POST_ADD).listenersSize());
        this.context.newObject(Gallery.class);
        Assert.assertEquals((Object)"e:Gallery;", (Object)listener.getAndReset());
        this.context.newObject(Artist.class);
        Assert.assertEquals((Object)"a:Artist;", (Object)listener.getAndReset());
        this.context.newObject(Exhibit.class);
        Assert.assertEquals((Object)"", (Object)listener.getAndReset());
        this.context.newObject(Painting.class);
        Assert.assertEquals((Object)"e:Painting;", (Object)listener.getAndReset());
    }

    @Test
    public void testAddListener_PostAdd_InheritedListenerMethods() {
        LifecycleCallbackRegistry registry = new LifecycleCallbackRegistry(this.context.getEntityResolver());
        this.context.getEntityResolver().setCallbackRegistry(registry);
        PostAddListenerSubclass listener = new PostAddListenerSubclass();
        registry.addListener(listener);
        Assert.assertEquals((long)3L, (long)registry.getHandler(LifecycleEvent.POST_ADD).listenersSize());
        this.context.newObject(Gallery.class);
        Assert.assertEquals((Object)"e:Gallery;", (Object)listener.getAndReset());
        this.context.newObject(Artist.class);
        Assert.assertEquals((Object)"a:Artist;", (Object)listener.getAndReset());
        this.context.newObject(Exhibit.class);
        Assert.assertEquals((Object)"", (Object)listener.getAndReset());
        this.context.newObject(Painting.class);
        Assert.assertEquals((Object)"e:Painting;", (Object)listener.getAndReset());
    }
}

