/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.util.Arrays;
import org.apache.cayenne.exp.parser.ASTLikeIgnoreCase;
import org.apache.cayenne.exp.parser.ASTNotLikeIgnoreCase;
import org.apache.cayenne.exp.parser.ASTObjPath;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.junit.Assert;
import org.junit.Test;

public class ASTLikeIgnoreCaseTest {
    @Test
    public void testToEJBQL() {
        ASTLikeIgnoreCase like = new ASTLikeIgnoreCase(new ASTObjPath("a"), "%b%");
        Assert.assertEquals((Object)like.toEJBQL("p"), (Object)"upper(p.a) like '%B%'");
    }

    @Test
    public void testEvaluate() {
        ASTLikeIgnoreCase like = new ASTLikeIgnoreCase(new ASTObjPath("artistName"), "aBcD");
        ASTNotLikeIgnoreCase notLike = new ASTNotLikeIgnoreCase(new ASTObjPath("artistName"), "aBcD");
        Artist noMatch1 = new Artist();
        noMatch1.setArtistName("dabc");
        Assert.assertFalse((boolean)like.match(noMatch1));
        Assert.assertTrue((boolean)notLike.match(noMatch1));
        Artist match1 = new Artist();
        match1.setArtistName("abcd");
        Assert.assertTrue((String)("Failed: " + like), (boolean)like.match(match1));
        Assert.assertFalse((String)("Failed: " + notLike), (boolean)notLike.match(match1));
        Artist match2 = new Artist();
        match2.setArtistName("ABcD");
        Assert.assertTrue((String)("Failed: " + like), (boolean)like.match(match2));
        Assert.assertFalse((String)("Failed: " + notLike), (boolean)notLike.match(match2));
    }

    @Test
    public void testEvaluateWithCollection() {
        ASTLikeIgnoreCase like = new ASTLikeIgnoreCase(new ASTObjPath("paintingArray.paintingTitle"), "aBcD");
        ASTNotLikeIgnoreCase notLike = new ASTNotLikeIgnoreCase(new ASTObjPath("paintingArray.paintingTitle"), "aBcD");
        Artist noMatch1 = new Artist();
        noMatch1.writePropertyDirectly("paintingArray", Arrays.asList(this.createPainting("xyz"), this.createPainting("abc")));
        Assert.assertFalse((String)("Failed: " + like), (boolean)like.match(noMatch1));
        Assert.assertTrue((String)("Failed: " + like), (boolean)notLike.match(noMatch1));
        Artist match1 = new Artist();
        match1.writePropertyDirectly("paintingArray", Arrays.asList(this.createPainting("AbCd"), this.createPainting("abcd")));
        Assert.assertTrue((String)("Failed: " + like), (boolean)like.match(match1));
        Assert.assertFalse((String)("Failed: " + like), (boolean)notLike.match(match1));
        Artist match2 = new Artist();
        match2.writePropertyDirectly("paintingArray", Arrays.asList(this.createPainting("Xzy"), this.createPainting("abcd")));
        Assert.assertTrue((String)("Failed: " + like), (boolean)like.match(match2));
        Assert.assertTrue((String)("Failed: " + like), (boolean)notLike.match(match2));
    }

    @Test
    public void testEvaluateUnicode() {
        ASTLikeIgnoreCase like = new ASTLikeIgnoreCase(new ASTObjPath("artistName"), "\u00c0\u0411\u011e\u00de%");
        ASTNotLikeIgnoreCase notLike = new ASTNotLikeIgnoreCase(new ASTObjPath("artistName"), "\u00c0\u0411\u011e\u00de%");
        Artist noMatch1 = new Artist();
        noMatch1.setArtistName("\u00e0b\u011f\u00fe");
        Assert.assertFalse((boolean)like.match(noMatch1));
        Assert.assertTrue((boolean)notLike.match(noMatch1));
        Artist match1 = new Artist();
        match1.setArtistName("\u00e0\u0431\u011f\u00fed");
        Assert.assertTrue((String)("Failed: " + like), (boolean)like.match(match1));
        Assert.assertFalse((String)("Failed: " + notLike), (boolean)notLike.match(match1));
        Artist match2 = new Artist();
        match2.setArtistName("\u00e0\u0411\u011f\u00de");
        Assert.assertTrue((String)("Failed: " + like), (boolean)like.match(match2));
        Assert.assertFalse((String)("Failed: " + notLike), (boolean)notLike.match(match2));
    }

    private Painting createPainting(String name) {
        Painting p = new Painting();
        p.setPaintingTitle(name);
        return p;
    }
}

