/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.ejbql.parser;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import org.apache.cayenne.ejbql.EJBQLExpression;
import org.apache.cayenne.ejbql.EJBQLExpressionVisitor;
import org.apache.cayenne.ejbql.parser.Node;

public abstract class SimpleNode
implements Node,
Serializable,
EJBQLExpression {
    final int id;
    SimpleNode parent;
    SimpleNode[] children;
    boolean not;
    String text;

    public SimpleNode(int id) {
        this.id = id;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public boolean isNegated() {
        return this.not;
    }

    @Override
    public void visit(EJBQLExpressionVisitor visitor) {
        if (this.visitNode(visitor)) {
            int len = this.getChildrenCount();
            for (int i = 0; i < len && this.visitChild(visitor, i); ++i) {
            }
        }
    }

    protected boolean visitNode(EJBQLExpressionVisitor visitor) {
        return true;
    }

    protected boolean visitChild(EJBQLExpressionVisitor visitor, int childIndex) {
        this.children[childIndex].visit(visitor);
        return true;
    }

    @Override
    public EJBQLExpression getChild(int index) {
        return this.jjtGetChild(index);
    }

    @Override
    public int getChildrenCount() {
        return this.jjtGetNumChildren();
    }

    public String getName() {
        String className = this.getClass().getName();
        int i = className.lastIndexOf("EJBQL");
        return i >= 0 ? className.substring(i + 5) : className;
    }

    @Override
    public void jjtOpen() {
    }

    @Override
    public void jjtClose() {
    }

    @Override
    public void jjtSetParent(Node parent) {
        this.parent = (SimpleNode)parent;
    }

    @Override
    public Node jjtGetParent() {
        return this.parent;
    }

    @Override
    public void jjtAddChild(Node n, int i) {
        if (this.children == null) {
            this.children = new SimpleNode[i + 1];
        } else if (i >= this.children.length) {
            SimpleNode[] c = new SimpleNode[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = (SimpleNode)n;
    }

    @Override
    public Node jjtGetChild(int i) {
        return this.children[i];
    }

    @Override
    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String toString() {
        StringWriter buffer = new StringWriter();
        PrintWriter pw = new PrintWriter(buffer);
        this.dump(pw, "", true);
        pw.close();
        buffer.flush();
        return buffer.toString();
    }

    void dump(PrintWriter out, String prefix, boolean text) {
        out.println(prefix + this.getName() + (text && this.text != null ? " [" + this.text + "]" : ""));
        if (this.children != null) {
            for (SimpleNode n : this.children) {
                if (n == null) continue;
                n.dump(out, prefix + " ", text);
            }
        }
    }
}

