/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.List;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.query.SortOrder;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextOuterJoinsIT
extends ServerCase {
    @Inject
    protected ObjectContext context;
    @Inject
    protected DBHelper dbHelper;
    protected TableHelper artistHelper;
    protected TableHelper paintingHelper;
    protected TableHelper artgroupHelper;
    protected TableHelper artistGroupHelper;

    @Override
    public void cleanUpDB() throws Exception {
        this.dbHelper.update("ARTGROUP").set("PARENT_GROUP_ID", null, 4).execute();
        super.cleanUpDB();
    }

    @Before
    public void setUp() throws Exception {
        this.artistHelper = new TableHelper(this.dbHelper, "ARTIST", new String[]{"ARTIST_ID", "ARTIST_NAME"});
        this.paintingHelper = new TableHelper(this.dbHelper, "PAINTING", new String[]{"PAINTING_ID", "ARTIST_ID", "PAINTING_TITLE"}).setColumnTypes(new int[]{4, -5, 12});
        this.artgroupHelper = new TableHelper(this.dbHelper, "ARTGROUP", new String[]{"GROUP_ID", "NAME"});
        this.artistGroupHelper = new TableHelper(this.dbHelper, "ARTIST_GROUP", new String[]{"GROUP_ID", "ARTIST_ID"});
    }

    @Test
    public void testSelectWithOuterJoinFlattened() throws Exception {
        this.artistHelper.insert(new Object[]{33001, "AA1"});
        this.artistHelper.insert(new Object[]{33002, "AA2"});
        this.artistHelper.insert(new Object[]{33003, "BB1"});
        this.artistHelper.insert(new Object[]{33004, "BB2"});
        this.artgroupHelper.insert(new Object[]{1, "G1"});
        this.artistGroupHelper.insert(new Object[]{1, 33001});
        this.artistGroupHelper.insert(new Object[]{1, 33002});
        this.artistGroupHelper.insert(new Object[]{1, 33004});
        SelectQuery<Artist> missingToManyQuery = new SelectQuery<Artist>(Artist.class);
        missingToManyQuery.andQualifier(Artist.GROUP_ARRAY.outer().isNull());
        missingToManyQuery.addOrdering(Artist.ARTIST_NAME.asc());
        List<Artist> artists = missingToManyQuery.select(this.context);
        Assert.assertEquals((long)1L, (long)artists.size());
        Assert.assertEquals((Object)"BB1", (Object)artists.get(0).getArtistName());
    }

    @Test
    public void testSelectWithOuterJoin() throws Exception {
        this.artistHelper.insert(new Object[]{33001, "AA1"});
        this.artistHelper.insert(new Object[]{33002, "AA2"});
        this.artistHelper.insert(new Object[]{33003, "BB1"});
        this.artistHelper.insert(new Object[]{33004, "BB2"});
        this.paintingHelper.insert(new Object[]{33001, 33001, "P1"});
        this.paintingHelper.insert(new Object[]{33002, 33002, "P2"});
        SelectQuery<Artist> missingToManyQuery = SelectQuery.query(Artist.class);
        missingToManyQuery.andQualifier(Artist.PAINTING_ARRAY.outer().isNull());
        missingToManyQuery.addOrdering(Artist.ARTIST_NAME.asc());
        List<Artist> artists = missingToManyQuery.select(this.context);
        Assert.assertEquals((long)2L, (long)artists.size());
        Assert.assertEquals((Object)"BB1", (Object)artists.get(0).getArtistName());
        SelectQuery<Artist> mixedConditionQuery = SelectQuery.query(Artist.class);
        mixedConditionQuery.andQualifier(Artist.PAINTING_ARRAY.outer().isNull());
        mixedConditionQuery.orQualifier(Artist.ARTIST_NAME.eq("AA1"));
        mixedConditionQuery.addOrdering(Artist.ARTIST_NAME.asc());
        artists = mixedConditionQuery.select(this.context);
        Assert.assertEquals((long)3L, (long)artists.size());
        Assert.assertEquals((Object)"AA1", (Object)artists.get(0).getArtistName());
        Assert.assertEquals((Object)"BB1", (Object)artists.get(1).getArtistName());
        Assert.assertEquals((Object)"BB2", (Object)artists.get(2).getArtistName());
    }

    @Test
    public void testSelectWithOuterJoinFromString() throws Exception {
        this.artistHelper.insert(new Object[]{33001, "AA1"});
        this.artistHelper.insert(new Object[]{33002, "AA2"});
        this.artistHelper.insert(new Object[]{33003, "BB1"});
        this.artistHelper.insert(new Object[]{33004, "BB2"});
        this.paintingHelper.insert(new Object[]{33001, 33001, "P1"});
        this.paintingHelper.insert(new Object[]{33002, 33002, "P2"});
        SelectQuery<Artist> missingToManyQuery = new SelectQuery<Artist>(Artist.class);
        missingToManyQuery.andQualifier(ExpressionFactory.exp("paintingArray+ = null", new Object[0]));
        missingToManyQuery.addOrdering(Artist.ARTIST_NAME.asc());
        List<Artist> artists = missingToManyQuery.select(this.context);
        Assert.assertEquals((long)2L, (long)artists.size());
        Assert.assertEquals((Object)"BB1", (Object)artists.get(0).getArtistName());
        SelectQuery<Artist> mixedConditionQuery = new SelectQuery<Artist>(Artist.class);
        mixedConditionQuery.andQualifier(Artist.PAINTING_ARRAY.outer().isNull());
        mixedConditionQuery.orQualifier(Artist.ARTIST_NAME.eq("AA1"));
        mixedConditionQuery.addOrdering(Artist.ARTIST_NAME.asc());
        artists = mixedConditionQuery.select(this.context);
        Assert.assertEquals((long)3L, (long)artists.size());
        Assert.assertEquals((Object)"AA1", (Object)artists.get(0).getArtistName());
        Assert.assertEquals((Object)"BB1", (Object)artists.get(1).getArtistName());
        Assert.assertEquals((Object)"BB2", (Object)artists.get(2).getArtistName());
    }

    @Test
    public void testSelectWithOuterOrdering() throws Exception {
        this.artistHelper.insert(new Object[]{33001, "AA1"});
        this.artistHelper.insert(new Object[]{33002, "AA2"});
        this.paintingHelper.insert(new Object[]{33001, 33001, "P1"});
        this.paintingHelper.insert(new Object[]{33002, 33002, "P2"});
        this.paintingHelper.insert(new Object[]{33003, null, "P3"});
        SelectQuery<Painting> query = new SelectQuery<Painting>(Painting.class);
        query.addOrdering("toArtist+.artistName", SortOrder.DESCENDING);
        List<Painting> paintings = query.select(this.context);
        Assert.assertEquals((long)3L, (long)paintings.size());
    }
}

