/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.List;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.testdo.lob.ClobTestEntity;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-lob.xml")
public class DataContextClobIT
extends ServerCase {
    @Inject
    private DataContext context;
    @Inject
    private DataContext context2;
    @Inject
    private DataContext context3;
    @Inject
    private UnitDbAdapter accessStackAdapter;

    private boolean skipTests() {
        return !this.accessStackAdapter.supportsLobs();
    }

    private boolean skipEmptyLOBTests() {
        return !this.accessStackAdapter.handlesNullVsEmptyLOBs();
    }

    @Test
    public void testEmptyClob() throws Exception {
        if (this.skipEmptyLOBTests()) {
            return;
        }
        this.runWithClobSize(0);
    }

    @Test
    public void test5ByteClob() throws Exception {
        if (this.skipTests()) {
            return;
        }
        this.runWithClobSize(5);
    }

    @Test
    public void test5KByteClob() throws Exception {
        if (this.skipTests()) {
            return;
        }
        this.runWithClobSize(5120);
    }

    @Test
    public void test1MBClob() throws Exception {
        if (this.skipTests()) {
            return;
        }
        this.runWithClobSize(0x100000);
    }

    @Test
    public void testNullClob() throws Exception {
        if (this.skipTests()) {
            return;
        }
        this.context.newObject(ClobTestEntity.class);
        this.context.commitChanges();
        List objects2 = this.context2.performQuery(new SelectQuery<ClobTestEntity>(ClobTestEntity.class));
        Assert.assertEquals((long)1L, (long)objects2.size());
        ClobTestEntity clobObj2 = (ClobTestEntity)objects2.get(0);
        Assert.assertNull((String)("Expected null, got: '" + clobObj2.getClobCol() + "'"), (Object)clobObj2.getClobCol());
        clobObj2.setClobCol("updated rather small clob...");
        this.context2.commitChanges();
        List objects3 = this.context3.performQuery(new SelectQuery<ClobTestEntity>(ClobTestEntity.class));
        Assert.assertEquals((long)1L, (long)objects3.size());
        ClobTestEntity clobObj3 = (ClobTestEntity)objects3.get(0);
        Assert.assertEquals((Object)clobObj2.getClobCol(), (Object)clobObj3.getClobCol());
    }

    protected void runWithClobSize(int sizeBytes) throws Exception {
        ClobTestEntity clobObj1 = this.context.newObject(ClobTestEntity.class);
        if (sizeBytes == 0) {
            clobObj1.setClobCol("");
        } else {
            byte[] bytes = new byte[sizeBytes];
            for (int i = 0; i < sizeBytes; ++i) {
                bytes[i] = (byte)(65 + (50 + i) % 50);
            }
            clobObj1.setClobCol(new String(bytes));
        }
        this.context.commitChanges();
        List objects2 = this.context2.performQuery(new SelectQuery<ClobTestEntity>(ClobTestEntity.class));
        Assert.assertEquals((long)1L, (long)objects2.size());
        ClobTestEntity clobObj2 = (ClobTestEntity)objects2.get(0);
        Assert.assertEquals((Object)clobObj1.getClobCol(), (Object)clobObj2.getClobCol());
        clobObj2.setClobCol("updated rather small clob...");
        this.context2.commitChanges();
        List objects3 = this.context3.performQuery(new SelectQuery<ClobTestEntity>(ClobTestEntity.class));
        Assert.assertEquals((long)1L, (long)objects3.size());
        ClobTestEntity clobObj3 = (ClobTestEntity)objects3.get(0);
        Assert.assertEquals((Object)clobObj2.getClobCol(), (Object)clobObj3.getClobCol());
    }
}

