/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class PersistenceByReachabilityIT
extends ServerCase {
    @Inject
    private ObjectContext context;
    @Inject
    private ObjectContext context1;

    @Test
    public void testToOneTargetTransient() throws Exception {
        Painting persistentDO = this.context.newObject(Painting.class);
        Artist transientDO = new Artist();
        persistentDO.setToOneTarget(Painting.TO_ARTIST.getName(), transientDO, false);
        Assert.assertEquals((long)2L, (long)transientDO.getPersistenceState());
    }

    @Test
    public void testToOneTargetPersistent() throws Exception {
        Painting transientDO = this.context.newObject(Painting.class);
        Artist persistentDO = new Artist();
        transientDO.setToOneTarget(Painting.TO_ARTIST.getName(), persistentDO, false);
        Assert.assertEquals((long)2L, (long)transientDO.getPersistenceState());
    }

    @Test
    public void testToOneTargetDifferentContext() throws Exception {
        Painting doC1 = this.context.newObject(Painting.class);
        Artist doC2 = this.context1.newObject(Artist.class);
        try {
            doC1.setToOneTarget(Painting.TO_ARTIST.getName(), doC2, false);
            Assert.fail((String)"failed to detect relationship between objects in different DataContexts");
        }
        catch (CayenneRuntimeException cayenneRuntimeException) {
            // empty catch block
        }
    }

    @Test
    public void testToManyTargetDifferentContext() throws Exception {
        Painting doC1 = this.context.newObject(Painting.class);
        Artist doC2 = this.context1.newObject(Artist.class);
        try {
            doC2.addToManyTarget(Artist.PAINTING_ARRAY.getName(), doC1, false);
            Assert.fail((String)"failed to detect relationship between objects in different DataContexts");
        }
        catch (CayenneRuntimeException cayenneRuntimeException) {
            // empty catch block
        }
    }

    @Test
    public void testToManyTargetTransient() throws Exception {
        Painting transientDO = this.context.newObject(Painting.class);
        Artist persistentDO = new Artist();
        persistentDO.addToManyTarget(Artist.PAINTING_ARRAY.getName(), transientDO, false);
        Assert.assertEquals((long)2L, (long)transientDO.getPersistenceState());
    }

    @Test
    public void testToManyTargetPersistent() throws Exception {
        Painting persistentDO = this.context.newObject(Painting.class);
        Artist transientDO = new Artist();
        transientDO.addToManyTarget(Artist.PAINTING_ARRAY.getName(), persistentDO, false);
        Assert.assertEquals((long)2L, (long)transientDO.getPersistenceState());
    }
}

