/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.DataChannelInterceptor;
import org.apache.cayenne.unit.di.UnitTestClosure;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextMaxIdQualifierIT
extends ServerCase {
    @Inject
    protected DataContext context;
    @Inject
    protected DBHelper dbHelper;
    @Inject
    protected DataChannelInterceptor queryInterceptor;
    @Inject
    protected ServerRuntime runtime;
    private TableHelper tArtist;
    private TableHelper tPainting;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
        this.tPainting = new TableHelper(this.dbHelper, "PAINTING");
        this.tPainting.setColumns(new String[]{"PAINTING_ID", "ARTIST_ID", "PAINTING_TITLE"}).setColumnTypes(new int[]{4, -5, 12});
    }

    private void insertData() throws SQLException {
        for (int i = 1; i <= 100; ++i) {
            this.tArtist.insert(new Object[]{i, "AA" + i});
            this.tPainting.insert(new Object[]{i, i, "P" + i});
        }
    }

    private void insertData_OneBag_100Boxes() throws SQLException {
        this.tArtist.insert(new Object[]{1, "AA1"});
        for (int i = 1; i <= 100; ++i) {
            this.tPainting.insert(new Object[]{i, 1, "P" + i});
        }
    }

    @Test
    public void testDisjointByIdPrefetch() throws Exception {
        this.insertData();
        this.runtime.getDataDomain().setMaxIdQualifierSize(10);
        final SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        query.addPrefetch(Artist.PAINTING_ARRAY.disjointById());
        int queriesCount = this.queryInterceptor.runWithQueryCounter(new UnitTestClosure(){

            @Override
            public void execute() {
                DataContextMaxIdQualifierIT.this.context.performQuery(query);
            }
        });
        Assert.assertEquals((long)11L, (long)queriesCount);
    }

    @Test
    public void testDisjointByIdPrefetch_Zero() throws Exception {
        this.insertData();
        this.runtime.getDataDomain().setMaxIdQualifierSize(0);
        final SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        query.addPrefetch(Artist.PAINTING_ARRAY.disjointById());
        int queriesCount = this.queryInterceptor.runWithQueryCounter(new UnitTestClosure(){

            @Override
            public void execute() {
                DataContextMaxIdQualifierIT.this.context.performQuery(query);
            }
        });
        Assert.assertEquals((long)2L, (long)queriesCount);
    }

    @Test
    public void testDisjointByIdPrefetch_Negative() throws Exception {
        this.insertData();
        this.runtime.getDataDomain().setMaxIdQualifierSize(-1);
        final SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        query.addPrefetch(Artist.PAINTING_ARRAY.disjointById());
        int queriesCount = this.queryInterceptor.runWithQueryCounter(new UnitTestClosure(){

            @Override
            public void execute() {
                DataContextMaxIdQualifierIT.this.context.performQuery(query);
            }
        });
        Assert.assertEquals((long)2L, (long)queriesCount);
    }

    @Test
    public void testIncrementalFaultList_Lower() throws Exception {
        this.insertData_OneBag_100Boxes();
        this.runtime.getDataDomain().setMaxIdQualifierSize(5);
        final SelectQuery<Painting> query = new SelectQuery<Painting>(Painting.class);
        query.setPageSize(10);
        int queriesCount = this.queryInterceptor.runWithQueryCounter(new UnitTestClosure(){

            @Override
            public void execute() {
                List boxes = DataContextMaxIdQualifierIT.this.context.performQuery(query);
                for (Painting box : boxes) {
                    box.getToArtist();
                }
            }
        });
        Assert.assertEquals((long)21L, (long)queriesCount);
        queriesCount = this.queryInterceptor.runWithQueryCounter(new UnitTestClosure(){

            @Override
            public void execute() {
                List boxes = DataContextMaxIdQualifierIT.this.context.performQuery(query);
                ArrayList tempList = new ArrayList();
                tempList.addAll(boxes);
            }
        });
        Assert.assertEquals((long)21L, (long)queriesCount);
    }

    @Test
    public void testIncrementalFaultList_Higher() throws Exception {
        this.insertData_OneBag_100Boxes();
        this.runtime.getDataDomain().setMaxIdQualifierSize(101);
        final SelectQuery<Painting> query = new SelectQuery<Painting>(Painting.class);
        query.setPageSize(10);
        int queriesCount = this.queryInterceptor.runWithQueryCounter(new UnitTestClosure(){

            @Override
            public void execute() {
                List boxes = DataContextMaxIdQualifierIT.this.context.performQuery(query);
                for (Painting box : boxes) {
                    box.getToArtist();
                }
            }
        });
        Assert.assertEquals((long)11L, (long)queriesCount);
        queriesCount = this.queryInterceptor.runWithQueryCounter(new UnitTestClosure(){

            @Override
            public void execute() {
                List boxes = DataContextMaxIdQualifierIT.this.context.performQuery(query);
                ArrayList tempList = new ArrayList();
                tempList.addAll(boxes);
            }
        });
        Assert.assertEquals((long)2L, (long)queriesCount);
    }

    @Test
    public void testIncrementalFaultList_Zero() throws Exception {
        this.insertData_OneBag_100Boxes();
        this.runtime.getDataDomain().setMaxIdQualifierSize(0);
        final SelectQuery<Painting> query = new SelectQuery<Painting>(Painting.class);
        query.setPageSize(10);
        int queriesCount = this.queryInterceptor.runWithQueryCounter(new UnitTestClosure(){

            @Override
            public void execute() {
                List boxes = DataContextMaxIdQualifierIT.this.context.performQuery(query);
                ArrayList tempList = new ArrayList();
                tempList.addAll(boxes);
            }
        });
        Assert.assertEquals((long)2L, (long)queriesCount);
    }

    @Test
    public void testIncrementalFaultList_Negative() throws Exception {
        this.insertData_OneBag_100Boxes();
        this.runtime.getDataDomain().setMaxIdQualifierSize(-1);
        final SelectQuery<Painting> query = new SelectQuery<Painting>(Painting.class);
        query.setPageSize(10);
        int queriesCount = this.queryInterceptor.runWithQueryCounter(new UnitTestClosure(){

            @Override
            public void execute() {
                List boxes = DataContextMaxIdQualifierIT.this.context.performQuery(query);
                ArrayList tempList = new ArrayList();
                tempList.addAll(boxes);
            }
        });
        Assert.assertEquals((long)2L, (long)queriesCount);
    }
}

