/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.io.ByteArrayInputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.HashMap;
import java.util.SortedMap;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.MapLoader;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.map.SelectQueryDescriptor;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.util.XMLEncoder;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.InputSource;

public class DataMapTest {
    @Test
    public void testSerializability() throws Exception {
        DataMap m1 = new DataMap("abc");
        DataMap d1 = Util.cloneViaSerialization(m1);
        Assert.assertEquals((Object)m1.getName(), (Object)d1.getName());
        ObjEntity oe1 = new ObjEntity("oe1");
        m1.addObjEntity(oe1);
        DataMap d2 = Util.cloneViaSerialization(m1);
        Assert.assertNotNull((Object)d2.getObjEntity(oe1.getName()));
    }

    @Test
    public void testInitWithProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("clientSupported", "true");
        properties.put("defaultClientPackage", "aaaaa");
        DataMap map = new DataMap();
        map.initWithProperties(properties);
        Assert.assertTrue((boolean)map.isClientSupported());
        Assert.assertEquals((Object)"aaaaa", (Object)map.getDefaultClientPackage());
    }

    @Test
    public void testDefaultSchema() {
        DataMap map = new DataMap();
        String tstSchema = "tst_schema";
        Assert.assertNull((Object)map.getDefaultSchema());
        map.setDefaultSchema(tstSchema);
        Assert.assertEquals((Object)tstSchema, (Object)map.getDefaultSchema());
        map.setDefaultSchema(null);
        Assert.assertNull((Object)map.getDefaultSchema());
    }

    @Test
    public void testDefaultClientPackage() {
        DataMap map = new DataMap();
        String tstPackage = "tst.pkg";
        Assert.assertNull((Object)map.getDefaultClientPackage());
        map.setDefaultClientPackage(tstPackage);
        Assert.assertEquals((Object)tstPackage, (Object)map.getDefaultClientPackage());
        map.setDefaultClientPackage(null);
        Assert.assertNull((Object)map.getDefaultClientPackage());
    }

    @Test
    public void testDefaultClientSuperclass() {
        DataMap map = new DataMap();
        String tstSuperclass = "tst_superclass";
        Assert.assertNull((Object)map.getDefaultClientSuperclass());
        map.setDefaultClientSuperclass(tstSuperclass);
        Assert.assertEquals((Object)tstSuperclass, (Object)map.getDefaultClientSuperclass());
        map.setDefaultClientSuperclass(null);
        Assert.assertNull((Object)map.getDefaultClientSuperclass());
    }

    @Test
    public void testDefaultPackage() {
        DataMap map = new DataMap();
        String tstPackage = "tst.pkg";
        Assert.assertNull((Object)map.getDefaultPackage());
        map.setDefaultPackage(tstPackage);
        Assert.assertEquals((Object)tstPackage, (Object)map.getDefaultPackage());
        map.setDefaultPackage(null);
        Assert.assertNull((Object)map.getDefaultPackage());
    }

    @Test
    public void testDefaultSuperclass() {
        DataMap map = new DataMap();
        String tstSuperclass = "tst_superclass";
        Assert.assertNull((Object)map.getDefaultSuperclass());
        map.setDefaultSuperclass(tstSuperclass);
        Assert.assertEquals((Object)tstSuperclass, (Object)map.getDefaultSuperclass());
        map.setDefaultSuperclass(null);
        Assert.assertNull((Object)map.getDefaultSuperclass());
    }

    @Test
    public void testDefaultLockType() {
        DataMap map = new DataMap();
        Assert.assertEquals((long)0L, (long)map.getDefaultLockType());
        map.setDefaultLockType(1);
        Assert.assertEquals((long)1L, (long)map.getDefaultLockType());
        map.setDefaultLockType(0);
        Assert.assertEquals((long)0L, (long)map.getDefaultLockType());
    }

    @Test
    public void testName() {
        DataMap map = new DataMap();
        String tstName = "tst_name";
        map.setName(tstName);
        Assert.assertEquals((Object)tstName, (Object)map.getName());
    }

    @Test
    public void testLocation() {
        DataMap map = new DataMap();
        String tstName = "tst_name";
        Assert.assertNull((Object)map.getLocation());
        map.setLocation(tstName);
        Assert.assertEquals((Object)tstName, (Object)map.getLocation());
    }

    @Test
    public void testAddObjEntity() {
        DataMap map = new DataMap();
        ObjEntity e = new ObjEntity("b");
        e.setClassName("b");
        map.addObjEntity(e);
        Assert.assertSame((Object)e, (Object)map.getObjEntity(e.getName()));
        Assert.assertSame((Object)map, (Object)e.getDataMap());
    }

    @Test
    public void testAddEntityWithSameName() {
        DataMap map = new DataMap();
        ObjEntity e1 = new ObjEntity("c");
        e1.setClassName("c1");
        ObjEntity e2 = new ObjEntity("c");
        e2.setClassName("c2");
        map.addObjEntity(e1);
        try {
            map.addObjEntity(e2);
            Assert.fail((String)"Should not be able to add more than one entity with the same name");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveThenAddNullClassName() {
        DataMap map = new DataMap();
        ObjEntity e = new ObjEntity("f");
        map.addObjEntity(e);
        map.removeObjEntity(e.getName(), false);
        map.addObjEntity(e);
    }

    @Test
    public void testRemoveObjEntity() {
        ObjEntity e1 = new ObjEntity("1");
        ObjEntity e2 = new ObjEntity("2");
        ObjRelationship r1 = new ObjRelationship("r1");
        r1.setTargetEntityName("2");
        ObjRelationship r2 = new ObjRelationship("r2");
        r2.setTargetEntityName("1");
        ObjRelationship r3 = new ObjRelationship("r3");
        r1.setTargetEntityName("2");
        ObjRelationship r4 = new ObjRelationship("r4");
        r4.setTargetEntityName("1");
        e1.addRelationship(r1);
        e1.addRelationship(r2);
        e2.addRelationship(r3);
        e2.addRelationship(r4);
        DataMap map = new DataMap();
        map.addObjEntity(e1);
        map.addObjEntity(e2);
        map.removeObjEntity("1", true);
        Assert.assertNull((Object)map.getObjEntity("1"));
        Assert.assertEquals((long)1L, (long)e2.getRelationships().size());
        map.removeObjEntity("2", true);
        Assert.assertNull((Object)map.getObjEntity("2"));
    }

    @Test
    public void testMultipleNullClassNames() {
        ObjEntity e1 = new ObjEntity("g");
        ObjEntity e2 = new ObjEntity("h");
        DataMap map = new DataMap();
        map.addObjEntity(e1);
        map.addObjEntity(e2);
    }

    @Test
    public void testRemoveThenAddRealClassName() {
        ObjEntity e = new ObjEntity("f");
        e.setClassName("f");
        DataMap map = new DataMap();
        map.addObjEntity(e);
        map.removeObjEntity(e.getName(), false);
        map.addObjEntity(e);
    }

    @Test
    public void testAddEmbeddable() {
        Embeddable e = new Embeddable("XYZ");
        DataMap map = new DataMap();
        Assert.assertEquals((long)0L, (long)map.getEmbeddables().size());
        map.addEmbeddable(e);
        Assert.assertEquals((long)1L, (long)map.getEmbeddables().size());
        Assert.assertTrue((boolean)map.getEmbeddables().contains(e));
    }

    @Test
    public void testRemoveEmbeddable() {
        Embeddable e = new Embeddable("XYZ");
        DataMap map = new DataMap();
        map.addEmbeddable(e);
        Assert.assertTrue((boolean)map.getEmbeddables().contains(e));
        map.removeEmbeddable("123");
        Assert.assertTrue((boolean)map.getEmbeddables().contains(e));
        map.removeEmbeddable("XYZ");
        Assert.assertFalse((boolean)map.getEmbeddables().contains(e));
    }

    @Test
    public void testAddDbEntity() {
        DbEntity e = new DbEntity("b");
        DataMap map = new DataMap();
        map.addDbEntity(e);
        Assert.assertSame((Object)e, (Object)map.getDbEntity(e.getName()));
        Assert.assertSame((Object)map, (Object)e.getDataMap());
    }

    @Test
    public void testAddQueryDescriptor() {
        SelectQueryDescriptor q = QueryDescriptor.selectQueryDescriptor();
        q.setName("a");
        DataMap map = new DataMap();
        map.addQueryDescriptor(q);
        Assert.assertSame((Object)q, (Object)map.getQueryDescriptor("a"));
    }

    @Test
    public void testRemoveQueryDescriptor() {
        SelectQueryDescriptor q = QueryDescriptor.selectQueryDescriptor();
        q.setName("a");
        DataMap map = new DataMap();
        map.addQueryDescriptor(q);
        Assert.assertSame((Object)q, (Object)map.getQueryDescriptor("a"));
        map.removeQueryDescriptor("a");
        Assert.assertNull((Object)map.getQueryDescriptor("a"));
    }

    @Test
    public void testGetQueryMap() {
        SelectQueryDescriptor q = QueryDescriptor.selectQueryDescriptor();
        q.setName("a");
        DataMap map = new DataMap();
        map.addQueryDescriptor(q);
        SortedMap<String, QueryDescriptor> queries = map.getQueryDescriptorMap();
        Assert.assertEquals((long)1L, (long)queries.size());
        Assert.assertSame((Object)q, queries.get("a"));
    }

    @Test
    public void testRemoveDbEntity() {
        DataMap map = new DataMap();
        DbEntity e1 = new DbEntity();
        e1.setName("e1");
        DbEntity e2 = new DbEntity();
        e2.setName("e2");
        DbRelationship r1 = new DbRelationship();
        r1.setName("r1");
        r1.setTargetEntityName(e2);
        DbRelationship r2 = new DbRelationship();
        r2.setName("r2");
        r2.setTargetEntityName(e1);
        DbRelationship r3 = new DbRelationship();
        r3.setName("r3");
        r3.setTargetEntityName(e2);
        e1.addRelationship(r1);
        e1.addRelationship(r2);
        e1.addRelationship(r3);
        e2.addRelationship(r1);
        e2.addRelationship(r2);
        e2.addRelationship(r3);
        map.addDbEntity(e1);
        map.addDbEntity(e2);
        map.removeDbEntity(e1.getName(), true);
        Assert.assertNull((Object)map.getDbEntity(e1.getName()));
        map.removeDbEntity(e2.getName(), true);
        Assert.assertNull((Object)map.getDbEntity(e2.getName()));
    }

    @Test
    public void testChildProcedures() throws Exception {
        DataMap map = new DataMap();
        this.checkProcedures(map, new String[0]);
        map.addProcedure(new Procedure("proc1"));
        this.checkProcedures(map, new String[]{"proc1"});
        map.addProcedure(new Procedure("proc2"));
        this.checkProcedures(map, new String[]{"proc1", "proc2"});
        map.removeProcedure("proc2");
        this.checkProcedures(map, new String[]{"proc1"});
    }

    protected void checkProcedures(DataMap map, String[] expectedNames) throws Exception {
        int len = expectedNames.length;
        SortedMap<String, Procedure> proceduresMap = map.getProcedureMap();
        Collection<Procedure> proceduresCollection = map.getProcedures();
        Assert.assertNotNull(proceduresMap);
        Assert.assertEquals((long)len, (long)proceduresMap.size());
        Assert.assertNotNull(proceduresCollection);
        Assert.assertEquals((long)len, (long)proceduresCollection.size());
        for (int i = 0; i < len; ++i) {
            Procedure proc = map.getProcedure(expectedNames[i]);
            Assert.assertNotNull((Object)proc);
            Assert.assertEquals((Object)expectedNames[i], (Object)proc.getName());
        }
    }

    @Test
    public void testQuoteSqlIdentifiersEncodeAsXML() {
        DataMap map = new DataMap("aaa");
        map.setQuotingSQLIdentifiers(true);
        StringWriter w = new StringWriter();
        XMLEncoder encoder = new XMLEncoder(new PrintWriter(w));
        map.encodeAsXML(encoder);
        Assert.assertTrue((boolean)map.quotingSQLIdentifiers);
        MapLoader loader = new MapLoader();
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(w.getBuffer().toString().getBytes("UTF-8"));
            DataMap newMap = loader.loadDataMap(new InputSource(is));
            Assert.assertTrue((boolean)newMap.quotingSQLIdentifiers);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        map.setQuotingSQLIdentifiers(false);
        StringWriter w2 = new StringWriter();
        XMLEncoder encoder2 = new XMLEncoder(new PrintWriter(w2));
        map.encodeAsXML(encoder2);
        Assert.assertFalse((boolean)map.quotingSQLIdentifiers);
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(w2.getBuffer().toString().getBytes("UTF-8"));
            DataMap newMap = loader.loadDataMap(new InputSource(is));
            Assert.assertFalse((boolean)newMap.quotingSQLIdentifiers);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }
}

