/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.server;

import com.mockrunner.mock.jdbc.MockConnection;
import com.mockrunner.mock.jdbc.MockDataSource;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.DataSource;
import org.apache.cayenne.access.translator.batch.BatchTranslatorFactory;
import org.apache.cayenne.access.types.DefaultValueObjectTypeRegistry;
import org.apache.cayenne.access.types.ValueObjectTypeRegistry;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.DefaultRuntimeProperties;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.configuration.server.DbAdapterDetector;
import org.apache.cayenne.configuration.server.DefaultDbAdapterFactory;
import org.apache.cayenne.configuration.server.ServerModule;
import org.apache.cayenne.dba.AutoAdapter;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.sybase.SybaseAdapter;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.Binder;
import org.apache.cayenne.di.ClassLoaderManager;
import org.apache.cayenne.di.DIBootstrap;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.di.Key;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.di.spi.DefaultAdhocObjectFactory;
import org.apache.cayenne.di.spi.DefaultClassLoaderManager;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.log.Slf4jJdbcEventLogger;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.resource.ClassLoaderResourceLocator;
import org.apache.cayenne.resource.ResourceLocator;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class DefaultDbAdapterFactoryTest {
    @Test
    public void testCreatedAdapter_Auto() throws Exception {
        final DbAdapter adapter = (DbAdapter)Mockito.mock(DbAdapter.class);
        Mockito.when((Object)adapter.createTable((DbEntity)Matchers.any(DbEntity.class))).thenReturn((Object)"XXXXX");
        ArrayList<DbAdapterDetector> detectors = new ArrayList<DbAdapterDetector>();
        detectors.add(new DbAdapterDetector(){

            @Override
            public DbAdapter createAdapter(DatabaseMetaData md) throws SQLException {
                return adapter;
            }
        });
        MockConnection connection = new MockConnection();
        MockDataSource dataSource = new MockDataSource();
        dataSource.setupConnection((Connection)connection);
        Module testModule = new Module(){

            public void configure(Binder binder) {
                ServerModule.contributeProperties(binder);
                binder.bind(JdbcEventLogger.class).to(Slf4jJdbcEventLogger.class);
                binder.bind(ClassLoaderManager.class).to(DefaultClassLoaderManager.class);
                binder.bind(AdhocObjectFactory.class).to(DefaultAdhocObjectFactory.class);
                binder.bind(RuntimeProperties.class).to(DefaultRuntimeProperties.class);
            }
        };
        Injector injector = DIBootstrap.createInjector((Module[])new Module[]{testModule});
        DefaultDbAdapterFactory factory = new DefaultDbAdapterFactory(detectors);
        injector.injectMembers((Object)factory);
        DbAdapter createdAdapter = factory.createAdapter(new DataNodeDescriptor(), (DataSource)dataSource);
        Assert.assertTrue((boolean)(createdAdapter instanceof AutoAdapter));
        Assert.assertEquals((Object)"XXXXX", (Object)createdAdapter.createTable(new DbEntity("Test")));
    }

    @Test
    public void testCreatedAdapter_Generic() throws Exception {
        ArrayList<DbAdapterDetector> detectors = new ArrayList<DbAdapterDetector>();
        Module testModule = new Module(){

            public void configure(Binder binder) {
                ServerModule.contributeProperties(binder);
                ServerModule.contributeDefaultTypes(binder);
                ServerModule.contributeUserTypes(binder);
                ServerModule.contributeTypeFactories(binder);
                binder.bind(JdbcEventLogger.class).to(Slf4jJdbcEventLogger.class);
                binder.bind(ClassLoaderManager.class).to(DefaultClassLoaderManager.class);
                binder.bind(AdhocObjectFactory.class).to(DefaultAdhocObjectFactory.class);
                binder.bind(ResourceLocator.class).to(ClassLoaderResourceLocator.class);
                binder.bind(Key.get(ResourceLocator.class, (String)"cayenne.server.resource_locator")).to(ClassLoaderResourceLocator.class);
                binder.bind(RuntimeProperties.class).to(DefaultRuntimeProperties.class);
                binder.bind(BatchTranslatorFactory.class).toInstance(Mockito.mock(BatchTranslatorFactory.class));
                ServerModule.contributeValueObjectTypes(binder);
                binder.bind(ValueObjectTypeRegistry.class).to(DefaultValueObjectTypeRegistry.class);
            }
        };
        Injector injector = DIBootstrap.createInjector((Module[])new Module[]{testModule});
        DefaultDbAdapterFactory factory = new DefaultDbAdapterFactory(detectors);
        injector.injectMembers((Object)factory);
        DbAdapter createdAdapter = factory.createAdapter(new DataNodeDescriptor(), (DataSource)new MockDataSource());
        Assert.assertNotNull((Object)createdAdapter);
        Assert.assertTrue((String)("Unexpected class: " + createdAdapter.getClass().getName()), (boolean)(createdAdapter instanceof AutoAdapter));
        Assert.assertEquals((Object)"CREATE TABLE Test ()", (Object)createdAdapter.createTable(new DbEntity("Test")));
    }

    @Test
    public void testCreatedAdapter_Custom() throws Exception {
        DataNodeDescriptor nodeDescriptor = new DataNodeDescriptor();
        nodeDescriptor.setAdapterType(SybaseAdapter.class.getName());
        ArrayList<DbAdapterDetector> detectors = new ArrayList<DbAdapterDetector>();
        Module testModule = new Module(){

            public void configure(Binder binder) {
                ServerModule.contributeProperties(binder);
                ServerModule.contributeDefaultTypes(binder);
                ServerModule.contributeUserTypes(binder);
                ServerModule.contributeTypeFactories(binder);
                binder.bind(JdbcEventLogger.class).to(Slf4jJdbcEventLogger.class);
                binder.bind(ClassLoaderManager.class).to(DefaultClassLoaderManager.class);
                binder.bind(AdhocObjectFactory.class).to(DefaultAdhocObjectFactory.class);
                binder.bind(ResourceLocator.class).to(ClassLoaderResourceLocator.class);
                binder.bind(Key.get(ResourceLocator.class, (String)"cayenne.server.resource_locator")).to(ClassLoaderResourceLocator.class);
                binder.bind(RuntimeProperties.class).to(DefaultRuntimeProperties.class);
                binder.bind(BatchTranslatorFactory.class).toInstance(Mockito.mock(BatchTranslatorFactory.class));
                ServerModule.contributeValueObjectTypes(binder);
                binder.bind(ValueObjectTypeRegistry.class).to(DefaultValueObjectTypeRegistry.class);
            }
        };
        Injector injector = DIBootstrap.createInjector((Module[])new Module[]{testModule});
        DefaultDbAdapterFactory factory = new DefaultDbAdapterFactory(detectors);
        injector.injectMembers((Object)factory);
        DbAdapter createdAdapter = factory.createAdapter(nodeDescriptor, (DataSource)new MockDataSource());
        Assert.assertNotNull((Object)createdAdapter);
        Assert.assertTrue((String)("Unexpected class: " + createdAdapter.getClass().getName()), (boolean)(createdAdapter instanceof SybaseAdapter));
    }

    @Test
    public void testCreatedAdapter_AutoExplicit() throws Exception {
        final DbAdapter adapter = (DbAdapter)Mockito.mock(DbAdapter.class);
        Mockito.when((Object)adapter.createTable((DbEntity)Matchers.any(DbEntity.class))).thenReturn((Object)"XXXXX");
        ArrayList<DbAdapterDetector> detectors = new ArrayList<DbAdapterDetector>();
        detectors.add(new DbAdapterDetector(){

            @Override
            public DbAdapter createAdapter(DatabaseMetaData md) throws SQLException {
                return adapter;
            }
        });
        MockConnection connection = new MockConnection();
        MockDataSource dataSource = new MockDataSource();
        dataSource.setupConnection((Connection)connection);
        Module testModule = new Module(){

            public void configure(Binder binder) {
                ServerModule.contributeProperties(binder);
                binder.bind(ClassLoaderManager.class).to(DefaultClassLoaderManager.class);
                binder.bind(JdbcEventLogger.class).to(Slf4jJdbcEventLogger.class);
                binder.bind(AdhocObjectFactory.class).to(DefaultAdhocObjectFactory.class);
                binder.bind(RuntimeProperties.class).to(DefaultRuntimeProperties.class);
            }
        };
        Injector injector = DIBootstrap.createInjector((Module[])new Module[]{testModule});
        DefaultDbAdapterFactory factory = new DefaultDbAdapterFactory(detectors);
        injector.injectMembers((Object)factory);
        DataNodeDescriptor nodeDescriptor = new DataNodeDescriptor();
        nodeDescriptor.setAdapterType(AutoAdapter.class.getName());
        DbAdapter createdAdapter = factory.createAdapter(nodeDescriptor, (DataSource)dataSource);
        Assert.assertTrue((boolean)(createdAdapter instanceof AutoAdapter));
        Assert.assertEquals((Object)"XXXXX", (Object)createdAdapter.createTable(new DbEntity("Test")));
    }
}

