/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Property;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.compound.CharPkTestEntity;
import org.apache.cayenne.testdo.compound.CompoundPkTestEntity;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-compound.xml")
public class CayenneCompoundIT
extends ServerCase {
    @Inject
    private ObjectContext context;
    @Inject
    protected DBHelper dbHelper;
    protected TableHelper tCompoundPKTest;
    protected TableHelper tCharPKTest;
    protected TableHelper tCompoundIntPKTest;

    @Before
    public void setUp() throws Exception {
        this.tCompoundPKTest = new TableHelper(this.dbHelper, "COMPOUND_PK_TEST");
        this.tCompoundPKTest.setColumns(new String[]{"KEY1", "KEY2", "NAME"});
        this.tCharPKTest = new TableHelper(this.dbHelper, "CHAR_PK_TEST");
        this.tCharPKTest.setColumns(new String[]{"PK_COL", "OTHER_COL"});
        this.tCompoundIntPKTest = new TableHelper(this.dbHelper, "COMPOUND_INT_PK");
        this.tCompoundIntPKTest.setColumns(new String[]{"id1", "id2", "name"});
    }

    private void createOneCompoundPK() throws Exception {
        this.tCompoundPKTest.insert(new Object[]{"PK1", "PK2", "BBB"});
    }

    private void createCompoundPKs(int size) throws Exception {
        for (int i = 0; i < size; ++i) {
            this.tCompoundPKTest.insert(new Object[]{"PK" + i, "PK" + 2 * i, "BBB" + i});
        }
    }

    private void createOneCharPK() throws Exception {
        this.tCharPKTest.insert(new Object[]{"CPK", "AAAA"});
    }

    @Test
    public void testObjectForPKEntityMapCompound() throws Exception {
        this.createOneCompoundPK();
        HashMap<String, String> pk = new HashMap<String, String>();
        pk.put("KEY1", "PK1");
        pk.put("KEY2", "PK2");
        CompoundPkTestEntity object = Cayenne.objectForPK(this.context, CompoundPkTestEntity.class, pk);
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)(object instanceof CompoundPkTestEntity));
        Assert.assertEquals((Object)"BBB", (Object)object.getName());
    }

    @Test
    public void testCompoundPKForObject() throws Exception {
        this.createOneCompoundPK();
        List objects = this.context.performQuery(new SelectQuery<CompoundPkTestEntity>(CompoundPkTestEntity.class));
        Assert.assertEquals((long)1L, (long)objects.size());
        DataObject object = (DataObject)objects.get(0);
        Map<String, Object> pk = Cayenne.compoundPKForObject(object);
        Assert.assertNotNull(pk);
        Assert.assertEquals((long)2L, (long)pk.size());
        Assert.assertEquals((Object)"PK1", (Object)pk.get("KEY1"));
        Assert.assertEquals((Object)"PK2", (Object)pk.get("KEY2"));
    }

    @Test
    public void testIntPKForObjectFailureForCompound() throws Exception {
        this.createOneCompoundPK();
        List objects = this.context.performQuery(new SelectQuery<CompoundPkTestEntity>(CompoundPkTestEntity.class));
        Assert.assertEquals((long)1L, (long)objects.size());
        DataObject object = (DataObject)objects.get(0);
        try {
            Cayenne.intPKForObject(object);
            Assert.fail((String)"intPKForObject must fail for compound key");
        }
        catch (CayenneRuntimeException cayenneRuntimeException) {
            // empty catch block
        }
    }

    @Test
    public void testIntPKForObjectFailureForNonNumeric() throws Exception {
        this.createOneCharPK();
        List objects = this.context.performQuery(new SelectQuery<CharPkTestEntity>(CharPkTestEntity.class));
        Assert.assertEquals((long)1L, (long)objects.size());
        DataObject object = (DataObject)objects.get(0);
        try {
            Cayenne.intPKForObject(object);
            Assert.fail((String)"intPKForObject must fail for non-numeric key");
        }
        catch (CayenneRuntimeException cayenneRuntimeException) {
            // empty catch block
        }
    }

    @Test
    public void testPKForObjectFailureForCompound() throws Exception {
        this.createOneCompoundPK();
        List objects = this.context.performQuery(new SelectQuery<CompoundPkTestEntity>(CompoundPkTestEntity.class));
        Assert.assertEquals((long)1L, (long)objects.size());
        DataObject object = (DataObject)objects.get(0);
        try {
            Cayenne.pkForObject(object);
            Assert.fail((String)"pkForObject must fail for compound key");
        }
        catch (CayenneRuntimeException cayenneRuntimeException) {
            // empty catch block
        }
    }

    @Test
    public void testIntPKForObjectNonNumeric() throws Exception {
        this.createOneCharPK();
        List objects = this.context.performQuery(new SelectQuery<CharPkTestEntity>(CharPkTestEntity.class));
        Assert.assertEquals((long)1L, (long)objects.size());
        DataObject object = (DataObject)objects.get(0);
        Assert.assertEquals((Object)"CPK", (Object)Cayenne.pkForObject(object));
    }

    @Test
    public void testPaginatedColumnSelect() throws Exception {
        this.createCompoundPKs(20);
        List result = ObjectSelect.query(CompoundPkTestEntity.class).columns(CompoundPkTestEntity.NAME, Property.createSelf(CompoundPkTestEntity.class)).pageSize(7).select(this.context);
        Assert.assertEquals((long)20L, (long)result.size());
        for (Object[] next : result) {
            Assert.assertEquals((long)2L, (long)next.length);
            Assert.assertEquals(String.class, next[0].getClass());
            Assert.assertEquals(CompoundPkTestEntity.class, next[1].getClass());
        }
    }

    @Test
    public void testEjbqlCountSelect() throws Exception {
        this.tCompoundIntPKTest.insert(new Object[]{1, 2, "test"});
        this.tCompoundIntPKTest.insert(new Object[]{2, 3, "test"});
        this.tCompoundIntPKTest.insert(new Object[]{1, 4, "test"});
        this.tCompoundIntPKTest.insert(new Object[]{2, 5, "test"});
        EJBQLQuery query = new EJBQLQuery("SELECT COUNT(a) FROM CompoundIntPk a");
        Assert.assertEquals(Collections.singletonList(4L), (Object)this.context.performQuery(query));
    }
}

