/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import org.apache.cayenne.util.RegexUtil;
import org.junit.Assert;
import org.junit.Test;

public class RegexUtilTest {
    @Test
    public void testSubstBackslashes() {
        Assert.assertTrue((boolean)RegexUtil.BACKSLASH.matcher("\\").find());
        Assert.assertTrue((boolean)RegexUtil.BACKSLASH.matcher("abc\\").find());
        Assert.assertNull((Object)RegexUtil.substBackslashes(null));
        Assert.assertEquals((Object)"abc", (Object)RegexUtil.substBackslashes("abc"));
        Assert.assertEquals((Object)"ab/c", (Object)RegexUtil.substBackslashes("ab/c"));
        Assert.assertEquals((Object)"ab/c", (Object)RegexUtil.substBackslashes("ab\\c"));
        Assert.assertEquals((Object)"ab//c", (Object)RegexUtil.substBackslashes("ab\\\\c"));
        Assert.assertEquals((Object)"ab//c", (Object)RegexUtil.substBackslashes("ab\\/c"));
        Assert.assertEquals((Object)"/ab/c", (Object)RegexUtil.substBackslashes("\\ab\\c"));
    }

    @Test
    public void testGetPackagePath() {
        Assert.assertTrue((boolean)RegexUtil.DOT.matcher(".").find());
        Assert.assertTrue((boolean)RegexUtil.DOT.matcher("abc.aa.aa").find());
        Assert.assertEquals((Object)"", (Object)RegexUtil.getPackagePath(null));
        Assert.assertEquals((Object)"", (Object)RegexUtil.getPackagePath(""));
        Assert.assertEquals((Object)"", (Object)RegexUtil.getPackagePath("b"));
        Assert.assertEquals((Object)"a", (Object)RegexUtil.getPackagePath("a.b"));
        Assert.assertEquals((Object)"a/c", (Object)RegexUtil.getPackagePath("a.c.b"));
    }
}

