/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.datasource;

import java.sql.Driver;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.conn.DataSourceInfo;
import org.apache.cayenne.datasource.DriverDataSource;
import org.apache.cayenne.datasource.PoolingDataSourceParameters;
import org.apache.cayenne.datasource.UnmanagedPoolingDataSource;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class PoolingDataSource_FailingValidationQueryIT
extends ServerCase {
    @Inject
    private DataSourceInfo dataSourceInfo;
    @Inject
    private AdhocObjectFactory objectFactory;

    protected PoolingDataSourceParameters createParameters() {
        PoolingDataSourceParameters poolParameters = new PoolingDataSourceParameters();
        poolParameters.setMinConnections(2);
        poolParameters.setMaxConnections(3);
        poolParameters.setMaxQueueWaitTime(1000L);
        poolParameters.setValidationQuery("SELECT count(1) FROM NO_SUCH_TABLE");
        return poolParameters;
    }

    @Test(expected=CayenneRuntimeException.class)
    public void testConstructor() throws Exception {
        Driver driver = (Driver)this.objectFactory.newInstance(Driver.class, this.dataSourceInfo.getJdbcDriver());
        DriverDataSource nonPooling = new DriverDataSource(driver, this.dataSourceInfo.getDataSourceUrl(), this.dataSourceInfo.getUserName(), this.dataSourceInfo.getPassword());
        PoolingDataSourceParameters poolParameters = this.createParameters();
        UnmanagedPoolingDataSource ds = new UnmanagedPoolingDataSource(nonPooling, poolParameters);
        ds.close();
    }
}

