/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.server;

import java.util.Collection;
import java.util.Collections;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.DataRowStoreFactory;
import org.apache.cayenne.access.DefaultDataRowStoreFactory;
import org.apache.cayenne.access.dbsync.DefaultSchemaUpdateStrategyFactory;
import org.apache.cayenne.access.dbsync.SchemaUpdateStrategyFactory;
import org.apache.cayenne.access.dbsync.SkipSchemaUpdateStrategy;
import org.apache.cayenne.access.dbsync.ThrowOnPartialOrCreateSchemaStrategy;
import org.apache.cayenne.access.jdbc.SQLTemplateProcessor;
import org.apache.cayenne.access.jdbc.reader.RowReaderFactory;
import org.apache.cayenne.access.translator.batch.BatchTranslatorFactory;
import org.apache.cayenne.access.translator.batch.DefaultBatchTranslatorFactory;
import org.apache.cayenne.access.translator.select.DefaultSelectTranslatorFactory;
import org.apache.cayenne.access.translator.select.SelectTranslatorFactory;
import org.apache.cayenne.access.types.DefaultValueObjectTypeRegistry;
import org.apache.cayenne.access.types.ValueObjectTypeRegistry;
import org.apache.cayenne.annotation.PostLoad;
import org.apache.cayenne.ashwood.AshwoodEntitySorter;
import org.apache.cayenne.cache.QueryCache;
import org.apache.cayenne.configuration.ConfigurationNameMapper;
import org.apache.cayenne.configuration.ConfigurationTree;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataChannelDescriptorLoader;
import org.apache.cayenne.configuration.DataChannelDescriptorMerger;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.DefaultConfigurationNameMapper;
import org.apache.cayenne.configuration.DefaultDataChannelDescriptorMerger;
import org.apache.cayenne.configuration.DefaultRuntimeProperties;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.configuration.mock.MockDataSourceFactory;
import org.apache.cayenne.configuration.server.DataDomainProvider;
import org.apache.cayenne.configuration.server.DataNodeFactory;
import org.apache.cayenne.configuration.server.DataSourceFactory;
import org.apache.cayenne.configuration.server.DbAdapterFactory;
import org.apache.cayenne.configuration.server.DefaultDataNodeFactory;
import org.apache.cayenne.configuration.server.DefaultDbAdapterFactory;
import org.apache.cayenne.configuration.server.ServerModule;
import org.apache.cayenne.dba.db2.DB2Sniffer;
import org.apache.cayenne.dba.derby.DerbySniffer;
import org.apache.cayenne.dba.firebird.FirebirdSniffer;
import org.apache.cayenne.dba.frontbase.FrontBaseSniffer;
import org.apache.cayenne.dba.h2.H2Sniffer;
import org.apache.cayenne.dba.hsqldb.HSQLDBSniffer;
import org.apache.cayenne.dba.ingres.IngresSniffer;
import org.apache.cayenne.dba.mysql.MySQLSniffer;
import org.apache.cayenne.dba.openbase.OpenBaseSniffer;
import org.apache.cayenne.dba.oracle.OracleAdapter;
import org.apache.cayenne.dba.oracle.OracleSniffer;
import org.apache.cayenne.dba.postgres.PostgresSniffer;
import org.apache.cayenne.dba.sqlite.SQLiteSniffer;
import org.apache.cayenne.dba.sqlserver.SQLServerSniffer;
import org.apache.cayenne.dba.sybase.SybaseSniffer;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.Binder;
import org.apache.cayenne.di.ClassLoaderManager;
import org.apache.cayenne.di.DIBootstrap;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.di.Key;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.di.spi.DefaultAdhocObjectFactory;
import org.apache.cayenne.di.spi.DefaultClassLoaderManager;
import org.apache.cayenne.event.EventBridge;
import org.apache.cayenne.event.EventManager;
import org.apache.cayenne.event.MockEventManager;
import org.apache.cayenne.event.NoopEventBridgeProvider;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.log.Slf4jJdbcEventLogger;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.EntitySorter;
import org.apache.cayenne.map.LifecycleEvent;
import org.apache.cayenne.resource.ClassLoaderResourceLocator;
import org.apache.cayenne.resource.Resource;
import org.apache.cayenne.resource.ResourceLocator;
import org.apache.cayenne.resource.mock.MockResource;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class DataDomainProviderTest {
    @Test
    public void testGet() {
        String testConfigName = "testConfig";
        final DataChannelDescriptor testDescriptor = new DataChannelDescriptor();
        DataMap map1 = new DataMap("map1");
        testDescriptor.getDataMaps().add(map1);
        DataMap map2 = new DataMap("map2");
        testDescriptor.getDataMaps().add(map2);
        DataNodeDescriptor nodeDescriptor1 = new DataNodeDescriptor();
        nodeDescriptor1.setName("node1");
        nodeDescriptor1.getDataMapNames().add("map1");
        nodeDescriptor1.setAdapterType(OracleAdapter.class.getName());
        nodeDescriptor1.setDataSourceFactoryType(MockDataSourceFactory.class.getName());
        nodeDescriptor1.setParameters("jdbc/testDataNode1");
        nodeDescriptor1.setSchemaUpdateStrategyType(ThrowOnPartialOrCreateSchemaStrategy.class.getName());
        testDescriptor.getNodeDescriptors().add(nodeDescriptor1);
        DataNodeDescriptor nodeDescriptor2 = new DataNodeDescriptor();
        nodeDescriptor2.setName("node2");
        nodeDescriptor2.getDataMapNames().add("map2");
        nodeDescriptor2.setParameters("testDataNode2.driver.xml");
        testDescriptor.getNodeDescriptors().add(nodeDescriptor2);
        final DataChannelDescriptorLoader testLoader = new DataChannelDescriptorLoader(){

            @Override
            public ConfigurationTree<DataChannelDescriptor> load(Resource configurationResource) throws ConfigurationException {
                return new ConfigurationTree<DataChannelDescriptor>(testDescriptor, null);
            }
        };
        final MockEventManager eventManager = new MockEventManager();
        final TestListener mockListener = (TestListener)Mockito.mock(TestListener.class);
        Module testModule = new Module(){

            public void configure(Binder binder) {
                DefaultClassLoaderManager classLoaderManager = new DefaultClassLoaderManager();
                binder.bind(ClassLoaderManager.class).toInstance((Object)classLoaderManager);
                binder.bind(AdhocObjectFactory.class).to(DefaultAdhocObjectFactory.class);
                ServerModule.contributeProperties(binder);
                ServerModule.contributeAdapterDetectors(binder).add(FirebirdSniffer.class).add(OpenBaseSniffer.class).add(FrontBaseSniffer.class).add(IngresSniffer.class).add(SQLiteSniffer.class).add(DB2Sniffer.class).add(H2Sniffer.class).add(HSQLDBSniffer.class).add(SybaseSniffer.class).add(DerbySniffer.class).add(SQLServerSniffer.class).add(OracleSniffer.class).add(PostgresSniffer.class).add(MySQLSniffer.class);
                ServerModule.contributeDomainFilters(binder);
                ServerModule.contributeDomainListeners(binder).add((Object)mockListener);
                ServerModule.contributeProjectLocations(binder).add((Object)"testConfig");
                ServerModule.contributeDefaultTypes(binder);
                ServerModule.contributeUserTypes(binder);
                ServerModule.contributeTypeFactories(binder);
                binder.bind(EventManager.class).toInstance((Object)eventManager);
                binder.bind(EntitySorter.class).toInstance((Object)new AshwoodEntitySorter());
                binder.bind(SchemaUpdateStrategyFactory.class).to(DefaultSchemaUpdateStrategyFactory.class);
                ClassLoaderResourceLocator locator = new ClassLoaderResourceLocator((ClassLoaderManager)classLoaderManager){

                    @Override
                    public Collection<Resource> findResources(String name) {
                        if (name.endsWith("types.xml")) {
                            return super.findResources(name);
                        }
                        Assert.assertEquals((Object)"testConfig", (Object)name);
                        return Collections.singleton(new MockResource());
                    }
                };
                binder.bind(ResourceLocator.class).toInstance((Object)locator);
                binder.bind(Key.get(ResourceLocator.class, (String)"cayenne.server.resource_locator")).toInstance((Object)locator);
                binder.bind(ConfigurationNameMapper.class).to(DefaultConfigurationNameMapper.class);
                binder.bind(DataChannelDescriptorMerger.class).to(DefaultDataChannelDescriptorMerger.class);
                binder.bind(DataChannelDescriptorLoader.class).toInstance((Object)testLoader);
                binder.bind(DbAdapterFactory.class).to(DefaultDbAdapterFactory.class);
                binder.bind(RuntimeProperties.class).to(DefaultRuntimeProperties.class);
                binder.bind(BatchTranslatorFactory.class).to(DefaultBatchTranslatorFactory.class);
                binder.bind(SelectTranslatorFactory.class).to(DefaultSelectTranslatorFactory.class);
                binder.bind(DataSourceFactory.class).toInstance((Object)new MockDataSourceFactory());
                binder.bind(JdbcEventLogger.class).to(Slf4jJdbcEventLogger.class);
                binder.bind(QueryCache.class).toInstance(Mockito.mock(QueryCache.class));
                binder.bind(RowReaderFactory.class).toInstance(Mockito.mock(RowReaderFactory.class));
                binder.bind(DataNodeFactory.class).to(DefaultDataNodeFactory.class);
                binder.bind(SQLTemplateProcessor.class).toInstance(Mockito.mock(SQLTemplateProcessor.class));
                binder.bind(EventBridge.class).toProvider(NoopEventBridgeProvider.class);
                binder.bind(DataRowStoreFactory.class).to(DefaultDataRowStoreFactory.class);
                ServerModule.contributeValueObjectTypes(binder);
                binder.bind(ValueObjectTypeRegistry.class).to(DefaultValueObjectTypeRegistry.class);
            }
        };
        Injector injector = DIBootstrap.createInjector((Module[])new Module[]{testModule});
        DataDomainProvider provider = new DataDomainProvider();
        injector.injectMembers((Object)provider);
        DataDomain channel = provider.get();
        Assert.assertNotNull((Object)channel);
        Assert.assertTrue((boolean)(channel instanceof DataDomain));
        DataDomain domain = channel;
        Assert.assertSame((Object)eventManager, (Object)domain.getEventManager());
        Assert.assertEquals((long)2L, (long)domain.getDataMaps().size());
        Assert.assertTrue((boolean)domain.getDataMaps().contains(map1));
        Assert.assertTrue((boolean)domain.getDataMaps().contains(map2));
        Assert.assertEquals((long)2L, (long)domain.getDataNodes().size());
        DataNode node1 = domain.getDataNode("node1");
        Assert.assertNotNull((Object)node1);
        Assert.assertEquals((long)1L, (long)node1.getDataMaps().size());
        Assert.assertSame((Object)map1, (Object)node1.getDataMaps().iterator().next());
        Assert.assertSame((Object)node1, (Object)domain.lookupDataNode(map1));
        Assert.assertEquals((Object)nodeDescriptor1.getDataSourceFactoryType(), (Object)node1.getDataSourceFactory());
        Assert.assertNotNull((Object)node1.getDataSource());
        Assert.assertEquals((Object)nodeDescriptor1.getParameters(), (Object)node1.getDataSourceLocation());
        Assert.assertNotNull((Object)node1.getSchemaUpdateStrategy());
        Assert.assertEquals((Object)nodeDescriptor1.getSchemaUpdateStrategyType(), (Object)node1.getSchemaUpdateStrategy().getClass().getName());
        Assert.assertNotNull((Object)node1.getAdapter());
        Assert.assertEquals(OracleAdapter.class, node1.getAdapter().getClass());
        DataNode node2 = domain.getDataNode("node2");
        Assert.assertNotNull((Object)node2);
        Assert.assertEquals((long)1L, (long)node2.getDataMaps().size());
        Assert.assertSame((Object)map2, (Object)node2.getDataMaps().iterator().next());
        Assert.assertSame((Object)node2, (Object)domain.lookupDataNode(map2));
        Assert.assertNull((Object)node2.getDataSourceFactory());
        Assert.assertNotNull((Object)node2.getDataSource());
        Assert.assertEquals((Object)nodeDescriptor2.getParameters(), (Object)node2.getDataSourceLocation());
        Assert.assertNotNull((Object)node2.getSchemaUpdateStrategy());
        Assert.assertEquals((Object)SkipSchemaUpdateStrategy.class.getName(), (Object)node2.getSchemaUpdateStrategy().getClass().getName());
        Assert.assertNotNull((Object)node2.getAdapter());
        Persistent mockPersistent = (Persistent)Mockito.mock(Persistent.class);
        ObjectId mockObjectId = (ObjectId)Mockito.mock(ObjectId.class);
        Mockito.when((Object)mockObjectId.getEntityName()).thenReturn((Object)"mock-entity-name");
        Mockito.when((Object)mockPersistent.getObjectId()).thenReturn((Object)mockObjectId);
        domain.getEntityResolver().getCallbackRegistry().performCallbacks(LifecycleEvent.POST_LOAD, mockPersistent);
        ((TestListener)Mockito.verify((Object)mockListener)).postLoadCallback(mockPersistent);
    }

    static class TestListener {
        TestListener() {
        }

        @PostLoad
        public void postLoadCallback(Object object) {
        }
    }
}

