/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.math.BigDecimal;
import java.sql.Time;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.MappedSelect;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.testdo.return_types.ReturnTypesMap1;
import org.apache.cayenne.testdo.return_types.ReturnTypesMap2;
import org.apache.cayenne.testdo.return_types.ReturnTypesMapLobs1;
import org.apache.cayenne.unit.PostgresUnitDbAdapter;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

@UseServerRuntime(value="cayenne-return-types.xml")
public class ReturnTypesMappingIT
extends ServerCase {
    @Inject
    private DataContext context;
    @Inject
    private UnitDbAdapter unitDbAdapter;

    @Test
    public void testBIGINT() throws Exception {
        String columnName = "BIGINT_COLUMN";
        ReturnTypesMap1 test = this.context.newObject(ReturnTypesMap1.class);
        Long bigintValue = 5326457654783454355L;
        test.setBigintColumn(bigintValue);
        this.context.commitChanges();
        DataRow testRead = (DataRow)this.context.performQuery(MappedSelect.query("SelectReturnTypesMap1")).get(0);
        Object columnValue = testRead.get(columnName);
        Assert.assertNotNull(columnValue);
        if (this.unitDbAdapter.onlyGenericNumberType()) {
            Assert.assertEquals(BigDecimal.class, columnValue.getClass());
            Assert.assertEquals((Object)BigDecimal.valueOf(bigintValue), columnValue);
        } else {
            Assert.assertEquals(Long.class, columnValue.getClass());
            Assert.assertEquals((Object)bigintValue, columnValue);
        }
    }

    @Test
    public void testBIGINT2() throws Exception {
        ReturnTypesMap1 test = this.context.newObject(ReturnTypesMap1.class);
        Long bigintValue = 5326457654783454355L;
        test.setBigintColumn(bigintValue);
        this.context.commitChanges();
        SelectQuery<ReturnTypesMap1> q = new SelectQuery<ReturnTypesMap1>(ReturnTypesMap1.class);
        ReturnTypesMap1 testRead = (ReturnTypesMap1)this.context.performQuery(q).get(0);
        Long columnValue = testRead.getBigintColumn();
        Assert.assertNotNull((Object)columnValue);
        Assert.assertEquals(Long.class, columnValue.getClass());
        Assert.assertEquals((Object)bigintValue, (Object)columnValue);
    }

    @Test
    public void testBINARY() throws Exception {
        if (this.unitDbAdapter.supportsLobs()) {
            String columnName = "BINARY_COLUMN";
            ReturnTypesMap2 test = this.context.newObject(ReturnTypesMap2.class);
            byte[] binaryValue = new byte[]{3, 4, 5, -6, 7, 0, 2, 9, 45, 64, 3, 127, -128, -60};
            test.setBinaryColumn(binaryValue);
            this.context.commitChanges();
            DataRow testRead = (DataRow)this.context.performQuery(MappedSelect.query("SelectReturnTypesMap2")).get(0);
            Object columnValue = testRead.get(columnName);
            Assert.assertNotNull(columnValue);
            Assert.assertEquals(byte[].class, columnValue.getClass());
            Assert.assertTrue((boolean)Arrays.equals(binaryValue, (byte[])columnValue));
        }
    }

    @Test
    public void testBINARY2() throws Exception {
        if (this.unitDbAdapter.supportsLobs()) {
            ReturnTypesMap2 test = this.context.newObject(ReturnTypesMap2.class);
            byte[] binaryValue = new byte[]{3, 4, 5, -6, 7, 0, 2, 9, 45, 64, 3, 127, -128, -60};
            test.setBinaryColumn(binaryValue);
            this.context.commitChanges();
            SelectQuery<ReturnTypesMap2> q = new SelectQuery<ReturnTypesMap2>(ReturnTypesMap2.class);
            ReturnTypesMap2 testRead = (ReturnTypesMap2)this.context.performQuery(q).get(0);
            byte[] columnValue = testRead.getBinaryColumn();
            Assert.assertNotNull((Object)columnValue);
            Assert.assertEquals(byte[].class, columnValue.getClass());
            Assert.assertTrue((boolean)Arrays.equals(binaryValue, columnValue));
        }
    }

    @Test
    public void testBIT() throws Exception {
        String columnName = "BIT_COLUMN";
        ReturnTypesMap1 test = this.context.newObject(ReturnTypesMap1.class);
        Boolean bitValue = true;
        test.setBitColumn(bitValue);
        this.context.commitChanges();
        DataRow testRead = (DataRow)this.context.performQuery(MappedSelect.query("SelectReturnTypesMap1")).get(0);
        Object columnValue = testRead.get(columnName);
        Assert.assertNotNull(columnValue);
        Assert.assertTrue((Boolean.class.equals(columnValue.getClass()) || Short.class.equals(columnValue.getClass()) || Integer.class.equals(columnValue.getClass()) ? 1 : 0) != 0);
        Assert.assertTrue((bitValue.equals(columnValue) || ((Number)columnValue).intValue() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testBIT2() throws Exception {
        ReturnTypesMap1 test = this.context.newObject(ReturnTypesMap1.class);
        Boolean bitValue = true;
        test.setBitColumn(bitValue);
        this.context.commitChanges();
        SelectQuery<ReturnTypesMap1> q = new SelectQuery<ReturnTypesMap1>(ReturnTypesMap1.class);
        ReturnTypesMap1 testRead = (ReturnTypesMap1)this.context.performQuery(q).get(0);
        Boolean columnValue = testRead.getBitColumn();
        Assert.assertNotNull((Object)columnValue);
        Assert.assertEquals(Boolean.class, columnValue.getClass());
        Assert.assertEquals((Object)bitValue, (Object)columnValue);
    }

    @Test
    public void testBLOB() throws Exception {
        Assume.assumeTrue((String)"In postresql blob_column has OID type, but in JAVA it converts into long not into byte.", (!(this.unitDbAdapter instanceof PostgresUnitDbAdapter) ? 1 : 0) != 0);
        if (this.unitDbAdapter.supportsLobs()) {
            String columnName = "BLOB_COLUMN";
            ReturnTypesMap2 test = this.context.newObject(ReturnTypesMap2.class);
            byte[] blobValue = new byte[]{3, 4, 5, -6, 7, 0, 2, 9, 45, 64, 3, 127, -128, -60};
            test.setBlobColumn(blobValue);
            this.context.commitChanges();
            DataRow testRead = (DataRow)this.context.performQuery(MappedSelect.query("SelectReturnTypesMap2")).get(0);
            Object columnValue = testRead.get(columnName);
            Assert.assertNotNull(columnValue);
            Assert.assertEquals(byte[].class, columnValue.getClass());
            Assert.assertTrue((boolean)Arrays.equals(blobValue, (byte[])columnValue));
        }
    }

    @Test
    public void testBLOB2() throws Exception {
        if (this.unitDbAdapter.supportsLobs()) {
            ReturnTypesMap2 test = this.context.newObject(ReturnTypesMap2.class);
            byte[] blobValue = new byte[]{3, 4, 5, -6, 7, 0, 2, 9, 45, 64, 3, 127, -128, -60};
            test.setBlobColumn(blobValue);
            this.context.commitChanges();
            SelectQuery<ReturnTypesMap2> q = new SelectQuery<ReturnTypesMap2>(ReturnTypesMap2.class);
            ReturnTypesMap2 testRead = (ReturnTypesMap2)this.context.performQuery(q).get(0);
            byte[] columnValue = testRead.getBlobColumn();
            Assert.assertNotNull((Object)columnValue);
            Assert.assertEquals(byte[].class, columnValue.getClass());
            Assert.assertTrue((boolean)Arrays.equals(blobValue, columnValue));
        }
    }

    @Test
    public void testBOOLEAN() throws Exception {
        String columnName = "BOOLEAN_COLUMN";
        ReturnTypesMap1 test = this.context.newObject(ReturnTypesMap1.class);
        Boolean booleanValue = true;
        test.setBooleanColumn(booleanValue);
        this.context.commitChanges();
        DataRow testRead = (DataRow)this.context.performQuery(MappedSelect.query("SelectReturnTypesMap1")).get(0);
        Object columnValue = testRead.get(columnName);
        Assert.assertNotNull(columnValue);
        Assert.assertTrue((Boolean.class.equals(columnValue.getClass()) || Short.class.equals(columnValue.getClass()) || Integer.class.equals(columnValue.getClass()) ? 1 : 0) != 0);
        Assert.assertTrue((booleanValue.equals(columnValue) || ((Number)columnValue).intValue() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testBOOLEAN2() throws Exception {
        ReturnTypesMap1 test = this.context.newObject(ReturnTypesMap1.class);
        Boolean booleanValue = true;
        test.setBooleanColumn(booleanValue);
        this.context.commitChanges();
        SelectQuery<ReturnTypesMap1> q = new SelectQuery<ReturnTypesMap1>(ReturnTypesMap1.class);
        ReturnTypesMap1 testRead = (ReturnTypesMap1)this.context.performQuery(q).get(0);
        Boolean columnValue = testRead.getBooleanColumn();
        Assert.assertNotNull((Object)columnValue);
        Assert.assertEquals(Boolean.class, columnValue.getClass());
        Assert.assertEquals((Object)booleanValue, (Object)columnValue);
    }

    @Test
    public void testCHAR() throws Exception {
        String columnName = "CHAR_COLUMN";
        ReturnTypesMap1 test = this.context.newObject(ReturnTypesMap1.class);
        String charValue = "Char string for tests!";
        test.setCharColumn(charValue);
        this.context.commitChanges();
        DataRow testRead = (DataRow)this.context.performQuery(MappedSelect.query("SelectReturnTypesMap1")).get(0);
        Object columnValue = testRead.get(columnName);
        Assert.assertNotNull(columnValue);
        Assert.assertEquals(String.class, columnValue.getClass());
        Assert.assertEquals((Object)charValue, columnValue);
    }

    @Test
    public void testNCHAR() throws Exception {
        String columnName = "NCHAR_COLUMN";
        ReturnTypesMap1 test = this.context.newObject(ReturnTypesMap1.class);
        String charValue = "\u062f\u0631\u062e\u062a\u200c\u0647\u0627\u06cc \u062c\u0633\u062a\u062c\u0648\u06cc \u0645\u062a\u0648\u0627\u0632\u0646\u060c \u0646\u06cc\u0627\u0632\u06cc \u0646\u062f\u0627\u0631\u062f \u06a9\u0647 \u0628\u0647 \u0635\u0648\u0631\u062a!";
        test.setNcharColumn(charValue);
        this.context.commitChanges();
        DataRow testRead = (DataRow)this.context.performQuery(MappedSelect.query("SelectReturnTypesMap1")).get(0);
        Object columnValue = testRead.get(columnName);
        Assert.assertNotNull(columnValue);
        Assert.assertEquals(String.class, columnValue.getClass());
        Assert.assertEquals((Object)charValue, columnValue);
    }

    @Test
    public void testCHAR2() throws Exception {
        ReturnTypesMap1 test = this.context.newObject(ReturnTypesMap1.class);
        String charValue = "Char string for tests!";
        test.setCharColumn(charValue);
        this.context.commitChanges();
        SelectQuery<ReturnTypesMap1> q = new SelectQuery<ReturnTypesMap1>(ReturnTypesMap1.class);
        ReturnTypesMap1 testRead = (ReturnTypesMap1)this.context.performQuery(q).get(0);
        String columnValue = testRead.getCharColumn();
        Assert.assertNotNull((Object)columnValue);
        Assert.assertEquals(String.class, columnValue.getClass());
        Assert.assertEquals((Object)charValue, (Object)columnValue);
    }

    @Test
    public void testCLOB() throws Exception {
        if (this.unitDbAdapter.supportsLobs()) {
            String columnName = "CLOB_COLUMN";
            ReturnTypesMapLobs1 test = this.context.newObject(ReturnTypesMapLobs1.class);
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < 10000; ++i) {
                buffer.append("CLOB very large string for tests!!!!\n");
            }
            String clobValue = buffer.toString();
            test.setClobColumn(clobValue);
            this.context.commitChanges();
            DataRow testRead = (DataRow)this.context.performQuery(MappedSelect.query("SelectReturnTypesLobsMap1")).get(0);
            Object columnValue = testRead.get(columnName);
            if (columnValue == null && testRead.containsKey(columnName.toLowerCase())) {
                columnValue = testRead.get(columnName.toLowerCase());
            }
            Assert.assertNotNull(columnValue);
            Assert.assertEquals(String.class, columnValue.getClass());
            Assert.assertEquals((Object)clobValue, columnValue);
        }
    }

    @Test
    public void testNCLOB() throws Exception {
        if (this.unitDbAdapter.supportsLobs()) {
            String columnName = "NCLOB_COLUMN";
            ReturnTypesMapLobs1 test = this.context.newObject(ReturnTypesMapLobs1.class);
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < 1000; ++i) {
                buffer.append("\u0631\u0648\u062f\u0627\u0644\u0641 \u0628\u06cc\u0631 \u0648 \u062f\u062f \u0645\u06a9\u200c\u06a9\u0631\u0650\u06cc\u062a \u062f\u0631\u062e\u062a \u0628\u06cc \u0631\u0627 \u0632\u0645\u0627\u0646\u06cc \u06a9\u0647 \u062f\u0631 \u0634\u0631\u06a9\u062a \u0628\u0648\u0626\u06cc\u0646\u06af [\u06f1]\u060c \u0645\u0634\u063a\u0648\u0644 \u0628\u0647 \u06a9\u0627\u0631 \u0628\u0648\u062f\u0646\u062f \u0627\u0628\u062f\u0627\u0639 \u0646\u0645\u0648\u062f\u0646\u062f\u060c \u0627\u0645\u0627 \u062d\u0631\u0641 B \u0648\u0627\u0642\u0639\u0627\u064b\" \u0627\u0632 \u06a9\u062c\u0627 \u0622\u0645\u062f\u0647\u061f \u062f\u0627\u06af\u0644\u0627\u0633 \u06a9\u0627\u0645\u0631 \u06cc\u06a9 \u0633\u0631\u06cc \u0627\u0632 \u0627\u062d\u062a\u0645\u0627\u0644\u0627\u062a \u0631\u0627 \u067e\u06cc\u0634\u0646\u0647\u0627\u062f \u06a9\u0631\u062f:\n\"Balanced,\" \"Broad,\" \u06cc\u0627 \"Bushy\" \u0645\u0645\u06a9\u0646 \u0627\u0633\u062a \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0634\u062f\u0647\u200c\u0628\u0627\u0634\u0646\u062f [\u0686\u0648\u0646 \u0647\u0645\u0647\u0654 \u0628\u0631\u06af\u200c\u0647\u0627 \u062f\u0631 \u06cc\u06a9 \u0633\u0637\u062d \u0642\u0631\u0627\u0631 \u062f\u0627\u0631\u0646\u062f]. \u062f\u06cc\u06af\u0631\u0627\u0646 \u0627\u0638\u0647\u0627\u0631 \u062f\u0627\u0634\u062a\u0646\u062f \u06a9\u0647 \u062d\u0631\u0641 \"B\" \u0627\u0632 \u06a9\u0644\u0645\u0647\u0654 \u0628\u0648\u0626\u06cc\u0646\u06af \u06af\u0631\u0641\u062a\u0647 \u0634\u062f\u0647 \u0627\u0633\u062a [\u0628\u0647 \u0627\u06cc\u0646 \u062f\u0644\u06cc\u0644 \u06a9\u0647 \u067e\u062f\u06cc\u062f\u0622\u0648\u0631\u062f\u0646\u062f\u0647 \u062f\u0631\u0633\u0627\u0644 1972 \u062f\u0631 \u0622\u0632\u0645\u0627\u06cc\u0634\u06af\u0627\u0647\u200c\u0647\u0627\u06cc \u062a\u062d\u0642\u06cc\u0642\u0627\u062a\u06cc \u0639\u0644\u0645\u06cc \u0634\u0631\u06a9\u062a \u0628\u0648\u0626\u06cc\u0646\u06af \u06a9\u0627\u0631 \u0645\u06cc\u200c\u06a9\u0631\u062f]. \u0628\u0627 \u0627\u06cc\u0646 \u0648\u062c\u0648\u062f \u067e\u0646\u062f\u0627\u0634\u062a\u0646 \u062f\u0631\u062e\u062a \u0628\u06cc \u0628\u0647 \u0639\u0646\u0648\u0627\u0646 \u062f\u0631\u062e\u062a \"\u0628\u0650\u06cc\u0650\u0631\" \u0646\u06cc\u0632 \u062f\u0631\u062e\u0648\u0631 \u0627\u0633\u062a.[\u06f2]");
            }
            String clobValue = buffer.toString();
            test.setNclobColumn(clobValue);
            this.context.commitChanges();
            DataRow testRead = (DataRow)this.context.performQuery(MappedSelect.query("SelectReturnTypesLobsMap1")).get(0);
            Object columnValue = testRead.get(columnName);
            if (columnValue == null && testRead.containsKey(columnName.toLowerCase())) {
                columnValue = testRead.get(columnName.toLowerCase());
            }
            Assert.assertNotNull(columnValue);
            Assert.assertEquals(String.class, columnValue.getClass());
            Assert.assertEquals((Object)clobValue, columnValue);
        }
    }

    @Test
    public void testCLOB2() throws Exception {
        if (this.unitDbAdapter.supportsLobs()) {
            ReturnTypesMapLobs1 test = this.context.newObject(ReturnTypesMapLobs1.class);
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < 10000; ++i) {
                buffer.append("CLOB very large string for tests!!!!\n");
            }
            String clobValue = buffer.toString();
            test.setClobColumn(clobValue);
            this.context.commitChanges();
            SelectQuery<ReturnTypesMapLobs1> q = new SelectQuery<ReturnTypesMapLobs1>(ReturnTypesMapLobs1.class);
            ReturnTypesMapLobs1 testRead = (ReturnTypesMapLobs1)this.context.performQuery(q).get(0);
            String columnValue = testRead.getClobColumn();
            Assert.assertNotNull((Object)columnValue);
            Assert.assertEquals(String.class, columnValue.getClass());
            Assert.assertEquals((Object)clobValue, (Object)columnValue);
        }
    }

    @Test
    public void testDATE() throws Exception {
        String columnName = "DATE_COLUMN";
        ReturnTypesMap1 test = this.context.newObject(ReturnTypesMap1.class);
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(2002, 1, 1);
        Date dateValue = cal.getTime();
        test.setDateColumn(dateValue);
        this.context.commitChanges();
        DataRow testRead = (DataRow)this.context.performQuery(MappedSelect.query("SelectReturnTypesMap1")).get(0);
        Object columnValue = testRead.get(columnName);
        Assert.assertNotNull(columnValue);
        Assert.assertEquals(Date.class, columnValue.getClass());
        Assert.assertEquals((Object)dateValue.toString(), (Object)columnValue.toString());
    }

    @Test
    public void testDATE2() throws Exception {
        ReturnTypesMap1 test = this.context.newObject(ReturnTypesMap1.class);
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(2002, 1, 1);
        Date dateValue = cal.getTime();
        test.setDateColumn(dateValue);
        this.context.commitChanges();
        SelectQuery<ReturnTypesMap1> q = new SelectQuery<ReturnTypesMap1>(ReturnTypesMap1.class);
        ReturnTypesMap1 testRead = (ReturnTypesMap1)this.context.performQuery(q).get(0);
        Date columnValue = testRead.getDateColumn();
        Assert.assertNotNull((Object)columnValue);
        Assert.assertEquals(Date.class, columnValue.getClass());
        Assert.assertEquals((Object)dateValue.toString(), (Object)columnValue.toString());
    }

    @Test
    public void testDECIMAL() throws Exception {
        String columnName = "DECIMAL_COLUMN";
        ReturnTypesMap1 test = this.context.newObject(ReturnTypesMap1.class);
        BigDecimal decimalValue = new BigDecimal("578438.57843");
        test.setDecimalColumn(decimalValue);
        this.context.commitChanges();
        DataRow testRead = (DataRow)this.context.performQuery(MappedSelect.query("SelectReturnTypesMap1")).get(0);
        Object columnValue = testRead.get(columnName);
        Assert.assertNotNull(columnValue);
        Assert.assertEquals(BigDecimal.class, columnValue.getClass());
        Assert.assertEquals((Object)decimalValue, columnValue);
    }

    @Test
    public void testDECIMAL2() throws Exception {
        ReturnTypesMap1 test = this.context.newObject(ReturnTypesMap1.class);
        BigDecimal decimalValue = new BigDecimal("578438.57843");
        test.setDecimalColumn(decimalValue);
        this.context.commitChanges();
        SelectQuery<ReturnTypesMap1> q = new SelectQuery<ReturnTypesMap1>(ReturnTypesMap1.class);
        ReturnTypesMap1 testRead = (ReturnTypesMap1)this.context.performQuery(q).get(0);
        BigDecimal columnValue = testRead.getDecimalColumn();
        Assert.assertNotNull((Object)columnValue);
        Assert.assertEquals(BigDecimal.class, columnValue.getClass());
        Assert.assertEquals((Object)decimalValue, (Object)columnValue);
    }

    @Test
    public void testDOUBLE() throws Exception {
        String columnName = "DOUBLE_COLUMN";
        ReturnTypesMap1 test = this.context.newObject(ReturnTypesMap1.class);
        Double doubleValue = 3298.4349783;
        test.setDoubleColumn(doubleValue);
        this.context.commitChanges();
        DataRow testRead = (DataRow)this.context.performQuery(MappedSelect.query("SelectReturnTypesMap1")).get(0);
        Object columnValue = testRead.get(columnName);
        Assert.assertNotNull(columnValue);
        if (this.unitDbAdapter.onlyGenericNumberType()) {
            Assert.assertEquals(BigDecimal.class, columnValue.getClass());
            Assert.assertEquals((Object)BigDecimal.valueOf(doubleValue), columnValue);
        } else {
            Assert.assertEquals(Double.class, columnValue.getClass());
            Assert.assertEquals((Object)doubleValue, columnValue);
        }
    }

    @Test
    public void testDOUBLE2() throws Exception {
        ReturnTypesMap1 test = this.context.newObject(ReturnTypesMap1.class);
        Double doubleValue = 3298.4349783;
        test.setDoubleColumn(doubleValue);
        this.context.commitChanges();
        SelectQuery<ReturnTypesMap1> q = new SelectQuery<ReturnTypesMap1>(ReturnTypesMap1.class);
        ReturnTypesMap1 testRead = (ReturnTypesMap1)this.context.performQuery(q).get(0);
        Double columnValue = testRead.getDoubleColumn();
        Assert.assertNotNull((Object)columnValue);
        Assert.assertEquals(Double.class, columnValue.getClass());
        Assert.assertEquals((Object)doubleValue, (Object)columnValue);
    }

    @Test
    public void testFLOAT() throws Exception {
        String columnName = "FLOAT_COLUMN";
        ReturnTypesMap1 test = this.context.newObject(ReturnTypesMap1.class);
        Float floatValue = Float.valueOf(375.437f);
        test.setFloatColumn(floatValue);
        this.context.commitChanges();
        DataRow testRead = (DataRow)this.context.performQuery(MappedSelect.query("SelectReturnTypesMap1")).get(0);
        Object columnValue = testRead.get(columnName);
        Assert.assertNotNull(columnValue);
        if (this.unitDbAdapter.onlyGenericNumberType()) {
            Assert.assertEquals(BigDecimal.class, columnValue.getClass());
        } else {
            Assert.assertTrue((Float.class.equals(columnValue.getClass()) || Double.class.equals(columnValue.getClass()) ? 1 : 0) != 0);
        }
        Assert.assertEquals((float)floatValue.floatValue(), (float)((Number)columnValue).floatValue(), (float)0.0f);
    }

    @Test
    public void testFLOAT2() throws Exception {
        ReturnTypesMap1 test = this.context.newObject(ReturnTypesMap1.class);
        Float floatValue = Float.valueOf(375.437f);
        test.setFloatColumn(floatValue);
        this.context.commitChanges();
        SelectQuery<ReturnTypesMap1> q = new SelectQuery<ReturnTypesMap1>(ReturnTypesMap1.class);
        ReturnTypesMap1 testRead = (ReturnTypesMap1)this.context.performQuery(q).get(0);
        Float columnValue = testRead.getFloatColumn();
        Assert.assertNotNull((Object)columnValue);
        Assert.assertEquals(Float.class, columnValue.getClass());
        Assert.assertEquals((Object)floatValue, (Object)columnValue);
    }

    @Test
    public void testINTEGER() throws Exception {
        String columnName = "INTEGER_COLUMN";
        ReturnTypesMap1 test = this.context.newObject(ReturnTypesMap1.class);
        Integer integerValue = 54235;
        test.setIntegerColumn(integerValue);
        this.context.commitChanges();
        DataRow testRead = (DataRow)this.context.performQuery(MappedSelect.query("SelectReturnTypesMap1")).get(0);
        Object columnValue = testRead.get(columnName);
        Assert.assertNotNull(columnValue);
        Assert.assertEquals(Integer.class, columnValue.getClass());
        Assert.assertEquals((Object)integerValue, columnValue);
    }

    @Test
    public void testINTEGER2() throws Exception {
        ReturnTypesMap1 test = this.context.newObject(ReturnTypesMap1.class);
        Integer integerValue = 54235;
        test.setIntegerColumn(integerValue);
        this.context.commitChanges();
        SelectQuery<ReturnTypesMap1> q = new SelectQuery<ReturnTypesMap1>(ReturnTypesMap1.class);
        ReturnTypesMap1 testRead = (ReturnTypesMap1)this.context.performQuery(q).get(0);
        Integer columnValue = testRead.getIntegerColumn();
        Assert.assertNotNull((Object)columnValue);
        Assert.assertEquals(Integer.class, columnValue.getClass());
        Assert.assertEquals((Object)integerValue, (Object)columnValue);
    }

    @Test
    public void testLONGVARBINARY() throws Exception {
        if (this.unitDbAdapter.supportsLobs()) {
            String columnName = "LONGVARBINARY_COLUMN";
            ReturnTypesMap2 test = this.context.newObject(ReturnTypesMap2.class);
            byte[] longvarbinaryValue = new byte[]{3, 4, 5, -6, 7, 0, 2, 9, 45, 64, 3, 127, -128, -60};
            test.setLongvarbinaryColumn(longvarbinaryValue);
            this.context.commitChanges();
            DataRow testRead = (DataRow)this.context.performQuery(MappedSelect.query("SelectReturnTypesMap2")).get(0);
            Object columnValue = testRead.get(columnName);
            Assert.assertNotNull(columnValue);
            Assert.assertEquals(byte[].class, columnValue.getClass());
            Assert.assertTrue((boolean)Arrays.equals(longvarbinaryValue, (byte[])columnValue));
        }
    }

    @Test
    public void testLONGVARBINARY2() throws Exception {
        if (this.unitDbAdapter.supportsLobs()) {
            ReturnTypesMap2 test = this.context.newObject(ReturnTypesMap2.class);
            byte[] longvarbinaryValue = new byte[]{3, 4, 5, -6, 7, 0, 2, 9, 45, 64, 3, 127, -128, -60};
            test.setLongvarbinaryColumn(longvarbinaryValue);
            this.context.commitChanges();
            SelectQuery<ReturnTypesMap2> q = new SelectQuery<ReturnTypesMap2>(ReturnTypesMap2.class);
            ReturnTypesMap2 testRead = (ReturnTypesMap2)this.context.performQuery(q).get(0);
            byte[] columnValue = testRead.getLongvarbinaryColumn();
            Assert.assertNotNull((Object)columnValue);
            Assert.assertEquals(byte[].class, columnValue.getClass());
            Assert.assertTrue((boolean)Arrays.equals(longvarbinaryValue, columnValue));
        }
    }

    @Test
    public void testLONGVARCHAR() throws Exception {
        String columnName = "LONGVARCHAR_COLUMN";
        ReturnTypesMap1 test = this.context.newObject(ReturnTypesMap1.class);
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < 500; ++i) {
            buffer.append("LONGVARCHAR large string for tests!!!!\n");
        }
        String longvarcharValue = buffer.toString();
        test.setLongvarcharColumn(longvarcharValue);
        this.context.commitChanges();
        DataRow testRead = (DataRow)this.context.performQuery(MappedSelect.query("SelectReturnTypesMap1")).get(0);
        Object columnValue = testRead.get(columnName);
        Assert.assertNotNull(columnValue);
        Assert.assertEquals(String.class, columnValue.getClass());
        Assert.assertEquals((Object)longvarcharValue, columnValue);
    }

    @Test
    public void testLONGNVARCHAR() throws Exception {
        String columnName = "LONGNVARCHAR_COLUMN";
        ReturnTypesMap1 test = this.context.newObject(ReturnTypesMap1.class);
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < 500; ++i) {
            buffer.append("\u06cc \u0645\u062a\u0648\u0627\u0632\u0646\u060c \u0646\u06cc\u0627\u0632\u06cc \u0646\u062f\u0627\u0631\u062f \u06a9\u0647 \u0628 large string for tests!!!!\n");
        }
        String longnvarcharValue = buffer.toString();
        test.setLongnvarcharColumn(longnvarcharValue);
        this.context.commitChanges();
        DataRow testRead = (DataRow)this.context.performQuery(MappedSelect.query("SelectReturnTypesMap1")).get(0);
        Object columnValue = testRead.get(columnName);
        Assert.assertNotNull(columnValue);
        Assert.assertEquals(String.class, columnValue.getClass());
        Assert.assertEquals((Object)longnvarcharValue, columnValue);
    }

    @Test
    public void testLONGVARCHAR2() throws Exception {
        ReturnTypesMap1 test = this.context.newObject(ReturnTypesMap1.class);
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < 500; ++i) {
            buffer.append("LONGVARCHAR large string for tests!!!!\n");
        }
        String longvarcharValue = buffer.toString();
        test.setLongvarcharColumn(longvarcharValue);
        this.context.commitChanges();
        SelectQuery<ReturnTypesMap1> q = new SelectQuery<ReturnTypesMap1>(ReturnTypesMap1.class);
        ReturnTypesMap1 testRead = (ReturnTypesMap1)this.context.performQuery(q).get(0);
        String columnValue = testRead.getLongvarcharColumn();
        Assert.assertNotNull((Object)columnValue);
        Assert.assertEquals(String.class, columnValue.getClass());
        Assert.assertEquals((Object)longvarcharValue, (Object)columnValue);
    }

    @Test
    public void testNUMERIC() throws Exception {
        String columnName = "NUMERIC_COLUMN";
        ReturnTypesMap1 test = this.context.newObject(ReturnTypesMap1.class);
        BigDecimal numericValue = new BigDecimal("578438.57843");
        test.setNumericColumn(numericValue);
        this.context.commitChanges();
        DataRow testRead = (DataRow)this.context.performQuery(MappedSelect.query("SelectReturnTypesMap1")).get(0);
        Object columnValue = testRead.get(columnName);
        Assert.assertNotNull(columnValue);
        Assert.assertEquals(BigDecimal.class, columnValue.getClass());
        Assert.assertEquals((Object)numericValue, columnValue);
    }

    @Test
    public void testNUMERIC2() throws Exception {
        ReturnTypesMap1 test = this.context.newObject(ReturnTypesMap1.class);
        BigDecimal numericValue = new BigDecimal("578438.57843");
        test.setNumericColumn(numericValue);
        this.context.commitChanges();
        SelectQuery<ReturnTypesMap1> q = new SelectQuery<ReturnTypesMap1>(ReturnTypesMap1.class);
        ReturnTypesMap1 testRead = (ReturnTypesMap1)this.context.performQuery(q).get(0);
        BigDecimal columnValue = testRead.getNumericColumn();
        Assert.assertNotNull((Object)columnValue);
        Assert.assertEquals(BigDecimal.class, columnValue.getClass());
        Assert.assertEquals((Object)numericValue, (Object)columnValue);
    }

    @Test
    public void testREAL() throws Exception {
        String columnName = "REAL_COLUMN";
        ReturnTypesMap1 test = this.context.newObject(ReturnTypesMap1.class);
        Float realValue = Float.valueOf(5788.5786f);
        test.setRealColumn(realValue);
        this.context.commitChanges();
        DataRow testRead = (DataRow)this.context.performQuery(MappedSelect.query("SelectReturnTypesMap1")).get(0);
        Object columnValue = testRead.get(columnName);
        Assert.assertNotNull(columnValue);
        if (this.unitDbAdapter.onlyGenericNumberType()) {
            Assert.assertEquals(BigDecimal.class, columnValue.getClass());
        } else if (this.unitDbAdapter.realAsDouble()) {
            Assert.assertEquals(Double.class, columnValue.getClass());
            Assert.assertEquals((double)realValue.floatValue(), (double)((Double)columnValue), (double)1.0E-4);
        } else {
            Assert.assertEquals(Float.class, columnValue.getClass());
            Assert.assertEquals((Object)realValue, columnValue);
        }
    }

    @Test
    public void testREAL2() throws Exception {
        ReturnTypesMap1 test = this.context.newObject(ReturnTypesMap1.class);
        Float realValue = Float.valueOf(5788.5786f);
        test.setRealColumn(realValue);
        this.context.commitChanges();
        SelectQuery<ReturnTypesMap1> q = new SelectQuery<ReturnTypesMap1>(ReturnTypesMap1.class);
        ReturnTypesMap1 testRead = (ReturnTypesMap1)this.context.performQuery(q).get(0);
        Float columnValue = testRead.getRealColumn();
        Assert.assertNotNull((Object)columnValue);
        Assert.assertEquals(Float.class, columnValue.getClass());
        Assert.assertEquals((Object)realValue, (Object)columnValue);
    }

    @Test
    public void testSMALLINT() throws Exception {
        String columnName = "SMALLINT_COLUMN";
        ReturnTypesMap1 test = this.context.newObject(ReturnTypesMap1.class);
        Short smallintValue = 32564;
        Integer intValue = 32564;
        test.setSmallintColumn(smallintValue);
        this.context.commitChanges();
        DataRow testRead = (DataRow)this.context.performQuery(MappedSelect.query("SelectReturnTypesMap1")).get(0);
        Object columnValue = testRead.get(columnName);
        Assert.assertNotNull(columnValue);
        if (this.unitDbAdapter.onlyGenericNumberType()) {
            Assert.assertEquals(Integer.class, columnValue.getClass());
            Assert.assertEquals((Object)intValue, columnValue);
        } else {
            Assert.assertEquals(Short.class, columnValue.getClass());
            Assert.assertEquals((Object)smallintValue, columnValue);
        }
    }

    @Test
    public void testSMALLINT2() throws Exception {
        ReturnTypesMap1 test = this.context.newObject(ReturnTypesMap1.class);
        Short smallintValue = 32564;
        test.setSmallintColumn(smallintValue);
        this.context.commitChanges();
        SelectQuery<ReturnTypesMap1> q = new SelectQuery<ReturnTypesMap1>(ReturnTypesMap1.class);
        ReturnTypesMap1 testRead = (ReturnTypesMap1)this.context.performQuery(q).get(0);
        Short columnValue = testRead.getSmallintColumn();
        Assert.assertNotNull((Object)columnValue);
        Assert.assertEquals(Short.class, columnValue.getClass());
        Assert.assertEquals((Object)smallintValue, (Object)columnValue);
    }

    @Test
    public void testTIME() throws Exception {
        String columnName = "TIME_COLUMN";
        ReturnTypesMap1 test = this.context.newObject(ReturnTypesMap1.class);
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(2003, 1, 1, 1, 20, 30);
        Time timeValue = new Time(cal.getTime().getTime());
        test.setTimeColumn(timeValue);
        this.context.commitChanges();
        DataRow testRead = (DataRow)this.context.performQuery(MappedSelect.query("SelectReturnTypesMap1")).get(0);
        Object columnValue = testRead.get(columnName);
        Assert.assertNotNull(columnValue);
        Assert.assertEquals(Date.class, columnValue.getClass());
        Assert.assertEquals((Object)((Date)timeValue).toString(), (Object)new Time(((Date)columnValue).getTime()).toString());
    }

    @Test
    public void testTIME2() throws Exception {
        ReturnTypesMap1 test = this.context.newObject(ReturnTypesMap1.class);
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(2003, 1, 1, 1, 20, 30);
        Time timeValue = new Time(cal.getTime().getTime());
        test.setTimeColumn(timeValue);
        this.context.commitChanges();
        SelectQuery<ReturnTypesMap1> q = new SelectQuery<ReturnTypesMap1>(ReturnTypesMap1.class);
        ReturnTypesMap1 testRead = (ReturnTypesMap1)this.context.performQuery(q).get(0);
        Date columnValue = testRead.getTimeColumn();
        Assert.assertNotNull((Object)columnValue);
        Assert.assertEquals(Date.class, columnValue.getClass());
        Assert.assertEquals((Object)((Date)timeValue).toString(), (Object)new Time(columnValue.getTime()).toString());
    }

    @Test
    public void testTIMESTAMP() throws Exception {
        String columnName = "TIMESTAMP_COLUMN";
        ReturnTypesMap1 test = this.context.newObject(ReturnTypesMap1.class);
        Date timestampValue = Calendar.getInstance().getTime();
        test.setTimestampColumn(timestampValue);
        this.context.commitChanges();
        DataRow testRead = (DataRow)this.context.performQuery(MappedSelect.query("SelectReturnTypesMap1")).get(0);
        Object columnValue = testRead.get(columnName);
        Assert.assertNotNull(columnValue);
        Assert.assertEquals(Date.class, columnValue.getClass());
        long delta = timestampValue.getTime() - ((Date)columnValue).getTime();
        Assert.assertTrue((delta < 1000L ? 1 : 0) != 0);
    }

    @Test
    public void testTIMESTAMP2() throws Exception {
        ReturnTypesMap1 test = this.context.newObject(ReturnTypesMap1.class);
        Date timestampValue = Calendar.getInstance().getTime();
        test.setTimestampColumn(timestampValue);
        this.context.commitChanges();
        SelectQuery<ReturnTypesMap1> q = new SelectQuery<ReturnTypesMap1>(ReturnTypesMap1.class);
        ReturnTypesMap1 testRead = (ReturnTypesMap1)this.context.performQuery(q).get(0);
        Date columnValue = testRead.getTimestampColumn();
        Assert.assertNotNull((Object)columnValue);
        Assert.assertEquals(Date.class, columnValue.getClass());
        long delta = timestampValue.getTime() - columnValue.getTime();
        Assert.assertTrue((delta < 1000L ? 1 : 0) != 0);
    }

    @Test
    public void testTINYINT() throws Exception {
        String columnName = "TINYINT_COLUMN";
        ReturnTypesMap1 test = this.context.newObject(ReturnTypesMap1.class);
        Byte tinyintValue = 89;
        Integer intValue = 89;
        test.setTinyintColumn(tinyintValue);
        this.context.commitChanges();
        DataRow testRead = (DataRow)this.context.performQuery(MappedSelect.query("SelectReturnTypesMap1")).get(0);
        Object columnValue = testRead.get(columnName);
        Assert.assertNotNull(columnValue);
        if (this.unitDbAdapter.onlyGenericNumberType()) {
            Assert.assertEquals(Integer.class, columnValue.getClass());
        } else {
            Assert.assertEquals(Short.class, columnValue.getClass());
        }
        Assert.assertEquals((long)tinyintValue.intValue(), (long)((Number)columnValue).intValue());
    }

    @Test
    public void testTINYINT2() throws Exception {
        ReturnTypesMap1 test = this.context.newObject(ReturnTypesMap1.class);
        Byte tinyintValue = 89;
        test.setTinyintColumn(tinyintValue);
        this.context.commitChanges();
        SelectQuery<ReturnTypesMap1> q = new SelectQuery<ReturnTypesMap1>(ReturnTypesMap1.class);
        ReturnTypesMap1 testRead = (ReturnTypesMap1)this.context.performQuery(q).get(0);
        Byte columnValue = testRead.getTinyintColumn();
        Assert.assertNotNull((Object)columnValue);
        Assert.assertEquals(Byte.class, columnValue.getClass());
        Assert.assertEquals((Object)tinyintValue, (Object)columnValue);
    }

    @Test
    public void testVARBINARY() throws Exception {
        if (this.unitDbAdapter.supportsLobs()) {
            String columnName = "VARBINARY_COLUMN";
            ReturnTypesMap2 test = this.context.newObject(ReturnTypesMap2.class);
            byte[] varbinaryValue = new byte[]{3, 4, 5, -6, 7, 0, 2, 9, 45, 64, 3, 127, -128, -60};
            test.setVarbinaryColumn(varbinaryValue);
            this.context.commitChanges();
            DataRow testRead = (DataRow)this.context.performQuery(MappedSelect.query("SelectReturnTypesMap2")).get(0);
            Object columnValue = testRead.get(columnName);
            Assert.assertNotNull(columnValue);
            Assert.assertEquals(byte[].class, columnValue.getClass());
            Assert.assertTrue((boolean)Arrays.equals(varbinaryValue, (byte[])columnValue));
        }
    }

    @Test
    public void testVARBINARY2() throws Exception {
        if (this.unitDbAdapter.supportsLobs()) {
            ReturnTypesMap2 test = this.context.newObject(ReturnTypesMap2.class);
            byte[] varbinaryValue = new byte[]{3, 4, 5, -6, 7, 0, 2, 9, 45, 64, 3, 127, -128, -60};
            test.setVarbinaryColumn(varbinaryValue);
            this.context.commitChanges();
            SelectQuery<ReturnTypesMap2> q = new SelectQuery<ReturnTypesMap2>(ReturnTypesMap2.class);
            ReturnTypesMap2 testRead = (ReturnTypesMap2)this.context.performQuery(q).get(0);
            byte[] columnValue = testRead.getVarbinaryColumn();
            Assert.assertNotNull((Object)columnValue);
            Assert.assertEquals(byte[].class, columnValue.getClass());
            Assert.assertTrue((boolean)Arrays.equals(varbinaryValue, columnValue));
        }
    }

    @Test
    public void testVARCHAR() throws Exception {
        String columnName = "VARCHAR_COLUMN";
        ReturnTypesMap1 test = this.context.newObject(ReturnTypesMap1.class);
        String varcharValue = "VARChar string for tests!";
        test.setVarcharColumn(varcharValue);
        this.context.commitChanges();
        DataRow testRead = (DataRow)this.context.performQuery(MappedSelect.query("SelectReturnTypesMap1")).get(0);
        Object columnValue = testRead.get(columnName);
        Assert.assertNotNull(columnValue);
        Assert.assertEquals(String.class, columnValue.getClass());
        Assert.assertEquals((Object)varcharValue, columnValue);
    }

    @Test
    public void testNVARCHAR() throws Exception {
        String columnName = "NVARCHAR_COLUMN";
        ReturnTypesMap1 test = this.context.newObject(ReturnTypesMap1.class);
        String varcharValue = "\u06cc \u0645\u062a\u0648\u0627\u0632\u0646\u060c \u0646\u06cc\u0627\u0632\u06cc \u0646\u062f\u0627\u0631\u062f \u06a9\u0647 \u0628";
        test.setNvarcharColumn(varcharValue);
        this.context.commitChanges();
        DataRow testRead = (DataRow)this.context.performQuery(MappedSelect.query("SelectReturnTypesMap1")).get(0);
        Object columnValue = testRead.get(columnName);
        Assert.assertNotNull(columnValue);
        Assert.assertEquals(String.class, columnValue.getClass());
        Assert.assertEquals((Object)varcharValue, columnValue);
    }

    @Test
    public void testVARCHAR2() throws Exception {
        ReturnTypesMap1 test = this.context.newObject(ReturnTypesMap1.class);
        String varcharValue = "VARChar string for tests!";
        test.setVarcharColumn(varcharValue);
        this.context.commitChanges();
        SelectQuery<ReturnTypesMap1> q = new SelectQuery<ReturnTypesMap1>(ReturnTypesMap1.class);
        ReturnTypesMap1 testRead = (ReturnTypesMap1)this.context.performQuery(q).get(0);
        String columnValue = testRead.getVarcharColumn();
        Assert.assertNotNull((Object)columnValue);
        Assert.assertEquals(String.class, columnValue.getClass());
        Assert.assertEquals((Object)varcharValue, (Object)columnValue);
    }
}

