/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.query.ObjectIdQuery;
import org.apache.cayenne.query.RelationshipQuery;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.query.UpdateBatchQuery;
import org.apache.cayenne.testdo.quotemap.QuoteAdress;
import org.apache.cayenne.testdo.quotemap.Quote_Person;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-quoted-identifiers.xml")
public class QuotedIdentifiersIT
extends ServerCase {
    @Inject
    private ObjectContext context;

    @Before
    public void setUp() throws Exception {
        QuoteAdress quoteAdress = this.context.newObject(QuoteAdress.class);
        quoteAdress.setCity("city");
        quoteAdress.setGroup("324");
        Quote_Person quote_Person = this.context.newObject(Quote_Person.class);
        quote_Person.setSalary(10000);
        quote_Person.setName("Arcadi");
        quote_Person.setGroup("107324");
        quote_Person.setAddress_Rel(quoteAdress);
        this.context.commitChanges();
        SelectQuery<QuoteAdress> q = new SelectQuery<QuoteAdress>(QuoteAdress.class);
        List objects = this.context.performQuery(q);
        Assert.assertEquals((long)1L, (long)objects.size());
        SelectQuery<Quote_Person> qQuote_Person = new SelectQuery<Quote_Person>(Quote_Person.class);
        List objects2 = this.context.performQuery(qQuote_Person);
        Assert.assertEquals((long)1L, (long)objects2.size());
        QuoteAdress quoteAdress2 = this.context.newObject(QuoteAdress.class);
        quoteAdress2.setCity("city2");
        Quote_Person quote_Person2 = this.context.newObject(Quote_Person.class);
        quote_Person2.setSalary(100);
        quote_Person2.setName("Name");
        quote_Person2.setGroup("1111");
        quote_Person2.setDAte(new Date());
        quote_Person2.setAddress_Rel(quoteAdress2);
        this.context.commitChanges();
    }

    @Test
    public void testPrefetchQuote() throws Exception {
        DbEntity entity = this.context.getEntityResolver().getObjEntity(QuoteAdress.class).getDbEntity();
        List<DbAttribute> idAttributes = Collections.singletonList(entity.getAttribute("City"));
        List<DbAttribute> updatedAttributes = Collections.singletonList(entity.getAttribute("City"));
        UpdateBatchQuery updateQuery = new UpdateBatchQuery(entity, idAttributes, updatedAttributes, Collections.emptySet(), 1);
        List objects3 = this.context.performQuery(updateQuery);
        Assert.assertEquals((long)0L, (long)objects3.size());
        SelectQuery<Quote_Person> qQuote_Person2 = new SelectQuery<Quote_Person>(Quote_Person.class);
        List objects4 = this.context.performQuery(qQuote_Person2);
        Assert.assertEquals((long)2L, (long)objects4.size());
        SelectQuery<Quote_Person> qQuote_Person3 = new SelectQuery<Quote_Person>(Quote_Person.class, ExpressionFactory.matchExp("salary", (Object)100));
        List objects5 = this.context.performQuery(qQuote_Person3);
        Assert.assertEquals((long)1L, (long)objects5.size());
        SelectQuery<Quote_Person> qQuote_Person4 = new SelectQuery<Quote_Person>(Quote_Person.class, ExpressionFactory.matchExp("group", (Object)"107324"));
        List objects6 = this.context.performQuery(qQuote_Person4);
        Assert.assertEquals((long)1L, (long)objects6.size());
        SelectQuery<QuoteAdress> quoteAdress1 = new SelectQuery<QuoteAdress>(QuoteAdress.class, ExpressionFactory.matchExp("group", (Object)"324"));
        List objects7 = this.context.performQuery(quoteAdress1);
        Assert.assertEquals((long)1L, (long)objects7.size());
        ObjectIdQuery queryObjectId = new ObjectIdQuery(new ObjectId("QuoteAdress", QuoteAdress.GROUP.getName(), "324"));
        List objects8 = this.context.performQuery(queryObjectId);
        Assert.assertEquals((long)1L, (long)objects8.size());
        ObjectIdQuery queryObjectId2 = new ObjectIdQuery(new ObjectId("Quote_Person", "GROUP", "1111"));
        List objects9 = this.context.performQuery(queryObjectId2);
        Assert.assertEquals((long)1L, (long)objects9.size());
        SelectQuery<Quote_Person> person2Query = new SelectQuery<Quote_Person>(Quote_Person.class, ExpressionFactory.matchExp("name", (Object)"Name"));
        Quote_Person quote_Person2 = (Quote_Person)this.context.performQuery(person2Query).get(0);
        RelationshipQuery relationshipQuery = new RelationshipQuery(quote_Person2.getObjectId(), "address_Rel");
        List objects10 = this.context.performQuery(relationshipQuery);
        Assert.assertEquals((long)1L, (long)objects10.size());
    }

    @Test
    public void testQuotedEJBQLQuery() throws Exception {
        String ejbql = "select a from QuoteAdress a where a.group = '324'";
        EJBQLQuery queryEJBQL = new EJBQLQuery(ejbql);
        List objects11 = this.context.performQuery(queryEJBQL);
        Assert.assertEquals((long)1L, (long)objects11.size());
    }

    @Test
    public void testQuotedEJBQLQueryWithJoin() throws Exception {
        String ejbql = "select p from Quote_Person p join p.address_Rel a where p.name = 'Arcadi'";
        EJBQLQuery queryEJBQL = new EJBQLQuery(ejbql);
        List resultList = this.context.performQuery(queryEJBQL);
        Assert.assertEquals((long)1L, (long)resultList.size());
    }

    @Test
    public void testQuotedEJBQLQueryWithOrderBy() throws Exception {
        EJBQLQuery query = new EJBQLQuery("select p from Quote_Person p order by p.name");
        List resultList = this.context.performQuery(query);
        Assert.assertEquals((long)2L, (long)resultList.size());
        Assert.assertEquals((Object)"Arcadi", (Object)((Quote_Person)resultList.get(0)).getName());
        Assert.assertEquals((Object)"Name", (Object)((Quote_Person)resultList.get(1)).getName());
    }

    @Test
    public void testQuotedEJBQLCountQuery() throws Exception {
        EJBQLQuery query = new EJBQLQuery("select count(p) from Quote_Person p");
        Assert.assertEquals(Collections.singletonList(2L), (Object)this.context.performQuery(query));
        query = new EJBQLQuery("select count(p.fULL_name) from Quote_Person p");
        Assert.assertEquals(Collections.singletonList(0L), (Object)this.context.performQuery(query));
    }
}

