/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.CayenneRuntimeException;
import org.junit.Assert;
import org.junit.Test;

public class CayenneRuntimeExceptionTest {
    @Test
    public void testConstructor1() throws Exception {
        CayenneRuntimeException ex = new CayenneRuntimeException();
        Assert.assertNull((Object)ex.getCause());
        Assert.assertTrue((boolean)ex.getMessage().startsWith(CayenneException.getExceptionLabel()));
    }

    @Test
    public void testConstructor2() throws Exception {
        CayenneRuntimeException ex = new CayenneRuntimeException("abc", new Object[0]);
        Assert.assertNull((Object)ex.getCause());
        Assert.assertEquals((Object)(CayenneException.getExceptionLabel() + "abc"), (Object)ex.getMessage());
    }

    @Test
    public void testConstructor3() throws Exception {
        Throwable cause = new Throwable();
        CayenneRuntimeException ex = new CayenneRuntimeException(cause);
        Assert.assertSame((Object)cause, (Object)ex.getCause());
        Assert.assertEquals((Object)(CayenneException.getExceptionLabel() + cause.toString()), (Object)ex.getMessage());
    }

    @Test
    public void testConstructor4() throws Exception {
        Throwable cause = new Throwable();
        CayenneRuntimeException ex = new CayenneRuntimeException("abc", cause, new Object[0]);
        Assert.assertSame((Object)cause, (Object)ex.getCause());
        Assert.assertEquals((Object)(CayenneException.getExceptionLabel() + "abc"), (Object)ex.getMessage());
    }

    @Test
    public void testThrow1() throws Exception {
        try {
            throw new CayenneRuntimeException();
        }
        catch (CayenneRuntimeException rtex) {
            StringWriter w = new StringWriter();
            rtex.printStackTrace(new PrintWriter(w));
            return;
        }
    }

    @Test
    public void testThrow2() throws Exception {
        try {
            try {
                throw new Throwable("Test Cause");
            }
            catch (Throwable th) {
                throw new CayenneRuntimeException(th);
            }
        }
        catch (CayenneRuntimeException rtex) {
            StringWriter w = new StringWriter();
            rtex.printStackTrace(new PrintWriter(w));
            return;
        }
    }

    @Test
    public void testMessageFormatting1() throws Exception {
        CayenneRuntimeException ex = new CayenneRuntimeException("x%sx%sx", "a", "b");
        Assert.assertEquals((Object)"xaxbx", (Object)ex.getUnlabeledMessage());
    }

    @Test
    public void testMessageFormatting2() throws Exception {
        Throwable cause = new Throwable();
        CayenneRuntimeException ex = new CayenneRuntimeException("x%sx%sx", cause, "a", "b");
        Assert.assertEquals((Object)"xaxbx", (Object)ex.getUnlabeledMessage());
    }
}

