/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.Property;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.SQLResult;
import org.apache.cayenne.query.BaseQueryMetadata;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.SelectQuery;

class SelectQueryMetadata
extends BaseQueryMetadata {
    private static final long serialVersionUID = 7465922769303943945L;
    Map<String, String> pathSplitAliases;
    boolean isSingleResultSetMapping;

    SelectQueryMetadata() {
    }

    @Override
    void copyFromInfo(QueryMetadata info) {
        super.copyFromInfo(info);
        this.pathSplitAliases = new HashMap<String, String>(info.getPathSplitAliases());
    }

    <T> boolean resolve(Object root, EntityResolver resolver, SelectQuery<T> query) {
        if (super.resolve(root, resolver, null)) {
            if (this.cacheStrategy != null && this.cacheStrategy != QueryCacheStrategy.NO_CACHE) {
                this.cacheKey = this.makeCacheKey(query);
            }
            this.resolveAutoAliases(query);
            this.buildResultSetMappingForColumns(query, resolver);
            this.isSingleResultSetMapping = query.canReturnScalarValue() && super.isSingleResultSetMapping();
            return true;
        }
        return false;
    }

    private String makeCacheKey(SelectQuery<?> query) {
        StringBuilder key = new StringBuilder();
        ObjEntity entity = this.getObjEntity();
        if (entity != null) {
            key.append(entity.getName());
        } else if (this.dbEntity != null) {
            key.append("db:").append(this.dbEntity.getName());
        }
        if (query.getColumns() != null && !query.getColumns().isEmpty()) {
            key.append("/");
            for (Property property : query.getColumns()) {
                key.append("c:");
                try {
                    property.getExpression().appendAsString(key);
                }
                catch (IOException e) {
                    throw new CayenneRuntimeException("Unexpected IO Exception appending to StringBuilder", (Throwable)e, new Object[0]);
                }
            }
        }
        if (query.getQualifier() != null) {
            key.append('/');
            try {
                query.getQualifier().appendAsString(key);
            }
            catch (IOException e) {
                throw new CayenneRuntimeException("Unexpected IO Exception appending to StringBuilder", (Throwable)e, new Object[0]);
            }
        }
        if (!query.getOrderings().isEmpty()) {
            for (Ordering ordering : query.getOrderings()) {
                key.append('/').append(ordering.getSortSpecString());
                if (!ordering.isAscending()) {
                    key.append(":d");
                }
                if (!ordering.isCaseInsensitive()) continue;
                key.append(":i");
            }
        }
        if (query.getFetchOffset() > 0 || query.getFetchLimit() > 0) {
            key.append('/');
            if (query.getFetchOffset() > 0) {
                key.append('o').append(query.getFetchOffset());
            }
            if (query.getFetchLimit() > 0) {
                key.append('l').append(query.getFetchLimit());
            }
        }
        return key.toString();
    }

    private <T> void resolveAutoAliases(SelectQuery<T> query) {
        Expression qualifier = query.getQualifier();
        if (qualifier != null) {
            this.resolveAutoAliases(qualifier);
        }
    }

    private void resolveAutoAliases(Expression expression) {
        Map<String, String> aliases = expression.getPathAliases();
        if (!aliases.isEmpty()) {
            if (this.pathSplitAliases == null) {
                this.pathSplitAliases = new HashMap<String, String>();
            }
            this.pathSplitAliases.putAll(aliases);
        }
        int len = expression.getOperandCount();
        for (int i = 0; i < len; ++i) {
            Object operand = expression.getOperand(i);
            if (!(operand instanceof Expression)) continue;
            this.resolveAutoAliases((Expression)operand);
        }
    }

    @Override
    public Map<String, String> getPathSplitAliases() {
        return this.pathSplitAliases != null ? this.pathSplitAliases : Collections.emptyMap();
    }

    public void addPathSplitAliases(String path, String ... aliases) {
        if (aliases == null) {
            throw new NullPointerException("Null aliases");
        }
        if (aliases.length == 0) {
            throw new IllegalArgumentException("No aliases specified");
        }
        if (this.pathSplitAliases == null) {
            this.pathSplitAliases = new HashMap<String, String>();
        }
        for (String alias : aliases) {
            this.pathSplitAliases.put(alias, path);
        }
    }

    private void buildResultSetMappingForColumns(SelectQuery<?> query, EntityResolver resolver) {
        if (query.getColumns() == null || query.getColumns().isEmpty()) {
            return;
        }
        SQLResult result = new SQLResult();
        for (Property<?> column : query.getColumns()) {
            String name = column.getName() == null ? column.getExpression().expName() : column.getName();
            result.addColumnResult(name);
        }
        this.resultSetMapping = result.getResolvedComponents(resolver);
    }

    @Override
    public boolean isSingleResultSetMapping() {
        return this.isSingleResultSetMapping;
    }
}

