/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.hsqldb;

import java.io.IOException;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.translator.select.QueryAssembler;
import org.apache.cayenne.access.translator.select.TrimmingQualifierTranslator;
import org.apache.cayenne.exp.parser.ASTFunctionCall;
import org.apache.cayenne.exp.parser.PatternMatchNode;

public class HSQLQualifierTranslator
extends TrimmingQualifierTranslator {
    public HSQLQualifierTranslator(QueryAssembler queryAssembler) {
        super(queryAssembler, "RTRIM");
    }

    @Override
    protected void appendLikeEscapeCharacter(PatternMatchNode patternMatchNode) throws IOException {
        char escapeChar = patternMatchNode.getEscapeChar();
        if ('?' == escapeChar) {
            throw new CayenneRuntimeException("the escape character of '?' is illegal for LIKE clauses.", new Object[0]);
        }
        if ('\u0000' != escapeChar) {
            this.out.append(" ESCAPE '");
            this.out.append(escapeChar);
            this.out.append("'");
        }
    }

    @Override
    protected void appendFunction(ASTFunctionCall functionExpression) {
        if ("CURRENT_TIME".equals(functionExpression.getFunctionName())) {
            this.out.append("LOCALTIME");
        } else {
            super.appendFunction(functionExpression);
        }
    }
}

