/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.hsqldb;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.translator.ejbql.EJBQLTranslatorFactory;
import org.apache.cayenne.access.translator.select.QualifierTranslator;
import org.apache.cayenne.access.translator.select.QueryAssembler;
import org.apache.cayenne.access.translator.select.SelectTranslator;
import org.apache.cayenne.access.types.CharType;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.access.types.ExtendedTypeFactory;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.hsqldb.HSQLActionBuilder;
import org.apache.cayenne.dba.hsqldb.HSQLEJBQLTranslatorFactory;
import org.apache.cayenne.dba.hsqldb.HSQLQualifierTranslator;
import org.apache.cayenne.dba.hsqldb.HSQLSelectTranslator;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.resource.ResourceLocator;

public class HSQLDBAdapter
extends JdbcAdapter {
    public static final String TRIM_FUNCTION = "RTRIM";

    public HSQLDBAdapter(@Inject RuntimeProperties runtimeProperties, @Inject(value="cayenne.server.default_types") List<ExtendedType> defaultExtendedTypes, @Inject(value="cayenne.server.user_types") List<ExtendedType> userExtendedTypes, @Inject(value="cayenne.server.type_factories") List<ExtendedTypeFactory> extendedTypeFactories, @Inject(value="cayenne.server.resource_locator") ResourceLocator resourceLocator) {
        super(runtimeProperties, defaultExtendedTypes, userExtendedTypes, extendedTypeFactories, resourceLocator);
        this.setSupportsGeneratedKeys(true);
    }

    @Override
    protected void configureExtendedTypes(ExtendedTypeMap map) {
        super.configureExtendedTypes(map);
        map.registerType(new CharType(true, true));
    }

    @Override
    public SelectTranslator getSelectTranslator(SelectQuery<?> query, EntityResolver entityResolver) {
        return new HSQLSelectTranslator(query, this, entityResolver);
    }

    @Override
    public QualifierTranslator getQualifierTranslator(QueryAssembler queryAssembler) {
        HSQLQualifierTranslator translator = new HSQLQualifierTranslator(queryAssembler);
        translator.setCaseInsensitive(this.caseInsensitiveCollations);
        return translator;
    }

    @Override
    protected EJBQLTranslatorFactory createEJBQLTranslatorFactory() {
        HSQLEJBQLTranslatorFactory translatorFactory = new HSQLEJBQLTranslatorFactory();
        translatorFactory.setCaseInsensitive(this.caseInsensitiveCollations);
        return translatorFactory;
    }

    protected String getTableName(DbEntity entity) {
        return this.quotingStrategy.quotedFullyQualifiedName(entity);
    }

    protected String getSchemaName(DbEntity entity) {
        return entity.getSchema();
    }

    @Override
    public SQLAction getAction(Query query, DataNode node) {
        return query.createSQLAction(new HSQLActionBuilder(node));
    }

    @Override
    public String createUniqueConstraint(DbEntity source, Collection<DbAttribute> columns) {
        if (columns == null || columns.isEmpty()) {
            throw new CayenneRuntimeException("Can't create UNIQUE constraint - no columns specified.", new Object[0]);
        }
        String srcName = this.getTableName(source);
        StringBuilder buf = new StringBuilder();
        buf.append("ALTER TABLE ").append(srcName);
        buf.append(" ADD CONSTRAINT ");
        String name = "U_" + source.getName() + "_" + (long)((double)System.currentTimeMillis() / (Math.random() * 100000.0));
        buf.append(this.quotingStrategy.quotedIdentifier(source, source.getSchema(), name));
        buf.append(" UNIQUE (");
        Iterator<DbAttribute> it = columns.iterator();
        DbAttribute first = it.next();
        buf.append(this.quotingStrategy.quotedName(first));
        while (it.hasNext()) {
            DbAttribute next = it.next();
            buf.append(", ");
            buf.append(this.quotingStrategy.quotedName(next));
        }
        buf.append(")");
        return buf.toString();
    }

    @Override
    public String createFkConstraint(DbRelationship rel) {
        StringBuilder buf = new StringBuilder();
        StringBuilder refBuf = new StringBuilder();
        String srcName = this.getTableName(rel.getSourceEntity());
        String dstName = this.getTableName(rel.getTargetEntity());
        buf.append("ALTER TABLE ");
        buf.append(srcName);
        buf.append(" ADD CONSTRAINT ");
        String name = "U_" + rel.getSourceEntity().getName() + "_" + (long)((double)System.currentTimeMillis() / (Math.random() * 100000.0));
        DbEntity sourceEntity = rel.getSourceEntity();
        buf.append(this.quotingStrategy.quotedIdentifier(sourceEntity, sourceEntity.getSchema(), name));
        buf.append(" FOREIGN KEY (");
        boolean first = true;
        for (DbJoin join : rel.getJoins()) {
            if (!first) {
                buf.append(", ");
                refBuf.append(", ");
            } else {
                first = false;
            }
            buf.append(this.quotingStrategy.quotedSourceName(join));
            refBuf.append(this.quotingStrategy.quotedTargetName(join));
        }
        buf.append(") REFERENCES ");
        buf.append(dstName);
        buf.append(" (");
        buf.append(refBuf.toString());
        buf.append(')');
        buf.append(" ON DELETE CASCADE");
        return buf.toString();
    }

    @Override
    public String createTable(DbEntity ent) {
        String sql = super.createTable(ent);
        if (sql != null && sql.toUpperCase().startsWith("CREATE TABLE ")) {
            sql = "CREATE CACHED TABLE " + sql.substring("CREATE TABLE ".length());
        }
        return sql;
    }

    @Override
    public void createTableAppendColumn(StringBuffer sqlBuffer, DbAttribute column) {
        if (column.getType() == 8 && column.getMaxLength() > 0) {
            int len = column.getMaxLength();
            column.setMaxLength(0);
            super.createTableAppendColumn(sqlBuffer, column);
            column.setMaxLength(len);
        } else {
            super.createTableAppendColumn(sqlBuffer, column);
        }
        if (column.isGenerated()) {
            sqlBuffer.append(" GENERATED BY DEFAULT AS IDENTITY (START WITH 1)");
        }
    }
}

