/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.frontbase;

import org.apache.cayenne.access.translator.select.QualifierTranslator;
import org.apache.cayenne.access.translator.select.QueryAssembler;
import org.apache.cayenne.exp.parser.ASTFunctionCall;

public class FrontBaseQualifierTranslator
extends QualifierTranslator {
    private int substringArg = 0;

    public FrontBaseQualifierTranslator(QueryAssembler queryAssembler) {
        super(queryAssembler);
    }

    @Override
    protected void appendFunction(ASTFunctionCall functionExpression) {
        switch (functionExpression.getFunctionName()) {
            case "CONCAT": {
                break;
            }
            case "LOCATE": {
                this.out.append("POSITION");
                break;
            }
            case "LENGTH": {
                this.out.append("CHAR_LENGTH");
                break;
            }
            case "SUBSTRING": {
                this.substringArg = 0;
            }
            default: {
                super.appendFunction(functionExpression);
            }
        }
    }

    @Override
    protected void appendFunctionArgDivider(ASTFunctionCall functionExpression) {
        switch (functionExpression.getFunctionName()) {
            case "CONCAT": {
                this.out.append(" || ");
                break;
            }
            case "LOCATE": {
                this.out.append(" IN ");
                break;
            }
            case "SUBSTRING": {
                switch (this.substringArg++) {
                    case 0: {
                        this.out.append(" FROM ");
                        break;
                    }
                    case 1: {
                        this.out.append(" FOR ");
                    }
                }
                break;
            }
            default: {
                super.appendFunctionArgDivider(functionExpression);
            }
        }
    }

    @Override
    protected void clearLastFunctionArgDivider(ASTFunctionCall functionExpression) {
        switch (functionExpression.getFunctionName()) {
            case "CONCAT": {
                this.out.delete(this.out.length() - " || ".length(), this.out.length());
                break;
            }
            case "LOCATE": {
                this.out.delete(this.out.length() - " IN ".length(), this.out.length());
                break;
            }
            case "SUBSTRING": {
                if (this.substringArg != 2) break;
                this.out.delete(this.out.length() - " FOR ".length(), this.out.length());
                break;
            }
            default: {
                super.clearLastFunctionArgDivider(functionExpression);
            }
        }
    }
}

