/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.math.BigInteger;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.dba.TypesMapping;

public class BigIntegerType
implements ExtendedType<BigInteger> {
    @Override
    public String getClassName() {
        return BigInteger.class.getName();
    }

    @Override
    public BigInteger materializeObject(ResultSet rs, int index, int type) throws Exception {
        Object object = rs.getObject(index);
        if (object == null) {
            return null;
        }
        return new BigInteger(object.toString());
    }

    @Override
    public BigInteger materializeObject(CallableStatement rs, int index, int type) throws Exception {
        Object object = rs.getObject(index);
        if (object == null) {
            return null;
        }
        return new BigInteger(object.toString());
    }

    @Override
    public void setJdbcObject(PreparedStatement statement, BigInteger value, int pos, int type, int precision) throws Exception {
        if (value == null) {
            statement.setNull(pos, type);
        } else if (TypesMapping.isNumeric(type)) {
            statement.setLong(pos, value.longValue());
        } else {
            throw new IllegalArgumentException("Can't map BigInteger to a non-numeric type: " + TypesMapping.getSqlNameByType(type));
        }
    }

    @Override
    public String toString(BigInteger value) {
        if (value == null) {
            return "NULL";
        }
        return value.toString();
    }
}

