/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.velocity;

import java.util.Collections;
import java.util.HashMap;
import org.apache.cayenne.access.jdbc.SQLStatement;
import org.apache.cayenne.velocity.VelocitySQLTemplateProcessor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class VelocitySQLTemplateProcessor_ChainTest {
    private VelocitySQLTemplateProcessor processor;

    @Before
    public void before() {
        this.processor = new VelocitySQLTemplateProcessor();
    }

    @Test
    public void testProcessTemplateNoChunks() throws Exception {
        SQLStatement compiled = this.processor.processTemplate("#chain(' AND ') #end", Collections.emptyMap());
        Assert.assertEquals((Object)"", (Object)compiled.getSql());
        compiled = this.processor.processTemplate("#chain(' AND ') garbage #end", Collections.emptyMap());
        Assert.assertEquals((Object)"", (Object)compiled.getSql());
        compiled = this.processor.processTemplate("#chain(' AND ' 'PREFIX') #end", Collections.emptyMap());
        Assert.assertEquals((Object)"", (Object)compiled.getSql());
        compiled = this.processor.processTemplate("#chain(' AND ' 'PREFIX') garbage #end", Collections.emptyMap());
        Assert.assertEquals((Object)"", (Object)compiled.getSql());
    }

    @Test
    public void testProcessTemplateFullChain() throws Exception {
        String template = "#chain(' OR ')#chunk($a)$a#end#chunk($b)$b#end#chunk($c)$c#end#end";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("a", "[A]");
        map.put("b", "[B]");
        map.put("c", "[C]");
        SQLStatement compiled = this.processor.processTemplate(template, map);
        Assert.assertEquals((Object)"[A] OR [B] OR [C]", (Object)compiled.getSql());
    }

    @Test
    public void testProcessTemplateFullChainAndPrefix() throws Exception {
        String template = "#chain(' OR ' 'WHERE ')#chunk($a)$a#end#chunk($b)$b#end#chunk($c)$c#end#end";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("a", "[A]");
        map.put("b", "[B]");
        map.put("c", "[C]");
        SQLStatement compiled = this.processor.processTemplate(template, map);
        Assert.assertEquals((Object)"WHERE [A] OR [B] OR [C]", (Object)compiled.getSql());
    }

    @Test
    public void testProcessTemplatePartialChainMiddle() throws Exception {
        String template = "#chain(' OR ' 'WHERE ')#chunk($a)$a#end#chunk($b)$b#end#chunk($c)$c#end#end";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("a", "[A]");
        map.put("c", "[C]");
        SQLStatement compiled = this.processor.processTemplate(template, map);
        Assert.assertEquals((Object)"WHERE [A] OR [C]", (Object)compiled.getSql());
    }

    @Test
    public void testProcessTemplatePartialChainStart() throws Exception {
        String template = "#chain(' OR ' 'WHERE ')#chunk($a)$a#end#chunk($b)$b#end#chunk($c)$c#end#end";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("b", "[B]");
        map.put("c", "[C]");
        SQLStatement compiled = this.processor.processTemplate(template, map);
        Assert.assertEquals((Object)"WHERE [B] OR [C]", (Object)compiled.getSql());
    }

    @Test
    public void testProcessTemplatePartialChainEnd() throws Exception {
        String template = "#chain(' OR ' 'WHERE ')#chunk($a)$a#end#chunk($b)$b#end#chunk($c)$c#end#end";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("a", "[A]");
        map.put("b", "[B]");
        SQLStatement compiled = this.processor.processTemplate(template, map);
        Assert.assertEquals((Object)"WHERE [A] OR [B]", (Object)compiled.getSql());
    }

    @Test
    public void testProcessTemplateChainWithGarbage() throws Exception {
        String template = "#chain(' OR ' 'WHERE ')#chunk($a)$a#end some other stuff#chunk($c)$c#end#end";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("a", "[A]");
        map.put("c", "[C]");
        SQLStatement compiled = this.processor.processTemplate(template, map);
        Assert.assertEquals((Object)"WHERE [A] some other stuff OR [C]", (Object)compiled.getSql());
    }

    @Test
    public void testProcessTemplateChainUnconditionalChunks() throws Exception {
        String template = "#chain(' OR ' 'WHERE ')#chunk()C1#end#chunk()C2#end#chunk()C3#end#end";
        SQLStatement compiled = this.processor.processTemplate(template, Collections.emptyMap());
        Assert.assertEquals((Object)"WHERE C1 OR C2 OR C3", (Object)compiled.getSql());
    }

    @Test
    public void testProcessTemplateEmptyChain() throws Exception {
        String template = "#chain(' OR ' 'WHERE ')#chunk($a)$a#end#chunk($b)$b#end#chunk($c)$c#end#end";
        SQLStatement compiled = this.processor.processTemplate(template, Collections.emptyMap());
        Assert.assertEquals((Object)"", (Object)compiled.getSql());
    }

    @Test
    public void testProcessTemplateWithFalseOrZero1() throws Exception {
        String template = "#chain(' OR ' 'WHERE ')#chunk($a)[A]#end#chunk($b)[B]#end#chunk($c)$c#end#end";
        HashMap<String, Comparable<Boolean>> map = new HashMap<String, Comparable<Boolean>>();
        map.put("a", Boolean.valueOf(false));
        map.put("b", Integer.valueOf(0));
        SQLStatement compiled = this.processor.processTemplate(template, map);
        Assert.assertEquals((Object)"WHERE [A] OR [B]", (Object)compiled.getSql());
    }

    @Test
    public void testProcessTemplateWithFalseOrZero2() throws Exception {
        String template = "#chain(' OR ' 'WHERE ')#chunk($a)$a#end#chunk($b)$b#end#chunk($c)$c#end#end";
        HashMap<String, Comparable<Boolean>> map = new HashMap<String, Comparable<Boolean>>();
        map.put("a", Boolean.valueOf(false));
        map.put("b", Integer.valueOf(0));
        SQLStatement compiled = this.processor.processTemplate(template, map);
        Assert.assertEquals((Object)"WHERE false OR 0", (Object)compiled.getSql());
    }
}

