/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.unit.util;

import java.util.ArrayList;
import java.util.Objects;
import java.util.ServiceLoader;
import org.apache.cayenne.di.spi.ModuleProvider;
import org.junit.Assert;

public class ModuleProviderChecker {
    private Class<? extends ModuleProvider> expectedProvider;

    public static void testProviderPresent(Class<? extends ModuleProvider> expectedProvider) {
        new ModuleProviderChecker(expectedProvider).testProviderPresent();
    }

    protected ModuleProviderChecker(Class<? extends ModuleProvider> expectedProvider) {
        this.expectedProvider = Objects.requireNonNull(expectedProvider);
    }

    protected void testProviderPresent() {
        ArrayList<ModuleProvider> providers = new ArrayList<ModuleProvider>();
        for (ModuleProvider p : ServiceLoader.load(ModuleProvider.class)) {
            if (!this.expectedProvider.equals(p.getClass())) continue;
            providers.add(p);
        }
        switch (providers.size()) {
            case 0: {
                Assert.fail((String)("Expected provider '" + this.expectedProvider.getName() + "' is not found"));
                break;
            }
            case 1: {
                break;
            }
            default: {
                Assert.fail((String)("Expected provider '" + this.expectedProvider.getName() + "' is found more then once: " + providers.size()));
            }
        }
    }
}

