/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.unit.di.server;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.DbGenerator;
import org.apache.cayenne.access.dbsync.SkipSchemaUpdateStrategy;
import org.apache.cayenne.access.jdbc.reader.DefaultRowReaderFactory;
import org.apache.cayenne.access.translator.batch.DefaultBatchTranslatorFactory;
import org.apache.cayenne.access.translator.select.DefaultSelectTranslatorFactory;
import org.apache.cayenne.ashwood.AshwoodEntitySorter;
import org.apache.cayenne.cache.MapQueryCache;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.event.DefaultEventManager;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.MapLoader;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.testdo.extended_type.StringET1ExtendedType;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.server.ServerCaseDataSourceFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.InputSource;

public class SchemaBuilder {
    private static Log logger = LogFactory.getLog(SchemaBuilder.class);
    public static final String SKIP_SCHEMA_KEY = "cayenneTestSkipSchemaCreation";
    private static String[] MAPS_REQUIRING_SCHEMA_SETUP = new String[]{"testmap.map.xml", "compound.map.xml", "misc-types.map.xml", "things.map.xml", "numeric-types.map.xml", "binary-pk.map.xml", "no-pk.map.xml", "lob.map.xml", "date-time.map.xml", "enum.map.xml", "extended-type.map.xml", "generated.map.xml", "mixed-persistence-strategy.map.xml", "people.map.xml", "primitive.map.xml", "inheritance.map.xml", "locking.map.xml", "soft-delete.map.xml", "empty.map.xml", "relationships.map.xml", "relationships-activity.map.xml", "relationships-delete-rules.map.xml", "relationships-collection-to-many.map.xml", "relationships-child-master.map.xml", "relationships-clob.map.xml", "relationships-flattened.map.xml", "relationships-set-to-many.map.xml", "relationships-to-many-fk.map.xml", "relationships-to-one-fk.map.xml", "return-types.map.xml", "uuid.map.xml", "multi-tier.map.xml", "reflexive.map.xml", "delete-rules.map.xml", "lifecycle-callbacks-order.map.xml", "lifecycles.map.xml", "map-to-many.map.xml", "toone.map.xml", "meaningful-pk.map.xml", "table-primitives.map.xml", "generic.map.xml", "map-db1.map.xml", "map-db2.map.xml", "embeddable.map.xml", "qualified.map.xml", "quoted-identifiers.map.xml", "inheritance-single-table1.map.xml", "inheritance-vertical.map.xml", "oneway-rels.map.xml", "unsupported-distinct-types.map.xml", "array-type.map.xml", "cay-2032.map.xml"};
    private static final String[] EXTRA_EXCLUDED_FOR_NO_LOB = new String[]{"CLOB_DETAIL"};
    private ServerCaseDataSourceFactory dataSourceFactory;
    private UnitDbAdapter unitDbAdapter;
    private DbAdapter dbAdapter;
    private DataDomain domain;
    private JdbcEventLogger jdbcEventLogger;

    public SchemaBuilder(@Inject ServerCaseDataSourceFactory dataSourceFactory, @Inject UnitDbAdapter unitDbAdapter, @Inject DbAdapter dbAdapter, @Inject JdbcEventLogger jdbcEventLogger) {
        this.dataSourceFactory = dataSourceFactory;
        this.unitDbAdapter = unitDbAdapter;
        this.dbAdapter = dbAdapter;
        this.jdbcEventLogger = jdbcEventLogger;
    }

    public void rebuildSchema() {
        DataMap[] maps = new DataMap[MAPS_REQUIRING_SCHEMA_SETUP.length];
        for (int i = 0; i < maps.length; ++i) {
            InputStream stream = this.getClass().getClassLoader().getResourceAsStream(MAPS_REQUIRING_SCHEMA_SETUP[i]);
            InputSource in = new InputSource(stream);
            in.setSystemId(MAPS_REQUIRING_SCHEMA_SETUP[i]);
            maps[i] = new MapLoader().loadDataMap(in);
        }
        this.domain = new DataDomain("temp");
        this.domain.setEventManager(new DefaultEventManager(2));
        this.domain.setEntitySorter(new AshwoodEntitySorter());
        this.domain.setQueryCache(new MapQueryCache(50));
        try {
            for (DataMap map : maps) {
                this.initNode(map);
            }
            if ("true".equalsIgnoreCase(System.getProperty(SKIP_SCHEMA_KEY))) {
                logger.info((Object)"skipping schema generation... ");
            } else {
                this.dropSchema();
                this.dropPKSupport();
                this.createSchema();
                this.createPKSupport();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error rebuilding schema", e);
        }
    }

    private void initNode(DataMap map) throws Exception {
        DataNode node = new DataNode(map.getName());
        node.setJdbcEventLogger(this.jdbcEventLogger);
        node.setAdapter(this.dbAdapter);
        node.setDataSource(this.dataSourceFactory.getSharedDataSource());
        node.getAdapter().getExtendedTypes().registerType(new StringET1ExtendedType());
        for (Procedure proc : map.getProcedures()) {
            this.unitDbAdapter.tweakProcedure(proc);
        }
        this.filterDataMap(map);
        node.addDataMap(map);
        node.setSchemaUpdateStrategy(new SkipSchemaUpdateStrategy());
        node.setRowReaderFactory(new DefaultRowReaderFactory());
        node.setBatchTranslatorFactory(new DefaultBatchTranslatorFactory());
        node.setSelectTranslatorFactory(new DefaultSelectTranslatorFactory());
        this.domain.addNode(node);
    }

    protected void filterDataMap(DataMap map) {
        boolean supportsBinaryPK = this.unitDbAdapter.supportsBinaryPK();
        if (supportsBinaryPK) {
            return;
        }
        ArrayList<DbEntity> entitiesToRemove = new ArrayList<DbEntity>();
        block0: for (DbEntity ent : map.getDbEntities()) {
            for (DbAttribute attr : ent.getAttributes()) {
                if (attr.getType() != -2 && attr.getType() != -3 && attr.getType() != -4 || !attr.isPrimaryKey() && !attr.isForeignKey()) continue;
                entitiesToRemove.add(ent);
                continue block0;
            }
        }
        for (DbEntity e : entitiesToRemove) {
            map.removeDbEntity(e.getName(), true);
        }
    }

    private void dropSchema() throws Exception {
        for (DataNode node : this.domain.getDataNodes()) {
            this.dropSchema(node, node.getDataMaps().iterator().next());
        }
    }

    private void createSchema() throws Exception {
        for (DataNode node : this.domain.getDataNodes()) {
            this.createSchema(node, node.getDataMaps().iterator().next());
        }
    }

    public void dropPKSupport() throws Exception {
        for (DataNode node : this.domain.getDataNodes()) {
            this.dropPKSupport(node, node.getDataMaps().iterator().next());
        }
    }

    public void createPKSupport() throws Exception {
        for (DataNode node : this.domain.getDataNodes()) {
            this.createPKSupport(node, node.getDataMaps().iterator().next());
        }
    }

    private List<DbEntity> dbEntitiesInInsertOrder(DataNode node, DataMap map) {
        ArrayList<DbEntity> entities = new ArrayList<DbEntity>(map.getDbEntities());
        this.dbEntitiesFilter(entities);
        this.domain.getEntitySorter().sortDbEntities(entities, false);
        return entities;
    }

    protected List<DbEntity> dbEntitiesInDeleteOrder(DataMap dataMap) {
        DataMap map = this.domain.getDataMap(dataMap.getName());
        ArrayList<DbEntity> entities = new ArrayList<DbEntity>(map.getDbEntities());
        this.dbEntitiesFilter(entities);
        this.domain.getEntitySorter().sortDbEntities(entities, true);
        return entities;
    }

    private void dbEntitiesFilter(List<DbEntity> entities) {
        boolean excludeBinPK;
        boolean excludeLOB = !this.unitDbAdapter.supportsLobs();
        boolean bl = excludeBinPK = !this.unitDbAdapter.supportsBinaryPK();
        if (excludeLOB || excludeBinPK) {
            ArrayList<DbEntity> filtered = new ArrayList<DbEntity>();
            for (DbEntity ent : entities) {
                if (excludeLOB) {
                    if (Arrays.binarySearch(EXTRA_EXCLUDED_FOR_NO_LOB, ent.getName()) >= 0) continue;
                    boolean hasLob = false;
                    for (DbAttribute attr : ent.getAttributes()) {
                        if (attr.getType() != 2004 && attr.getType() != 2005) continue;
                        hasLob = true;
                        break;
                    }
                    if (hasLob) continue;
                }
                if (excludeBinPK) {
                    boolean skip = false;
                    for (DbAttribute attr : ent.getAttributes()) {
                        if (attr.getType() != -2 && attr.getType() != -3 && attr.getType() != -4 || !attr.isPrimaryKey() && !attr.isForeignKey()) continue;
                        skip = true;
                        break;
                    }
                    if (skip) continue;
                }
                filtered.add(ent);
            }
            entities = filtered;
        }
    }

    private void dropSchema(DataNode node, DataMap map) throws Exception {
        List<DbEntity> list = this.dbEntitiesInInsertOrder(node, map);
        try (Connection conn = this.dataSourceFactory.getSharedDataSource().getConnection();){
            DatabaseMetaData md = conn.getMetaData();
            ArrayList<String> allTables = new ArrayList<String>();
            try (ResultSet tables = md.getTables(null, null, "%", null);){
                while (tables.next()) {
                    String name = tables.getString("TABLE_NAME");
                    if (name == null) continue;
                    allTables.add(name.toUpperCase());
                }
            }
            this.unitDbAdapter.willDropTables(conn, map, allTables);
            var9_11 = null;
            try (Statement stmt = conn.createStatement();){
                ListIterator<DbEntity> it = list.listIterator(list.size());
                while (it.hasPrevious()) {
                    DbEntity ent = it.previous();
                    if (!allTables.contains(ent.getName().toUpperCase())) continue;
                    for (String dropSql : node.getAdapter().dropTableStatements(ent)) {
                        try {
                            logger.info((Object)dropSql);
                            stmt.execute(dropSql);
                        }
                        catch (SQLException sqe) {
                            logger.warn((Object)("Can't drop table " + ent.getName() + ", ignoring..."), (Throwable)sqe);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                var9_11 = throwable;
                throw throwable;
            }
            this.unitDbAdapter.droppedTables(conn, map);
        }
    }

    private void dropPKSupport(DataNode node, DataMap map) throws Exception {
        List<DbEntity> filteredEntities = this.dbEntitiesInInsertOrder(node, map);
        node.getAdapter().getPkGenerator().dropAutoPk(node, filteredEntities);
    }

    private void createPKSupport(DataNode node, DataMap map) throws Exception {
        List<DbEntity> filteredEntities = this.dbEntitiesInInsertOrder(node, map);
        node.getAdapter().getPkGenerator().createAutoPk(node, filteredEntities);
    }

    private void createSchema(DataNode node, DataMap map) throws Exception {
        try (Connection conn = this.dataSourceFactory.getSharedDataSource().getConnection();){
            this.unitDbAdapter.willCreateTables(conn, map);
            try (Statement stmt = conn.createStatement();){
                for (String query : this.tableCreateQueries(node, map)) {
                    logger.info((Object)query);
                    stmt.execute(query);
                }
            }
            this.unitDbAdapter.createdTables(conn, map);
        }
    }

    private Collection<String> tableCreateQueries(DataNode node, DataMap map) throws Exception {
        DbAdapter adapter = node.getAdapter();
        DbGenerator gen = new DbGenerator(adapter, map, null, this.domain, this.jdbcEventLogger);
        List<DbEntity> orderedEnts = this.dbEntitiesInInsertOrder(node, map);
        ArrayList<String> queries = new ArrayList<String>();
        for (DbEntity ent : orderedEnts) {
            queries.add(adapter.createTable(ent));
        }
        for (DbEntity ent : orderedEnts) {
            if (!this.unitDbAdapter.supportsFKConstraints(ent)) continue;
            List<String> qs = gen.createConstraintsQueries(ent);
            queries.addAll(qs);
        }
        return queries;
    }
}

