/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.Property;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.FluentSelect;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;

public class ColumnSelect<T>
extends FluentSelect<T, ColumnSelect<T>> {
    private Collection<Property<?>> columns;
    private boolean havingExpressionIsActive = false;
    boolean singleColumn = true;
    private Expression having;

    protected ColumnSelect() {
    }

    protected ColumnSelect(ObjectSelect<T> select) {
        this.name = select.name;
        this.entityType = select.entityType;
        this.entityName = select.entityName;
        this.dbEntityName = select.dbEntityName;
        this.where = select.where;
        this.orderings = select.orderings;
        this.prefetches = select.prefetches;
        this.limit = select.limit;
        this.offset = select.offset;
        this.pageSize = select.pageSize;
        this.statementFetchSize = select.statementFetchSize;
        this.cacheStrategy = select.cacheStrategy;
        this.cacheGroup = select.cacheGroup;
    }

    @Override
    protected Query createReplacementQuery(EntityResolver resolver) {
        SelectQuery replacement = (SelectQuery)super.createReplacementQuery(resolver);
        replacement.setColumns(this.columns);
        replacement.setHavingQualifier(this.having);
        replacement.setCanReturnScalarValue(this.singleColumn);
        return replacement;
    }

    public ColumnSelect<Object[]> columns(Property<?> firstProperty, Property<?> ... otherProperties) {
        if (this.columns == null) {
            this.columns = new ArrayList(otherProperties.length + 1);
        }
        this.columns.add(firstProperty);
        Collections.addAll(this.columns, otherProperties);
        this.singleColumn = false;
        return this;
    }

    public ColumnSelect<Object[]> columns(Collection<Property<?>> properties) {
        if (properties == null) {
            throw new NullPointerException("properties is null");
        }
        if (properties.isEmpty()) {
            throw new IllegalArgumentException("properties must contain at least one element");
        }
        if (this.columns == null) {
            this.columns = new ArrayList(properties.size());
        }
        this.columns.addAll(properties);
        this.singleColumn = false;
        return this;
    }

    protected <E> ColumnSelect<E> column(Property<E> property) {
        if (this.columns == null) {
            this.columns = new ArrayList(1);
        } else {
            this.columns.clear();
        }
        this.columns.add(property);
        return this;
    }

    public ColumnSelect<Object[]> count() {
        return this.columns(Property.COUNT, new Property[0]);
    }

    public ColumnSelect<Object[]> count(Property<?> property) {
        return this.columns(property.count(), new Property[0]);
    }

    public ColumnSelect<Object[]> min(Property<?> property) {
        return this.columns(property.min(), new Property[0]);
    }

    public ColumnSelect<Object[]> max(Property<?> property) {
        return this.columns(property.max(), new Property[0]);
    }

    public ColumnSelect<Object[]> avg(Property<?> property) {
        return this.columns(property.avg(), new Property[0]);
    }

    public <E extends Number> ColumnSelect<Object[]> sum(Property<E> property) {
        return this.columns(property.sum(), new Property[0]);
    }

    public ColumnSelect<T> having(Expression expression) {
        this.havingExpressionIsActive = true;
        return (ColumnSelect)this.and(expression);
    }

    public ColumnSelect<T> having(String expressionString, Object ... parameters) {
        this.havingExpressionIsActive = true;
        return (ColumnSelect)this.and(ExpressionFactory.exp(expressionString, parameters));
    }

    @Override
    public ColumnSelect<T> and(Collection<Expression> expressions) {
        Collection<Expression> all;
        if (expressions == null || expressions.isEmpty()) {
            return this;
        }
        Expression activeExpression = this.getActiveExpression();
        if (activeExpression != null) {
            all = new ArrayList<Expression>(expressions.size() + 1);
            all.add(activeExpression);
            all.addAll(expressions);
        } else {
            all = expressions;
        }
        this.setActiveExpression(ExpressionFactory.and(all));
        return this;
    }

    @Override
    public ColumnSelect<T> or(Collection<Expression> expressions) {
        Collection<Expression> all;
        if (expressions == null || expressions.isEmpty()) {
            return this;
        }
        Expression activeExpression = this.getActiveExpression();
        if (activeExpression != null) {
            all = new ArrayList<Expression>(expressions.size() + 1);
            all.add(activeExpression);
            all.addAll(expressions);
        } else {
            all = expressions;
        }
        this.setActiveExpression(ExpressionFactory.or(all));
        return this;
    }

    private void setActiveExpression(Expression exp) {
        if (this.havingExpressionIsActive) {
            this.having = exp;
        } else {
            this.where = exp;
        }
    }

    private Expression getActiveExpression() {
        if (this.havingExpressionIsActive) {
            return this.having;
        }
        return this.where;
    }

    public Collection<Property<?>> getColumns() {
        return this.columns;
    }

    public Expression getHaving() {
        return this.having;
    }
}

