/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.io.IOException;
import java.math.BigDecimal;
import org.apache.cayenne.exp.parser.ASTEqual;
import org.apache.cayenne.exp.parser.ASTObjPath;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.junit.Assert;
import org.junit.Test;

public class ASTEqualTest {
    @Test
    public void testToEJBQL() {
        ASTEqual e = new ASTEqual(new ASTObjPath("artistName"), "bla");
        Assert.assertEquals((Object)"x.artistName = 'bla'", (Object)e.toEJBQL("x"));
    }

    @Test
    public void testAppendAsEJBQL() throws IOException {
        ASTEqual e = new ASTEqual(new ASTObjPath("artistName"), "bla");
        StringBuilder buffer = new StringBuilder();
        e.appendAsEJBQL(buffer, "x");
        String ejbql = buffer.toString();
        Assert.assertEquals((Object)"x.artistName = 'bla'", (Object)ejbql);
    }

    @Test
    public void testEvaluate() {
        ASTEqual equalTo = new ASTEqual(new ASTObjPath("artistName"), "abc");
        Artist match = new Artist();
        match.setArtistName("abc");
        Assert.assertTrue((boolean)equalTo.match(match));
        Artist noMatch = new Artist();
        noMatch.setArtistName("123");
        Assert.assertFalse((String)("Failed: " + equalTo), (boolean)equalTo.match(noMatch));
    }

    @Test
    public void testEvaluate_Null() {
        ASTEqual equalToNull = new ASTEqual(new ASTObjPath("artistName"), null);
        ASTEqual equalToNotNull = new ASTEqual(new ASTObjPath("artistName"), "abc");
        Artist match = new Artist();
        Assert.assertTrue((boolean)equalToNull.match(match));
        Assert.assertFalse((boolean)equalToNotNull.match(match));
        Artist noMatch = new Artist();
        noMatch.setArtistName("abc");
        Assert.assertFalse((boolean)equalToNull.match(noMatch));
    }

    @Test
    public void testEvaluate_BigDecimal() {
        BigDecimal bd1 = new BigDecimal("2.0");
        BigDecimal bd2 = new BigDecimal("2.0");
        BigDecimal bd3 = new BigDecimal("2.00");
        BigDecimal bd4 = new BigDecimal("2.01");
        ASTEqual equalTo = new ASTEqual(new ASTObjPath(Painting.ESTIMATED_PRICE.getName()), bd1);
        Painting p = new Painting();
        p.setEstimatedPrice(bd2);
        Assert.assertTrue((boolean)equalTo.match(p));
        p.setEstimatedPrice(bd3);
        Assert.assertTrue((boolean)equalTo.match(p));
        p.setEstimatedPrice(bd4);
        Assert.assertFalse((boolean)equalTo.match(p));
    }
}

