/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.parser.ASTConcat;
import org.apache.cayenne.exp.parser.ASTObjPath;
import org.apache.cayenne.exp.parser.ASTScalar;
import org.apache.cayenne.testdo.testmap.Artist;
import org.junit.Assert;
import org.junit.Test;

public class ASTConcatTest {
    @Test
    public void testEvaluateConcat() throws Exception {
        ASTObjPath path = new ASTObjPath("artistName");
        ASTScalar scalar = new ASTScalar(" ");
        ASTScalar scalar1 = new ASTScalar("test");
        ASTConcat concat = new ASTConcat(path, scalar, scalar1);
        Artist a = new Artist();
        a.setArtistName("name");
        Object res = concat.evaluateNode(a);
        Assert.assertTrue((boolean)(res instanceof String));
        Assert.assertEquals((Object)"name test", (Object)res);
    }

    @Test
    public void testParseConcat() throws Exception {
        Expression exp = ExpressionFactory.exp("CONCAT(artistName, ' ', 'test')", new Object[0]);
        Assert.assertEquals(ASTConcat.class, exp.getClass());
        Assert.assertEquals((long)3L, (long)exp.getOperandCount());
        Artist a = new Artist();
        a.setArtistName("name");
        Object res = exp.evaluate(a);
        Assert.assertTrue((boolean)(res instanceof String));
        Assert.assertEquals((Object)"name test", (Object)res);
    }

    @Test
    public void parseTest() throws Exception {
        String expString = "CONCAT(xyz , \" \" , abc)";
        Expression exp = ExpressionFactory.exp(expString, new Object[0]);
        Assert.assertTrue((boolean)(exp instanceof ASTConcat));
        String toString = exp.toString();
        Assert.assertEquals((Object)expString, (Object)toString);
    }
}

