/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.oracle;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.List;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.translator.select.QualifierTranslator;
import org.apache.cayenne.access.translator.select.QueryAssembler;
import org.apache.cayenne.access.translator.select.SelectTranslator;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.access.types.ExtendedTypeFactory;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.dba.oracle.Oracle8ActionBuilder;
import org.apache.cayenne.dba.oracle.Oracle8QualifierTranslator;
import org.apache.cayenne.dba.oracle.Oracle8SelectTranslator;
import org.apache.cayenne.dba.oracle.OracleAdapter;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.resource.ResourceLocator;

public class Oracle8Adapter
extends OracleAdapter {
    private static Method outputStreamFromBlobMethod;
    private static Method writerFromClobMethod;

    public Oracle8Adapter(@Inject RuntimeProperties runtimeProperties, @Inject(value="cayenne.server.default_types") List<ExtendedType> defaultExtendedTypes, @Inject(value="cayenne.server.user_types") List<ExtendedType> userExtendedTypes, @Inject(value="cayenne.server.type_factories") List<ExtendedTypeFactory> extendedTypeFactories, @Inject(value="cayenne.server.resource_locator") ResourceLocator resourceLocator) {
        super(runtimeProperties, defaultExtendedTypes, userExtendedTypes, extendedTypeFactories, resourceLocator);
    }

    private static void initOracle8DriverInformation() {
        initDone = true;
        try {
            outputStreamFromBlobMethod = Class.forName("oracle.sql.BLOB").getMethod("getBinaryOutputStream", new Class[0]);
            writerFromClobMethod = Class.forName("oracle.sql.CLOB").getMethod("getCharacterOutputStream", new Class[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static Method getWriterFromClobMethod() {
        return writerFromClobMethod;
    }

    static Method getOutputStreamFromBlobMethod() {
        return outputStreamFromBlobMethod;
    }

    @Override
    public SelectTranslator getSelectTranslator(SelectQuery<?> query, EntityResolver entityResolver) {
        return new Oracle8SelectTranslator(query, this, entityResolver);
    }

    @Override
    public SQLAction getAction(Query query, DataNode node) {
        return query.createSQLAction(new Oracle8ActionBuilder(node));
    }

    @Override
    protected URL findResource(String name) {
        if ("/types.xml".equals(name)) {
            name = "/types-oracle8.xml";
        }
        return super.findResource(name);
    }

    @Override
    public QualifierTranslator getQualifierTranslator(QueryAssembler queryAssembler) {
        Oracle8QualifierTranslator translator = new Oracle8QualifierTranslator(queryAssembler);
        translator.setCaseInsensitive(this.caseInsensitiveCollations);
        return translator;
    }

    static {
        Oracle8Adapter.initOracle8DriverInformation();
    }
}

