/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.derby;

import java.io.IOException;
import org.apache.cayenne.access.translator.select.QueryAssembler;
import org.apache.cayenne.access.translator.select.TrimmingQualifierTranslator;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.parser.ASTEqual;
import org.apache.cayenne.exp.parser.ASTFunctionCall;
import org.apache.cayenne.exp.parser.ASTNotEqual;
import org.apache.cayenne.exp.parser.SimpleNode;
import org.apache.cayenne.map.DbAttribute;

public class DerbyQualifierTranslator
extends TrimmingQualifierTranslator {
    public DerbyQualifierTranslator(QueryAssembler queryAssembler, String trimFunction) {
        super(queryAssembler, trimFunction);
    }

    @Override
    protected void processColumnWithQuoteSqlIdentifiers(DbAttribute dbAttr, Expression pathExp) {
        SimpleNode parent = null;
        if (pathExp instanceof SimpleNode) {
            parent = (SimpleNode)((SimpleNode)pathExp).jjtGetParent();
        }
        if (parent != null && (parent instanceof ASTEqual || parent instanceof ASTNotEqual) && dbAttr.getType() == 2005 && parent.getOperandCount() == 2 && parent.getOperand(1) instanceof String) {
            Integer size = parent.getOperand(1).toString().length() + 1;
            this.out.append("CAST(");
            super.processColumnWithQuoteSqlIdentifiers(dbAttr, pathExp);
            this.out.append(" AS VARCHAR(").append(size).append("))");
        } else {
            super.processColumnWithQuoteSqlIdentifiers(dbAttr, pathExp);
        }
    }

    @Override
    protected void appendFunction(ASTFunctionCall functionExpression) {
        if ("SUBSTRING".equals(functionExpression.getFunctionName())) {
            this.out.append("SUBSTR");
        } else if ("CONCAT".equals(functionExpression.getFunctionName())) {
            this.out.append("");
        } else {
            super.appendFunction(functionExpression);
        }
    }

    @Override
    protected void appendFunctionArg(Object value, ASTFunctionCall functionExpression) throws IOException {
        if ("CONCAT".equals(functionExpression.getFunctionName())) {
            if (value instanceof String) {
                this.out.append("CAST(");
            }
            super.appendFunctionArg(value, functionExpression);
            if (value instanceof String) {
                this.clearLastFunctionArgDivider(functionExpression);
                this.out.append(" AS VARCHAR(").append(((String)value).length()).append("))");
                this.appendFunctionArgDivider(functionExpression);
            }
        } else {
            super.appendFunctionArg(value, functionExpression);
        }
    }

    @Override
    protected void appendFunctionArgDivider(ASTFunctionCall functionExpression) {
        if ("CONCAT".equals(functionExpression.getFunctionName())) {
            this.out.append(" || ");
        } else {
            super.appendFunctionArgDivider(functionExpression);
        }
    }

    @Override
    protected void clearLastFunctionArgDivider(ASTFunctionCall functionExpression) {
        if ("CONCAT".equals(functionExpression.getFunctionName())) {
            this.out.delete(this.out.length() - 4, this.out.length());
        } else {
            super.clearLastFunctionArgDivider(functionExpression);
        }
    }
}

