/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.cache;

import java.io.Serializable;
import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.cache.QueryCache;
import org.apache.cayenne.cache.QueryCacheEntryFactory;
import org.apache.cayenne.di.BeforeScopeEnd;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Deprecated
public class EhCacheQueryCache
implements QueryCache {
    private static final String DEFAULT_CACHE_NAME = "cayenne.default.cachegroup";
    private static final Log logger = LogFactory.getLog(EhCacheQueryCache.class);
    protected CacheManager cacheManager;

    public EhCacheQueryCache() {
        this.cacheManager = new CacheManager();
        this.init();
    }

    public EhCacheQueryCache(String configFile) {
        this.cacheManager = new CacheManager(configFile);
        this.init();
    }

    public EhCacheQueryCache(CacheManager cacheManager) {
        if (cacheManager == null) {
            throw new CayenneRuntimeException("CacheManager cannot be null.", new Object[0]);
        }
        this.cacheManager = cacheManager;
        this.init();
    }

    private void init() {
        this.cacheManager.addCacheIfAbsent(DEFAULT_CACHE_NAME);
    }

    @Override
    public List get(QueryMetadata metadata) {
        String key = metadata.getCacheKey();
        if (key == null) {
            return null;
        }
        String cacheName = this.cacheName(metadata);
        Cache cache = this.cacheManager.getCache(cacheName);
        if (cache == null) {
            return null;
        }
        Element result = cache.get((Serializable)((Object)key));
        return result != null ? (List)result.getObjectValue() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List get(QueryMetadata metadata, QueryCacheEntryFactory factory) {
        String key = metadata.getCacheKey();
        if (key == null) {
            return null;
        }
        String cacheName = this.cacheName(metadata);
        Ehcache cache = this.cacheManager.addCacheIfAbsent(cacheName);
        Element result = cache.get((Serializable)((Object)key));
        if (result != null) {
            return (List)result.getObjectValue();
        }
        cache.acquireWriteLockOnKey((Object)key);
        try {
            result = cache.get((Serializable)((Object)key));
            if (result != null) {
                List list = (List)result.getObjectValue();
                return list;
            }
            List object = factory.createObject();
            if (object == null) {
                throw new CayenneRuntimeException("Null object created: " + metadata.getCacheKey(), new Object[0]);
            }
            cache.put(new Element((Object)key, (Object)object));
            List list = object;
            return list;
        }
        finally {
            cache.releaseWriteLockOnKey((Object)key);
        }
    }

    protected String cacheName(QueryMetadata metadata) {
        if (metadata.getCacheGroup() != null) {
            return metadata.getCacheGroup();
        }
        return DEFAULT_CACHE_NAME;
    }

    @Override
    public void put(QueryMetadata metadata, List results) {
        String key = metadata.getCacheKey();
        if (key != null) {
            String cacheName = this.cacheName(metadata);
            Ehcache cache = this.cacheManager.addCacheIfAbsent(cacheName);
            cache.put(new Element((Object)key, (Object)results));
        }
    }

    @Override
    public void remove(String key) {
        if (key != null) {
            for (String cache : this.cacheManager.getCacheNames()) {
                this.cacheManager.getCache(cache).remove((Serializable)((Object)key));
            }
        }
    }

    @Override
    public void removeGroup(String groupKey) {
        Ehcache cache = this.cacheManager.getEhcache(groupKey);
        if (cache != null) {
            cache.removeAll();
        }
    }

    @Override
    public void clear() {
        this.cacheManager.removalAll();
    }

    @Override
    public int size() {
        int size = 0;
        for (String cache : this.cacheManager.getCacheNames()) {
            size += this.cacheManager.getCache(cache).getSize();
        }
        return size;
    }

    @Deprecated
    public Ehcache getDefaultCache() {
        return this.cacheManager.getCache(DEFAULT_CACHE_NAME);
    }

    @BeforeScopeEnd
    public void shutdown() {
        this.cacheManager.shutdown();
    }
}

