/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc.reader;

import java.sql.ResultSet;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.jdbc.RowDescriptor;
import org.apache.cayenne.access.jdbc.reader.RowReader;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.query.ScalarResultSegment;
import org.apache.cayenne.util.Util;

class ScalarRowReader<T>
implements RowReader<T> {
    private ExtendedType converter;
    private int index;
    private int type;

    ScalarRowReader(RowDescriptor descriptor, ScalarResultSegment segmentMetadata) {
        int scalarIndex = segmentMetadata.getColumnOffset();
        this.converter = descriptor.getConverters()[scalarIndex];
        this.type = descriptor.getColumns()[scalarIndex].getJdbcType();
        this.index = scalarIndex + 1;
    }

    @Override
    public T readRow(ResultSet resultSet) {
        try {
            return this.converter.materializeObject(resultSet, this.index, this.type);
        }
        catch (CayenneRuntimeException cex) {
            throw cex;
        }
        catch (Exception otherex) {
            throw new CayenneRuntimeException("Exception materializing column.", Util.unwindException(otherex), new Object[0]);
        }
    }
}

