/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.HierarchicalObjectResolver;
import org.apache.cayenne.access.PrefetchProcessorNode;
import org.apache.cayenne.access.PrefetchProcessorTreeBuilder;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.MockQueryMetadata;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Gallery;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class PrefetchProcessorTreeBuilderIT
extends ServerCase {
    @Inject
    private DataContext context;
    @Inject
    private EntityResolver resolver;

    @Test
    public void testBuildTreeNoPrefetches() {
        final ClassDescriptor descriptor = this.resolver.getClassDescriptor("Artist");
        ArrayList<DataRow> dataRows = new ArrayList<DataRow>();
        dataRows.add(new DataRow(4));
        dataRows.add(new DataRow(4));
        MockQueryMetadata metadata = new MockQueryMetadata(){

            @Override
            public ClassDescriptor getClassDescriptor() {
                return descriptor;
            }

            @Override
            public ObjEntity getObjEntity() {
                return descriptor.getEntity();
            }

            @Override
            public DbEntity getDbEntity() {
                return this.getObjEntity().getDbEntity();
            }

            @Override
            public DataMap getDataMap() {
                return this.getObjEntity().getDataMap();
            }

            @Override
            public boolean isRefreshingObjects() {
                return true;
            }

            @Override
            public boolean isResolvingInherited() {
                return true;
            }
        };
        PrefetchTreeNode tree = new PrefetchTreeNode();
        HierarchicalObjectResolver resolver = new HierarchicalObjectResolver(this.context, metadata);
        PrefetchProcessorTreeBuilder builder = new PrefetchProcessorTreeBuilder(resolver, dataRows, new HashMap());
        PrefetchProcessorNode processingTree = builder.buildTree(tree);
        Assert.assertTrue((boolean)processingTree.getChildren().isEmpty());
        Assert.assertFalse((boolean)processingTree.isPhantom());
        Assert.assertFalse((boolean)processingTree.isPartitionedByParent());
        Assert.assertTrue((boolean)processingTree.isDisjointPrefetch());
        Assert.assertSame(dataRows, (Object)processingTree.getDataRows());
        Assert.assertSame((Object)descriptor.getEntity(), (Object)processingTree.getResolver().getEntity());
        Assert.assertNull((Object)processingTree.getIncoming());
    }

    @Test
    public void testBuildTreeWithPrefetches() {
        final ClassDescriptor descriptor = this.resolver.getClassDescriptor("Artist");
        ObjEntity e2 = this.resolver.getObjEntity("Painting");
        ObjEntity e3 = this.resolver.getObjEntity("Gallery");
        ObjEntity e4 = this.resolver.getObjEntity("Exhibit");
        ObjEntity e5 = this.resolver.getObjEntity("ArtistExhibit");
        ArrayList mainRows = new ArrayList();
        HashMap extraRows = new HashMap();
        PrefetchTreeNode tree = new PrefetchTreeNode();
        tree.addPath(Artist.PAINTING_ARRAY.getName()).setPhantom(false);
        tree.addPath(Artist.PAINTING_ARRAY.dot(Painting.TO_GALLERY).dot(Gallery.EXHIBIT_ARRAY).getName()).setPhantom(false);
        tree.addPath(Artist.ARTIST_EXHIBIT_ARRAY.getName()).setPhantom(false);
        MockQueryMetadata metadata = new MockQueryMetadata(){

            @Override
            public ClassDescriptor getClassDescriptor() {
                return descriptor;
            }

            @Override
            public ObjEntity getObjEntity() {
                return descriptor.getEntity();
            }

            @Override
            public DbEntity getDbEntity() {
                return this.getObjEntity().getDbEntity();
            }

            @Override
            public DataMap getDataMap() {
                return this.getObjEntity().getDataMap();
            }

            @Override
            public boolean isRefreshingObjects() {
                return true;
            }

            @Override
            public boolean isResolvingInherited() {
                return true;
            }
        };
        HierarchicalObjectResolver resolver = new HierarchicalObjectResolver(this.context, metadata);
        PrefetchProcessorTreeBuilder builder = new PrefetchProcessorTreeBuilder(resolver, mainRows, extraRows);
        PrefetchProcessorNode n1 = builder.buildTree(tree);
        Assert.assertSame(mainRows, (Object)n1.getDataRows());
        Assert.assertSame((Object)descriptor.getEntity(), (Object)n1.getResolver().getEntity());
        PrefetchProcessorNode n2 = (PrefetchProcessorNode)n1.getNode("paintingArray");
        Assert.assertNotNull((Object)n2);
        Assert.assertSame((Object)e2, (Object)n2.getResolver().getEntity());
        Assert.assertFalse((boolean)n2.isPhantom());
        Assert.assertTrue((boolean)n2.isPartitionedByParent());
        PrefetchProcessorNode n3 = (PrefetchProcessorNode)n1.getNode("paintingArray.toGallery");
        Assert.assertNotNull((Object)n3);
        Assert.assertSame((Object)e3, (Object)n3.getResolver().getEntity());
        Assert.assertTrue((boolean)n3.isPhantom());
        Assert.assertTrue((boolean)n3.isPartitionedByParent());
        PrefetchProcessorNode n4 = (PrefetchProcessorNode)n1.getNode("paintingArray.toGallery.exhibitArray");
        Assert.assertNotNull((Object)n4);
        Assert.assertSame((Object)e4, (Object)n4.getResolver().getEntity());
        Assert.assertFalse((boolean)n4.isPhantom());
        Assert.assertTrue((boolean)n4.isPartitionedByParent());
        PrefetchProcessorNode n5 = (PrefetchProcessorNode)n1.getNode("artistExhibitArray");
        Assert.assertNotNull((Object)n5);
        Assert.assertSame((Object)e5, (Object)n5.getResolver().getEntity());
        Assert.assertFalse((boolean)n5.isPhantom());
        Assert.assertTrue((boolean)n5.isPartitionedByParent());
    }
}

