/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.util.Date;
import java.util.List;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Exhibit;
import org.apache.cayenne.testdo.testmap.Gallery;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.apache.cayenne.validation.BeanValidationFailure;
import org.apache.cayenne.validation.ValidationFailure;
import org.apache.cayenne.validation.ValidationResult;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class CayenneDataObjectValidationIT
extends ServerCase {
    @Inject
    private ObjectContext context;

    @Test
    public void testValidateForSaveMandatoryToOneMissing() throws Exception {
        Exhibit exhibit = this.context.newObject(Exhibit.class);
        exhibit.setOpeningDate(new Date());
        exhibit.setClosingDate(new Date());
        ValidationResult result = new ValidationResult();
        exhibit.validateForSave(result);
        Assert.assertTrue((String)"Validation of 'toGallery' should've failed.", (boolean)result.hasFailures());
        Assert.assertTrue((boolean)result.hasFailures(exhibit));
        List<ValidationFailure> failures = result.getFailures();
        Assert.assertEquals((long)1L, (long)failures.size());
        BeanValidationFailure failure = (BeanValidationFailure)failures.get(0);
        Assert.assertEquals((Object)Exhibit.TO_GALLERY.getName(), (Object)failure.getProperty());
        Gallery gallery = this.context.newObject(Gallery.class);
        exhibit.setToGallery(gallery);
        result = new ValidationResult();
        exhibit.validateForSave(result);
        Assert.assertFalse((String)("No failures expected: " + result), (boolean)result.hasFailures());
    }

    @Test
    public void testValidateForSaveMandatoryAttributeMissing() throws Exception {
        Artist artist = this.context.newObject(Artist.class);
        ValidationResult result = new ValidationResult();
        artist.validateForSave(result);
        Assert.assertTrue((String)"Validation of 'artistName' should've failed.", (boolean)result.hasFailures());
        Assert.assertTrue((boolean)result.hasFailures(artist));
        List<ValidationFailure> failures = result.getFailures();
        Assert.assertEquals((long)1L, (long)failures.size());
        BeanValidationFailure failure = (BeanValidationFailure)failures.get(0);
        Assert.assertEquals((Object)Artist.ARTIST_NAME.getName(), (Object)failure.getProperty());
        artist.setArtistName("aa");
        result = new ValidationResult();
        artist.validateForSave(result);
        Assert.assertFalse((boolean)result.hasFailures());
    }

    @Test
    public void testValidateForSaveAttributeTooLong() throws Exception {
        Artist artist = this.context.newObject(Artist.class);
        DbEntity entity = this.context.getEntityResolver().getObjEntity(artist).getDbEntity();
        int len = entity.getAttribute("ARTIST_NAME").getMaxLength();
        StringBuffer buf = new StringBuffer(len);
        for (int i = 0; i < len + 1; ++i) {
            buf.append("c");
        }
        artist.setArtistName(buf.toString());
        ValidationResult result = new ValidationResult();
        artist.validateForSave(result);
        Assert.assertTrue((boolean)result.hasFailures());
        Assert.assertTrue((boolean)result.hasFailures(artist));
        List<ValidationFailure> failures = result.getFailures();
        Assert.assertEquals((long)1L, (long)failures.size());
        BeanValidationFailure failure = (BeanValidationFailure)failures.get(0);
        Assert.assertEquals((Object)Artist.ARTIST_NAME.getName(), (Object)failure.getProperty());
        artist.setArtistName("aa");
        result = new ValidationResult();
        artist.validateForSave(result);
        Assert.assertFalse((boolean)result.hasFailures());
    }
}

