/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.util.ArrayList;
import java.util.Set;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.relationships_set_to_many.SetToMany;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-relationships-set-to-many.xml")
public class CayenneDataObjectSetToManySetIT
extends ServerCase {
    @Inject
    protected ObjectContext context;
    @Inject
    protected DBHelper dbHelper;
    protected TableHelper tSetToMany;
    protected TableHelper tSetToManyTarget;

    @Before
    public void setUp() throws Exception {
        this.tSetToMany = new TableHelper(this.dbHelper, "SET_TO_MANY");
        this.tSetToMany.setColumns(new String[]{"ID"});
        this.tSetToManyTarget = new TableHelper(this.dbHelper, "SET_TO_MANY_TARGET");
        this.tSetToManyTarget.setColumns(new String[]{"ID", "SET_TO_MANY_ID"});
    }

    protected void createTestDataSet() throws Exception {
        this.tSetToMany.insert(new Object[]{1});
        this.tSetToMany.insert(new Object[]{2});
        this.tSetToManyTarget.insert(new Object[]{1, 1});
        this.tSetToManyTarget.insert(new Object[]{2, 1});
        this.tSetToManyTarget.insert(new Object[]{3, 1});
        this.tSetToManyTarget.insert(new Object[]{4, 2});
    }

    @Test
    public void testRelationCollectionTypeMap() throws Exception {
        this.createTestDataSet();
        SetToMany o1 = Cayenne.objectForPK(this.context, SetToMany.class, 1);
        Assert.assertTrue((boolean)(o1.readProperty(SetToMany.TARGETS.getName()) instanceof Set));
        boolean catchedSomething = false;
        try {
            o1.setToManyTarget(SetToMany.TARGETS.getName(), new ArrayList(0), true);
        }
        catch (RuntimeException e) {
            catchedSomething = true;
        }
        Assert.assertEquals((Object)catchedSomething, (Object)false);
        Assert.assertEquals((long)o1.getTargets().size(), (long)0L);
    }
}

