/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.remote.hessian.service;

import com.caucho.hessian.io.AbstractSerializerFactory;
import com.caucho.hessian.io.Deserializer;
import com.caucho.hessian.io.HessianProtocolException;
import com.caucho.hessian.io.JavaSerializer;
import com.caucho.hessian.io.Serializer;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.remote.hessian.service.ServerDataRowSerializer;
import org.apache.cayenne.remote.hessian.service.ServerPersistentObjectListSerializer;
import org.apache.cayenne.util.PersistentObjectList;
import org.apache.cayenne.util.PersistentObjectMap;

public class ServerSerializerFactory
extends AbstractSerializerFactory {
    private ServerPersistentObjectListSerializer persistentObjectListSerializer = new ServerPersistentObjectListSerializer();
    private ServerDataRowSerializer dataRowSerilaizer = new ServerDataRowSerializer();
    private Serializer javaSerializer;

    ServerSerializerFactory() {
    }

    public Serializer getSerializer(Class cl) throws HessianProtocolException {
        if (PersistentObjectList.class.isAssignableFrom(cl)) {
            return this.persistentObjectListSerializer;
        }
        if (DataRow.class.isAssignableFrom(cl)) {
            return this.dataRowSerilaizer;
        }
        if (PersistentObjectMap.class.isAssignableFrom(cl)) {
            if (this.javaSerializer == null) {
                this.javaSerializer = new JavaSerializer(cl);
            }
            return this.javaSerializer;
        }
        return null;
    }

    public Deserializer getDeserializer(Class cl) throws HessianProtocolException {
        return null;
    }
}

