/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.parser.SimpleNode;
import org.apache.cayenne.util.ConversionUtil;

public class ASTDivide
extends SimpleNode {
    private static final long serialVersionUID = -5086569683844539310L;

    ASTDivide(int id) {
        super(id);
    }

    public ASTDivide() {
        super(30);
    }

    public ASTDivide(Object[] nodes) {
        super(30);
        int len = nodes.length;
        for (int i = 0; i < len; ++i) {
            this.jjtAddChild(this.wrapChild(nodes[i]), i);
        }
        this.connectChildren();
    }

    public ASTDivide(Collection<?> nodes) {
        super(30);
        int len = nodes.size();
        Iterator<?> it = nodes.iterator();
        for (int i = 0; i < len; ++i) {
            this.jjtAddChild(this.wrapChild(it.next()), i);
        }
        this.connectChildren();
    }

    @Override
    protected Object evaluateNode(Object o) throws Exception {
        int len = this.jjtGetNumChildren();
        if (len == 0) {
            return null;
        }
        BigDecimal result = null;
        for (int i = 0; i < len; ++i) {
            BigDecimal value = ConversionUtil.toBigDecimal(this.evaluateChild(i, o));
            if (value == null) {
                return null;
            }
            result = i == 0 ? value : result.divide(value, 6);
        }
        return result;
    }

    @Override
    public Expression shallowCopy() {
        return new ASTDivide(this.id);
    }

    @Override
    protected String getExpressionOperator(int index) {
        return "/";
    }

    @Override
    public int getType() {
        return 19;
    }

    @Override
    public void jjtClose() {
        super.jjtClose();
        this.flattenTree();
    }
}

